<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MsfAgencyFeeDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Merchant Service Fee detail
 * @subpackage Structs
 */
class MsfAgencyFeeDetail extends AbstractStructBase
{
    /**
     * The MsfAgencyProfileId
     * @var string
     */
    public $MsfAgencyProfileId;
    /**
     * The MerchantAccountNumber
     * @var string
     */
    public $MerchantAccountNumber;
    /**
     * The FederalTaxId
     * @var string
     */
    public $FederalTaxId;
    /**
     * Constructor method for MsfAgencyFeeDetail
     * @uses MsfAgencyFeeDetail::setMsfAgencyProfileId()
     * @uses MsfAgencyFeeDetail::setMerchantAccountNumber()
     * @uses MsfAgencyFeeDetail::setFederalTaxId()
     * @param string $msfAgencyProfileId
     * @param string $merchantAccountNumber
     * @param string $federalTaxId
     */
    public function __construct($msfAgencyProfileId = null, $merchantAccountNumber = null, $federalTaxId = null)
    {
        $this
            ->setMsfAgencyProfileId($msfAgencyProfileId)
            ->setMerchantAccountNumber($merchantAccountNumber)
            ->setFederalTaxId($federalTaxId);
    }
    /**
     * Get MsfAgencyProfileId value
     * @return string|null
     */
    public function getMsfAgencyProfileId()
    {
        return $this->MsfAgencyProfileId;
    }
    /**
     * Set MsfAgencyProfileId value
     * @param string $msfAgencyProfileId
     * @return \StructType\MsfAgencyFeeDetail
     */
    public function setMsfAgencyProfileId($msfAgencyProfileId = null)
    {
        // validation for constraint: string
        if (!is_null($msfAgencyProfileId) && !is_string($msfAgencyProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msfAgencyProfileId, true), gettype($msfAgencyProfileId)), __LINE__);
        }
        $this->MsfAgencyProfileId = $msfAgencyProfileId;
        return $this;
    }
    /**
     * Get MerchantAccountNumber value
     * @return string|null
     */
    public function getMerchantAccountNumber()
    {
        return $this->MerchantAccountNumber;
    }
    /**
     * Set MerchantAccountNumber value
     * @param string $merchantAccountNumber
     * @return \StructType\MsfAgencyFeeDetail
     */
    public function setMerchantAccountNumber($merchantAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($merchantAccountNumber) && !is_string($merchantAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantAccountNumber, true), gettype($merchantAccountNumber)), __LINE__);
        }
        $this->MerchantAccountNumber = $merchantAccountNumber;
        return $this;
    }
    /**
     * Get FederalTaxId value
     * @return string|null
     */
    public function getFederalTaxId()
    {
        return $this->FederalTaxId;
    }
    /**
     * Set FederalTaxId value
     * @param string $federalTaxId
     * @return \StructType\MsfAgencyFeeDetail
     */
    public function setFederalTaxId($federalTaxId = null)
    {
        // validation for constraint: string
        if (!is_null($federalTaxId) && !is_string($federalTaxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($federalTaxId, true), gettype($federalTaxId)), __LINE__);
        }
        $this->FederalTaxId = $federalTaxId;
        return $this;
    }
}
