<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MCP_Result StructType
 * @subpackage Structs
 */
class MCP_Result extends AbstractStructBase
{
    /**
     * The MCP_Offered
     * Meta information extracted from the WSDL
     * - documentation: Multi Currency Pricing Indicator
     * - use: required
     * @var bool
     */
    public $MCP_Offered;
    /**
     * The MCP_Offer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MCP_Offer[]
     */
    public $MCP_Offer;
    /**
     * The SupplierResponseCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierResponseCode;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * The SupplierTransID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierTransID;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReasonCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * Constructor method for MCP_Result
     * @uses MCP_Result::setMCP_Offered()
     * @uses MCP_Result::setMCP_Offer()
     * @uses MCP_Result::setSupplierResponseCode()
     * @uses MCP_Result::setSupplierID()
     * @uses MCP_Result::setSupplierTransID()
     * @uses MCP_Result::setReasonCode()
     * @uses MCP_Result::setDescription()
     * @param bool $mCP_Offered
     * @param \StructType\MCP_Offer[] $mCP_Offer
     * @param string $supplierResponseCode
     * @param string $supplierID
     * @param string $supplierTransID
     * @param string $reasonCode
     * @param string $description
     */
    public function __construct($mCP_Offered = null, array $mCP_Offer = array(), $supplierResponseCode = null, $supplierID = null, $supplierTransID = null, $reasonCode = null, $description = null)
    {
        $this
            ->setMCP_Offered($mCP_Offered)
            ->setMCP_Offer($mCP_Offer)
            ->setSupplierResponseCode($supplierResponseCode)
            ->setSupplierID($supplierID)
            ->setSupplierTransID($supplierTransID)
            ->setReasonCode($reasonCode)
            ->setDescription($description);
    }
    /**
     * Get MCP_Offered value
     * @return bool
     */
    public function getMCP_Offered()
    {
        return $this->MCP_Offered;
    }
    /**
     * Set MCP_Offered value
     * @param bool $mCP_Offered
     * @return \StructType\MCP_Result
     */
    public function setMCP_Offered($mCP_Offered = null)
    {
        // validation for constraint: boolean
        if (!is_null($mCP_Offered) && !is_bool($mCP_Offered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mCP_Offered, true), gettype($mCP_Offered)), __LINE__);
        }
        $this->MCP_Offered = $mCP_Offered;
        return $this;
    }
    /**
     * Get MCP_Offer value
     * @return \StructType\MCP_Offer[]|null
     */
    public function getMCP_Offer()
    {
        return $this->MCP_Offer;
    }
    /**
     * This method is responsible for validating the values passed to the setMCP_Offer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMCP_Offer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMCP_OfferForArrayConstraintsFromSetMCP_Offer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mCP_ResultMCP_OfferItem) {
            // validation for constraint: itemType
            if (!$mCP_ResultMCP_OfferItem instanceof \StructType\MCP_Offer) {
                $invalidValues[] = is_object($mCP_ResultMCP_OfferItem) ? get_class($mCP_ResultMCP_OfferItem) : sprintf('%s(%s)', gettype($mCP_ResultMCP_OfferItem), var_export($mCP_ResultMCP_OfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MCP_Offer property can only contain items of type \StructType\MCP_Offer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MCP_Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\MCP_Offer[] $mCP_Offer
     * @return \StructType\MCP_Result
     */
    public function setMCP_Offer(array $mCP_Offer = array())
    {
        // validation for constraint: array
        if ('' !== ($mCP_OfferArrayErrorMessage = self::validateMCP_OfferForArrayConstraintsFromSetMCP_Offer($mCP_Offer))) {
            throw new \InvalidArgumentException($mCP_OfferArrayErrorMessage, __LINE__);
        }
        $this->MCP_Offer = $mCP_Offer;
        return $this;
    }
    /**
     * Add item to MCP_Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\MCP_Offer $item
     * @return \StructType\MCP_Result
     */
    public function addToMCP_Offer(\StructType\MCP_Offer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MCP_Offer) {
            throw new \InvalidArgumentException(sprintf('The MCP_Offer property can only contain items of type \StructType\MCP_Offer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MCP_Offer[] = $item;
        return $this;
    }
    /**
     * Get SupplierResponseCode value
     * @return string|null
     */
    public function getSupplierResponseCode()
    {
        return $this->SupplierResponseCode;
    }
    /**
     * Set SupplierResponseCode value
     * @param string $supplierResponseCode
     * @return \StructType\MCP_Result
     */
    public function setSupplierResponseCode($supplierResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierResponseCode) && !is_string($supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierResponseCode, true), gettype($supplierResponseCode)), __LINE__);
        }
        $this->SupplierResponseCode = $supplierResponseCode;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \StructType\MCP_Result
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \StructType\MCP_Result
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransID) && !is_string($supplierTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransID, true), gettype($supplierTransID)), __LINE__);
        }
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param string $reasonCode
     * @return \StructType\MCP_Result
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\MCP_Result
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
