<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MCPType StructType
 * Meta information extracted from the WSDL
 * - documentation: Multi Currency Pricing
 * @subpackage Structs
 */
class MCPType extends AbstractStructBase
{
    /**
     * The MCP_TransID
     * Meta information extracted from the WSDL
     * - documentation: SabreTransactionID as returned in MCP response
     * - use: required
     * @var string
     */
    public $MCP_TransID;
    /**
     * The OptedIn
     * Meta information extracted from the WSDL
     * - documentation: "true" if cardholder opted to pay in selected currency.
     * - use: optional
     * @var bool
     */
    public $OptedIn;
    /**
     * Constructor method for MCPType
     * @uses MCPType::setMCP_TransID()
     * @uses MCPType::setOptedIn()
     * @param string $mCP_TransID
     * @param bool $optedIn
     */
    public function __construct($mCP_TransID = null, $optedIn = null)
    {
        $this
            ->setMCP_TransID($mCP_TransID)
            ->setOptedIn($optedIn);
    }
    /**
     * Get MCP_TransID value
     * @return string
     */
    public function getMCP_TransID()
    {
        return $this->MCP_TransID;
    }
    /**
     * Set MCP_TransID value
     * @param string $mCP_TransID
     * @return \StructType\MCPType
     */
    public function setMCP_TransID($mCP_TransID = null)
    {
        // validation for constraint: string
        if (!is_null($mCP_TransID) && !is_string($mCP_TransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mCP_TransID, true), gettype($mCP_TransID)), __LINE__);
        }
        $this->MCP_TransID = $mCP_TransID;
        return $this;
    }
    /**
     * Get OptedIn value
     * @return bool|null
     */
    public function getOptedIn()
    {
        return $this->OptedIn;
    }
    /**
     * Set OptedIn value
     * @param bool $optedIn
     * @return \StructType\MCPType
     */
    public function setOptedIn($optedIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($optedIn) && !is_bool($optedIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optedIn, true), gettype($optedIn)), __LINE__);
        }
        $this->OptedIn = $optedIn;
        return $this;
    }
}
