<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListOfVouchers StructType
 * @subpackage Structs
 */
class ListOfVouchers extends AbstractStructBase
{
    /**
     * The Voucher
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\VoucherType[]
     */
    public $Voucher;
    /**
     * Constructor method for ListOfVouchers
     * @uses ListOfVouchers::setVoucher()
     * @param \StructType\VoucherType[] $voucher
     */
    public function __construct(array $voucher = array())
    {
        $this
            ->setVoucher($voucher);
    }
    /**
     * Get Voucher value
     * @return \StructType\VoucherType[]|null
     */
    public function getVoucher()
    {
        return $this->Voucher;
    }
    /**
     * This method is responsible for validating the values passed to the setVoucher method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVoucher method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVoucherForArrayConstraintsFromSetVoucher(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listOfVouchersVoucherItem) {
            // validation for constraint: itemType
            if (!$listOfVouchersVoucherItem instanceof \StructType\VoucherType) {
                $invalidValues[] = is_object($listOfVouchersVoucherItem) ? get_class($listOfVouchersVoucherItem) : sprintf('%s(%s)', gettype($listOfVouchersVoucherItem), var_export($listOfVouchersVoucherItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Voucher property can only contain items of type \StructType\VoucherType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Voucher value
     * @throws \InvalidArgumentException
     * @param \StructType\VoucherType[] $voucher
     * @return \StructType\ListOfVouchers
     */
    public function setVoucher(array $voucher = array())
    {
        // validation for constraint: array
        if ('' !== ($voucherArrayErrorMessage = self::validateVoucherForArrayConstraintsFromSetVoucher($voucher))) {
            throw new \InvalidArgumentException($voucherArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($voucher) && count($voucher) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($voucher)), __LINE__);
        }
        $this->Voucher = $voucher;
        return $this;
    }
    /**
     * Add item to Voucher value
     * @throws \InvalidArgumentException
     * @param \StructType\VoucherType $item
     * @return \StructType\ListOfVouchers
     */
    public function addToVoucher(\StructType\VoucherType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VoucherType) {
            throw new \InvalidArgumentException(sprintf('The Voucher property can only contain items of type \StructType\VoucherType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Voucher) && count($this->Voucher) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Voucher)), __LINE__);
        }
        $this->Voucher[] = $item;
        return $this;
    }
}
