<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeferredPaymentDetail StructType
 * @subpackage Structs
 */
class DeferredPaymentDetail extends AbstractStructBase
{
    /**
     * The FOP
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\FOPType[]
     */
    public $FOP;
    /**
     * The CardDetail
     * Meta information extracted from the WSDL
     * - choice: CardDetail | AccountDetail
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CardDetail
     */
    public $CardDetail;
    /**
     * The AccountDetail
     * Meta information extracted from the WSDL
     * - choice: CardDetail | AccountDetail
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountDetailType
     */
    public $AccountDetail;
    /**
     * Constructor method for DeferredPaymentDetail
     * @uses DeferredPaymentDetail::setFOP()
     * @uses DeferredPaymentDetail::setCardDetail()
     * @uses DeferredPaymentDetail::setAccountDetail()
     * @param \StructType\FOPType[] $fOP
     * @param \StructType\CardDetail $cardDetail
     * @param \StructType\AccountDetailType $accountDetail
     */
    public function __construct(array $fOP = array(), \StructType\CardDetail $cardDetail = null, \StructType\AccountDetailType $accountDetail = null)
    {
        $this
            ->setFOP($fOP)
            ->setCardDetail($cardDetail)
            ->setAccountDetail($accountDetail);
    }
    /**
     * Get FOP value
     * @return \StructType\FOPType[]|null
     */
    public function getFOP()
    {
        return $this->FOP;
    }
    /**
     * This method is responsible for validating the values passed to the setFOP method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFOP method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFOPForArrayConstraintsFromSetFOP(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deferredPaymentDetailFOPItem) {
            // validation for constraint: itemType
            if (!$deferredPaymentDetailFOPItem instanceof \StructType\FOPType) {
                $invalidValues[] = is_object($deferredPaymentDetailFOPItem) ? get_class($deferredPaymentDetailFOPItem) : sprintf('%s(%s)', gettype($deferredPaymentDetailFOPItem), var_export($deferredPaymentDetailFOPItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FOP property can only contain items of type \StructType\FOPType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FOP value
     * @throws \InvalidArgumentException
     * @param \StructType\FOPType[] $fOP
     * @return \StructType\DeferredPaymentDetail
     */
    public function setFOP(array $fOP = array())
    {
        // validation for constraint: array
        if ('' !== ($fOPArrayErrorMessage = self::validateFOPForArrayConstraintsFromSetFOP($fOP))) {
            throw new \InvalidArgumentException($fOPArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($fOP) && count($fOP) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($fOP)), __LINE__);
        }
        $this->FOP = $fOP;
        return $this;
    }
    /**
     * Add item to FOP value
     * @throws \InvalidArgumentException
     * @param \StructType\FOPType $item
     * @return \StructType\DeferredPaymentDetail
     */
    public function addToFOP(\StructType\FOPType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FOPType) {
            throw new \InvalidArgumentException(sprintf('The FOP property can only contain items of type \StructType\FOPType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->FOP) && count($this->FOP) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->FOP)), __LINE__);
        }
        $this->FOP[] = $item;
        return $this;
    }
    /**
     * Get CardDetail value
     * @return \StructType\CardDetail|null
     */
    public function getCardDetail()
    {
        return isset($this->CardDetail) ? $this->CardDetail : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCardDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardDetail method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCardDetailForChoiceConstraintsFromSetCardDetail($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountDetail',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CardDetail can\'t be set as the property %s is already set. Only one property must be set among these properties: CardDetail, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CardDetail value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CardDetail $cardDetail
     * @return \StructType\DeferredPaymentDetail
     */
    public function setCardDetail(\StructType\CardDetail $cardDetail = null)
    {
        // validation for constraint: choice(CardDetail, AccountDetail)
        if ('' !== ($cardDetailChoiceErrorMessage = self::validateCardDetailForChoiceConstraintsFromSetCardDetail($cardDetail))) {
            throw new \InvalidArgumentException($cardDetailChoiceErrorMessage, __LINE__);
        }
        if (is_null($cardDetail) || (is_array($cardDetail) && empty($cardDetail))) {
            unset($this->CardDetail);
        } else {
            $this->CardDetail = $cardDetail;
        }
        return $this;
    }
    /**
     * Get AccountDetail value
     * @return \StructType\AccountDetailType|null
     */
    public function getAccountDetail()
    {
        return isset($this->AccountDetail) ? $this->AccountDetail : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAccountDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountDetail method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAccountDetailForChoiceConstraintsFromSetAccountDetail($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardDetail',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AccountDetail can\'t be set as the property %s is already set. Only one property must be set among these properties: AccountDetail, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AccountDetail value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccountDetailType $accountDetail
     * @return \StructType\DeferredPaymentDetail
     */
    public function setAccountDetail(\StructType\AccountDetailType $accountDetail = null)
    {
        // validation for constraint: choice(CardDetail, AccountDetail)
        if ('' !== ($accountDetailChoiceErrorMessage = self::validateAccountDetailForChoiceConstraintsFromSetAccountDetail($accountDetail))) {
            throw new \InvalidArgumentException($accountDetailChoiceErrorMessage, __LINE__);
        }
        if (is_null($accountDetail) || (is_array($accountDetail) && empty($accountDetail))) {
            unset($this->AccountDetail);
        } else {
            $this->AccountDetail = $accountDetail;
        }
        return $this;
    }
}
