<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardUsageResult StructType
 * @subpackage Structs
 */
class CardUsageResult extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ResponseCode;
    /**
     * The ReferenceNbr
     * @var string
     */
    public $ReferenceNbr;
    /**
     * The CardDeploymentID
     * Meta information extracted from the WSDL
     * - documentation: As returned in GetCard response
     * @var string
     */
    public $CardDeploymentID;
    /**
     * Constructor method for CardUsageResult
     * @uses CardUsageResult::setResponseCode()
     * @uses CardUsageResult::setReferenceNbr()
     * @uses CardUsageResult::setCardDeploymentID()
     * @param string $responseCode
     * @param string $referenceNbr
     * @param string $cardDeploymentID
     */
    public function __construct($responseCode = null, $referenceNbr = null, $cardDeploymentID = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setReferenceNbr($referenceNbr)
            ->setCardDeploymentID($cardDeploymentID);
    }
    /**
     * Get ResponseCode value
     * @return string|null
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \StructType\CardUsageResult
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * @return string|null
     */
    public function getReferenceNbr()
    {
        return $this->ReferenceNbr;
    }
    /**
     * Set ReferenceNbr value
     * @param string $referenceNbr
     * @return \StructType\CardUsageResult
     */
    public function setReferenceNbr($referenceNbr = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNbr) && !is_string($referenceNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNbr, true), gettype($referenceNbr)), __LINE__);
        }
        $this->ReferenceNbr = $referenceNbr;
        return $this;
    }
    /**
     * Get CardDeploymentID value
     * @return string|null
     */
    public function getCardDeploymentID()
    {
        return $this->CardDeploymentID;
    }
    /**
     * Set CardDeploymentID value
     * @param string $cardDeploymentID
     * @return \StructType\CardUsageResult
     */
    public function setCardDeploymentID($cardDeploymentID = null)
    {
        // validation for constraint: string
        if (!is_null($cardDeploymentID) && !is_string($cardDeploymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardDeploymentID, true), gettype($cardDeploymentID)), __LINE__);
        }
        $this->CardDeploymentID = $cardDeploymentID;
        return $this;
    }
}
