<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthResponseDetail StructType
 * @subpackage Structs
 */
class AuthResponseDetail extends AbstractStructBase
{
    /**
     * The AuthSrcCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AuthSrcCode;
    /**
     * The AuthValidationCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AuthValidationCode;
    /**
     * The ProductID
     * Meta information extracted from the WSDL
     * - documentation: Visa Product Identifier
     * - use: optional
     * @var string
     */
    public $ProductID;
    /**
     * The AuthCharacteristicInd
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AuthCharacteristicInd;
    /**
     * The POS_ConditionCode
     * Meta information extracted from the WSDL
     * - documentation: Point of Sale Condition Code
     * - use: optional
     * @var string
     */
    public $POS_ConditionCode;
    /**
     * The POS_AdditionalData
     * Meta information extracted from the WSDL
     * - documentation: Point of Sale Additional Data
     * - use: optional
     * @var string
     */
    public $POS_AdditionalData;
    /**
     * The POS_EntryMode
     * Meta information extracted from the WSDL
     * - documentation: Point of Sale Entry Mode
     * - use: optional
     * @var string
     */
    public $POS_EntryMode;
    /**
     * The TIC
     * Meta information extracted from the WSDL
     * - documentation: MasterCard Transaction Integrity Classification
     * - use: optional
     * @var string
     */
    public $TIC;
    /**
     * The MCC
     * Meta information extracted from the WSDL
     * - documentation: Merchant Category Code
     * - use: optional
     * @var string
     */
    public $MCC;
    /**
     * The SpendQualifiedInd
     * Meta information extracted from the WSDL
     * - documentation: Spend Qualified Indicator
     * - use: optional
     * @var string
     */
    public $SpendQualifiedInd;
    /**
     * The PaymentAccountRef
     * Meta information extracted from the WSDL
     * - documentation: Payment Account Reference
     * - use: optional
     * @var string
     */
    public $PaymentAccountRef;
    /**
     * The SystemTraceAuditNumber
     * Meta information extracted from the WSDL
     * - documentation: System Trace Audit Number
     * - use: optional
     * @var string
     */
    public $SystemTraceAuditNumber;
    /**
     * The AccountFundingSource
     * Meta information extracted from the WSDL
     * - documentation: Visa response data for clearing. The account funding source value could be: C - Credit D - Debit H - Charge P - Prepaid R - Deferred debit
     * - use: optional
     * @var string
     */
    public $AccountFundingSource;
    /**
     * Constructor method for AuthResponseDetail
     * @uses AuthResponseDetail::setAuthSrcCode()
     * @uses AuthResponseDetail::setAuthValidationCode()
     * @uses AuthResponseDetail::setProductID()
     * @uses AuthResponseDetail::setAuthCharacteristicInd()
     * @uses AuthResponseDetail::setPOS_ConditionCode()
     * @uses AuthResponseDetail::setPOS_AdditionalData()
     * @uses AuthResponseDetail::setPOS_EntryMode()
     * @uses AuthResponseDetail::setTIC()
     * @uses AuthResponseDetail::setMCC()
     * @uses AuthResponseDetail::setSpendQualifiedInd()
     * @uses AuthResponseDetail::setPaymentAccountRef()
     * @uses AuthResponseDetail::setSystemTraceAuditNumber()
     * @uses AuthResponseDetail::setAccountFundingSource()
     * @param string $authSrcCode
     * @param string $authValidationCode
     * @param string $productID
     * @param string $authCharacteristicInd
     * @param string $pOS_ConditionCode
     * @param string $pOS_AdditionalData
     * @param string $pOS_EntryMode
     * @param string $tIC
     * @param string $mCC
     * @param string $spendQualifiedInd
     * @param string $paymentAccountRef
     * @param string $systemTraceAuditNumber
     * @param string $accountFundingSource
     */
    public function __construct($authSrcCode = null, $authValidationCode = null, $productID = null, $authCharacteristicInd = null, $pOS_ConditionCode = null, $pOS_AdditionalData = null, $pOS_EntryMode = null, $tIC = null, $mCC = null, $spendQualifiedInd = null, $paymentAccountRef = null, $systemTraceAuditNumber = null, $accountFundingSource = null)
    {
        $this
            ->setAuthSrcCode($authSrcCode)
            ->setAuthValidationCode($authValidationCode)
            ->setProductID($productID)
            ->setAuthCharacteristicInd($authCharacteristicInd)
            ->setPOS_ConditionCode($pOS_ConditionCode)
            ->setPOS_AdditionalData($pOS_AdditionalData)
            ->setPOS_EntryMode($pOS_EntryMode)
            ->setTIC($tIC)
            ->setMCC($mCC)
            ->setSpendQualifiedInd($spendQualifiedInd)
            ->setPaymentAccountRef($paymentAccountRef)
            ->setSystemTraceAuditNumber($systemTraceAuditNumber)
            ->setAccountFundingSource($accountFundingSource);
    }
    /**
     * Get AuthSrcCode value
     * @return string|null
     */
    public function getAuthSrcCode()
    {
        return $this->AuthSrcCode;
    }
    /**
     * Set AuthSrcCode value
     * @param string $authSrcCode
     * @return \StructType\AuthResponseDetail
     */
    public function setAuthSrcCode($authSrcCode = null)
    {
        // validation for constraint: string
        if (!is_null($authSrcCode) && !is_string($authSrcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authSrcCode, true), gettype($authSrcCode)), __LINE__);
        }
        $this->AuthSrcCode = $authSrcCode;
        return $this;
    }
    /**
     * Get AuthValidationCode value
     * @return string|null
     */
    public function getAuthValidationCode()
    {
        return $this->AuthValidationCode;
    }
    /**
     * Set AuthValidationCode value
     * @param string $authValidationCode
     * @return \StructType\AuthResponseDetail
     */
    public function setAuthValidationCode($authValidationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authValidationCode) && !is_string($authValidationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authValidationCode, true), gettype($authValidationCode)), __LINE__);
        }
        $this->AuthValidationCode = $authValidationCode;
        return $this;
    }
    /**
     * Get ProductID value
     * @return string|null
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param string $productID
     * @return \StructType\AuthResponseDetail
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: string
        if (!is_null($productID) && !is_string($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productID, true), gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get AuthCharacteristicInd value
     * @return string|null
     */
    public function getAuthCharacteristicInd()
    {
        return $this->AuthCharacteristicInd;
    }
    /**
     * Set AuthCharacteristicInd value
     * @param string $authCharacteristicInd
     * @return \StructType\AuthResponseDetail
     */
    public function setAuthCharacteristicInd($authCharacteristicInd = null)
    {
        // validation for constraint: string
        if (!is_null($authCharacteristicInd) && !is_string($authCharacteristicInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCharacteristicInd, true), gettype($authCharacteristicInd)), __LINE__);
        }
        $this->AuthCharacteristicInd = $authCharacteristicInd;
        return $this;
    }
    /**
     * Get POS_ConditionCode value
     * @return string|null
     */
    public function getPOS_ConditionCode()
    {
        return $this->POS_ConditionCode;
    }
    /**
     * Set POS_ConditionCode value
     * @param string $pOS_ConditionCode
     * @return \StructType\AuthResponseDetail
     */
    public function setPOS_ConditionCode($pOS_ConditionCode = null)
    {
        // validation for constraint: string
        if (!is_null($pOS_ConditionCode) && !is_string($pOS_ConditionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOS_ConditionCode, true), gettype($pOS_ConditionCode)), __LINE__);
        }
        $this->POS_ConditionCode = $pOS_ConditionCode;
        return $this;
    }
    /**
     * Get POS_AdditionalData value
     * @return string|null
     */
    public function getPOS_AdditionalData()
    {
        return $this->POS_AdditionalData;
    }
    /**
     * Set POS_AdditionalData value
     * @param string $pOS_AdditionalData
     * @return \StructType\AuthResponseDetail
     */
    public function setPOS_AdditionalData($pOS_AdditionalData = null)
    {
        // validation for constraint: string
        if (!is_null($pOS_AdditionalData) && !is_string($pOS_AdditionalData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOS_AdditionalData, true), gettype($pOS_AdditionalData)), __LINE__);
        }
        $this->POS_AdditionalData = $pOS_AdditionalData;
        return $this;
    }
    /**
     * Get POS_EntryMode value
     * @return string|null
     */
    public function getPOS_EntryMode()
    {
        return $this->POS_EntryMode;
    }
    /**
     * Set POS_EntryMode value
     * @param string $pOS_EntryMode
     * @return \StructType\AuthResponseDetail
     */
    public function setPOS_EntryMode($pOS_EntryMode = null)
    {
        // validation for constraint: string
        if (!is_null($pOS_EntryMode) && !is_string($pOS_EntryMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOS_EntryMode, true), gettype($pOS_EntryMode)), __LINE__);
        }
        $this->POS_EntryMode = $pOS_EntryMode;
        return $this;
    }
    /**
     * Get TIC value
     * @return string|null
     */
    public function getTIC()
    {
        return $this->TIC;
    }
    /**
     * Set TIC value
     * @param string $tIC
     * @return \StructType\AuthResponseDetail
     */
    public function setTIC($tIC = null)
    {
        // validation for constraint: string
        if (!is_null($tIC) && !is_string($tIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tIC, true), gettype($tIC)), __LINE__);
        }
        $this->TIC = $tIC;
        return $this;
    }
    /**
     * Get MCC value
     * @return string|null
     */
    public function getMCC()
    {
        return $this->MCC;
    }
    /**
     * Set MCC value
     * @param string $mCC
     * @return \StructType\AuthResponseDetail
     */
    public function setMCC($mCC = null)
    {
        // validation for constraint: string
        if (!is_null($mCC) && !is_string($mCC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mCC, true), gettype($mCC)), __LINE__);
        }
        $this->MCC = $mCC;
        return $this;
    }
    /**
     * Get SpendQualifiedInd value
     * @return string|null
     */
    public function getSpendQualifiedInd()
    {
        return $this->SpendQualifiedInd;
    }
    /**
     * Set SpendQualifiedInd value
     * @param string $spendQualifiedInd
     * @return \StructType\AuthResponseDetail
     */
    public function setSpendQualifiedInd($spendQualifiedInd = null)
    {
        // validation for constraint: string
        if (!is_null($spendQualifiedInd) && !is_string($spendQualifiedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spendQualifiedInd, true), gettype($spendQualifiedInd)), __LINE__);
        }
        $this->SpendQualifiedInd = $spendQualifiedInd;
        return $this;
    }
    /**
     * Get PaymentAccountRef value
     * @return string|null
     */
    public function getPaymentAccountRef()
    {
        return $this->PaymentAccountRef;
    }
    /**
     * Set PaymentAccountRef value
     * @param string $paymentAccountRef
     * @return \StructType\AuthResponseDetail
     */
    public function setPaymentAccountRef($paymentAccountRef = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAccountRef) && !is_string($paymentAccountRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentAccountRef, true), gettype($paymentAccountRef)), __LINE__);
        }
        $this->PaymentAccountRef = $paymentAccountRef;
        return $this;
    }
    /**
     * Get SystemTraceAuditNumber value
     * @return string|null
     */
    public function getSystemTraceAuditNumber()
    {
        return $this->SystemTraceAuditNumber;
    }
    /**
     * Set SystemTraceAuditNumber value
     * @param string $systemTraceAuditNumber
     * @return \StructType\AuthResponseDetail
     */
    public function setSystemTraceAuditNumber($systemTraceAuditNumber = null)
    {
        // validation for constraint: string
        if (!is_null($systemTraceAuditNumber) && !is_string($systemTraceAuditNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemTraceAuditNumber, true), gettype($systemTraceAuditNumber)), __LINE__);
        }
        $this->SystemTraceAuditNumber = $systemTraceAuditNumber;
        return $this;
    }
    /**
     * Get AccountFundingSource value
     * @return string|null
     */
    public function getAccountFundingSource()
    {
        return $this->AccountFundingSource;
    }
    /**
     * Set AccountFundingSource value
     * @param string $accountFundingSource
     * @return \StructType\AuthResponseDetail
     */
    public function setAccountFundingSource($accountFundingSource = null)
    {
        // validation for constraint: string
        if (!is_null($accountFundingSource) && !is_string($accountFundingSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountFundingSource, true), gettype($accountFundingSource)), __LINE__);
        }
        $this->AccountFundingSource = $accountFundingSource;
        return $this;
    }
}
