<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateAndQueryPaymentDetailResultType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides payment validation result and payment information details
 * @subpackage Structs
 */
class ValidateAndQueryPaymentDetailResultType extends AbstractStructBase
{
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ResultCode;
    /**
     * The AdditionalApprovals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionalApprovals
     */
    public $AdditionalApprovals;
    /**
     * The AdditionalNonHistoricalRemarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RemarksType
     */
    public $AdditionalNonHistoricalRemarks;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The ApprovalCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ApprovalCode;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * The SupplierTransID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierTransID;
    /**
     * The PaymentConfirmInd
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PaymentConfirmInd;
    /**
     * The PaymentRef
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PaymentRef;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ErrorCode;
    /**
     * Constructor method for ValidateAndQueryPaymentDetailResultType
     * @uses ValidateAndQueryPaymentDetailResultType::setResultCode()
     * @uses ValidateAndQueryPaymentDetailResultType::setAdditionalApprovals()
     * @uses ValidateAndQueryPaymentDetailResultType::setAdditionalNonHistoricalRemarks()
     * @uses ValidateAndQueryPaymentDetailResultType::setDescription()
     * @uses ValidateAndQueryPaymentDetailResultType::setApprovalCode()
     * @uses ValidateAndQueryPaymentDetailResultType::setSupplierID()
     * @uses ValidateAndQueryPaymentDetailResultType::setSupplierTransID()
     * @uses ValidateAndQueryPaymentDetailResultType::setPaymentConfirmInd()
     * @uses ValidateAndQueryPaymentDetailResultType::setPaymentRef()
     * @uses ValidateAndQueryPaymentDetailResultType::setErrorCode()
     * @param string $resultCode
     * @param \StructType\AdditionalApprovals $additionalApprovals
     * @param \StructType\RemarksType $additionalNonHistoricalRemarks
     * @param string $description
     * @param string $approvalCode
     * @param string $supplierID
     * @param string $supplierTransID
     * @param string $paymentConfirmInd
     * @param string $paymentRef
     * @param string $errorCode
     */
    public function __construct($resultCode = null, \StructType\AdditionalApprovals $additionalApprovals = null, \StructType\RemarksType $additionalNonHistoricalRemarks = null, $description = null, $approvalCode = null, $supplierID = null, $supplierTransID = null, $paymentConfirmInd = null, $paymentRef = null, $errorCode = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setAdditionalApprovals($additionalApprovals)
            ->setAdditionalNonHistoricalRemarks($additionalNonHistoricalRemarks)
            ->setDescription($description)
            ->setApprovalCode($approvalCode)
            ->setSupplierID($supplierID)
            ->setSupplierTransID($supplierTransID)
            ->setPaymentConfirmInd($paymentConfirmInd)
            ->setPaymentRef($paymentRef)
            ->setErrorCode($errorCode);
    }
    /**
     * Get ResultCode value
     * @return string
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \StructType\ValidateAndQueryPaymentDetailResultType
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get AdditionalApprovals value
     * @return \StructType\AdditionalApprovals|null
     */
    public function getAdditionalApprovals()
    {
        return $this->AdditionalApprovals;
    }
    /**
     * Set AdditionalApprovals value
     * @param \StructType\AdditionalApprovals $additionalApprovals
     * @return \StructType\ValidateAndQueryPaymentDetailResultType
     */
    public function setAdditionalApprovals(\StructType\AdditionalApprovals $additionalApprovals = null)
    {
        $this->AdditionalApprovals = $additionalApprovals;
        return $this;
    }
    /**
     * Get AdditionalNonHistoricalRemarks value
     * @return \StructType\RemarksType|null
     */
    public function getAdditionalNonHistoricalRemarks()
    {
        return $this->AdditionalNonHistoricalRemarks;
    }
    /**
     * Set AdditionalNonHistoricalRemarks value
     * @param \StructType\RemarksType $additionalNonHistoricalRemarks
     * @return \StructType\ValidateAndQueryPaymentDetailResultType
     */
    public function setAdditionalNonHistoricalRemarks(\StructType\RemarksType $additionalNonHistoricalRemarks = null)
    {
        $this->AdditionalNonHistoricalRemarks = $additionalNonHistoricalRemarks;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ValidateAndQueryPaymentDetailResultType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ApprovalCode value
     * @return string|null
     */
    public function getApprovalCode()
    {
        return $this->ApprovalCode;
    }
    /**
     * Set ApprovalCode value
     * @param string $approvalCode
     * @return \StructType\ValidateAndQueryPaymentDetailResultType
     */
    public function setApprovalCode($approvalCode = null)
    {
        // validation for constraint: string
        if (!is_null($approvalCode) && !is_string($approvalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalCode, true), gettype($approvalCode)), __LINE__);
        }
        $this->ApprovalCode = $approvalCode;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \StructType\ValidateAndQueryPaymentDetailResultType
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \StructType\ValidateAndQueryPaymentDetailResultType
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransID) && !is_string($supplierTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransID, true), gettype($supplierTransID)), __LINE__);
        }
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
    /**
     * Get PaymentConfirmInd value
     * @return string|null
     */
    public function getPaymentConfirmInd()
    {
        return $this->PaymentConfirmInd;
    }
    /**
     * Set PaymentConfirmInd value
     * @param string $paymentConfirmInd
     * @return \StructType\ValidateAndQueryPaymentDetailResultType
     */
    public function setPaymentConfirmInd($paymentConfirmInd = null)
    {
        // validation for constraint: string
        if (!is_null($paymentConfirmInd) && !is_string($paymentConfirmInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentConfirmInd, true), gettype($paymentConfirmInd)), __LINE__);
        }
        $this->PaymentConfirmInd = $paymentConfirmInd;
        return $this;
    }
    /**
     * Get PaymentRef value
     * @return string|null
     */
    public function getPaymentRef()
    {
        return $this->PaymentRef;
    }
    /**
     * Set PaymentRef value
     * @param string $paymentRef
     * @return \StructType\ValidateAndQueryPaymentDetailResultType
     */
    public function setPaymentRef($paymentRef = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRef) && !is_string($paymentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRef, true), gettype($paymentRef)), __LINE__);
        }
        $this->PaymentRef = $paymentRef;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \StructType\ValidateAndQueryPaymentDetailResultType
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
}
