<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UsernameToken StructType
 * @subpackage Structs
 */
class UsernameToken extends AbstractStructBase
{
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The NewPassword
     * Meta information extracted from the WSDL
     * - Prefix: wsse
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var string[]
     */
    public $NewPassword;
    /**
     * The Organization
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - minOccurs: 0
     * @var string
     */
    public $Organization;
    /**
     * The Domain
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - minOccurs: 0
     * @var string
     */
    public $Domain;
    /**
     * Constructor method for UsernameToken
     * @uses UsernameToken::setUsername()
     * @uses UsernameToken::setPassword()
     * @uses UsernameToken::setNewPassword()
     * @uses UsernameToken::setOrganization()
     * @uses UsernameToken::setDomain()
     * @param string $username
     * @param string $password
     * @param string[] $newPassword
     * @param string $organization
     * @param string $domain
     */
    public function __construct($username = null, $password = null, array $newPassword = array(), $organization = null, $domain = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setNewPassword($newPassword)
            ->setOrganization($organization)
            ->setDomain($domain);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\UsernameToken
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\UsernameToken
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get NewPassword value
     * @return string[]|null
     */
    public function getNewPassword()
    {
        return $this->NewPassword;
    }
    /**
     * This method is responsible for validating the values passed to the setNewPassword method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNewPassword method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNewPasswordForArrayConstraintsFromSetNewPassword(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $usernameTokenNewPasswordItem) {
            // validation for constraint: itemType
            if (!is_string($usernameTokenNewPasswordItem)) {
                $invalidValues[] = is_object($usernameTokenNewPasswordItem) ? get_class($usernameTokenNewPasswordItem) : sprintf('%s(%s)', gettype($usernameTokenNewPasswordItem), var_export($usernameTokenNewPasswordItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NewPassword property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NewPassword value
     * @throws \InvalidArgumentException
     * @param string[] $newPassword
     * @return \StructType\UsernameToken
     */
    public function setNewPassword(array $newPassword = array())
    {
        // validation for constraint: array
        if ('' !== ($newPasswordArrayErrorMessage = self::validateNewPasswordForArrayConstraintsFromSetNewPassword($newPassword))) {
            throw new \InvalidArgumentException($newPasswordArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($newPassword) && count($newPassword) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($newPassword)), __LINE__);
        }
        $this->NewPassword = $newPassword;
        return $this;
    }
    /**
     * Add item to NewPassword value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\UsernameToken
     */
    public function addToNewPassword($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The NewPassword property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->NewPassword) && count($this->NewPassword) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->NewPassword)), __LINE__);
        }
        $this->NewPassword[] = $item;
        return $this;
    }
    /**
     * Get Organization value
     * @return string|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param string $organization
     * @return \StructType\UsernameToken
     */
    public function setOrganization($organization = null)
    {
        // validation for constraint: string
        if (!is_null($organization) && !is_string($organization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organization, true), gettype($organization)), __LINE__);
        }
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Get Domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->Domain;
    }
    /**
     * Set Domain value
     * @param string $domain
     * @return \StructType\UsernameToken
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domain, true), gettype($domain)), __LINE__);
        }
        $this->Domain = $domain;
        return $this;
    }
}
