<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StateProvType StructType
 * Meta information extracted from the WSDL
 * - documentation: State, province, or region name or code needed to identify location.
 * @subpackage Structs
 */
class StateProvType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The StateCode
     * Meta information extracted from the WSDL
     * - documentation: The postal service standard code or abbreviation for the state, province, or region.
     * - use: optional
     * @var string
     */
    public $StateCode;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: State name eg. Texas
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * Constructor method for StateProvType
     * @uses StateProvType::set_()
     * @uses StateProvType::setStateCode()
     * @uses StateProvType::setName()
     * @param string $_
     * @param string $stateCode
     * @param string $name
     */
    public function __construct($_ = null, $stateCode = null, $name = null)
    {
        $this
            ->set_($_)
            ->setStateCode($stateCode)
            ->setName($name);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\StateProvType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \StructType\StateProvType
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateCode, true), gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\StateProvType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
