<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDetailType StructType
 * @subpackage Structs
 */
class PaymentDetailType extends AbstractStructBase
{
    /**
     * The FOP
     * Meta information extracted from the WSDL
     * - documentation: Form of Payment
     * - minOccurs: 0
     * @var \StructType\FOPType
     */
    public $FOP;
    /**
     * The PaymentCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentCard
     */
    public $PaymentCard;
    /**
     * The AmountDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AmountDetail
     */
    public $AmountDetail;
    /**
     * The AuthorizationResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AuthorizationResult
     */
    public $AuthorizationResult;
    /**
     * The AccountValidationResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountValidationResult
     */
    public $AccountValidationResult;
    /**
     * The CardUsageResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CardUsageResult
     */
    public $CardUsageResult;
    /**
     * The ReturnURLs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReturnURLsType
     */
    public $ReturnURLs;
    /**
     * The RoutingDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RoutingDetail
     */
    public $RoutingDetail;
    /**
     * The AdditionalDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionalDetailType
     */
    public $AdditionalDetail;
    /**
     * The InstallmentDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InstallmentDetail
     */
    public $InstallmentDetail;
    /**
     * The VirtualPaymentDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VirtualPaymentDetail
     */
    public $VirtualPaymentDetail;
    /**
     * The FOP_RPH
     * @var string
     */
    public $FOP_RPH;
    /**
     * The PaymentRef
     * @var string
     */
    public $PaymentRef;
    /**
     * The DeferredPaymentPeriod
     * @var string
     */
    public $DeferredPaymentPeriod;
    /**
     * Constructor method for PaymentDetailType
     * @uses PaymentDetailType::setFOP()
     * @uses PaymentDetailType::setPaymentCard()
     * @uses PaymentDetailType::setAmountDetail()
     * @uses PaymentDetailType::setAuthorizationResult()
     * @uses PaymentDetailType::setAccountValidationResult()
     * @uses PaymentDetailType::setCardUsageResult()
     * @uses PaymentDetailType::setReturnURLs()
     * @uses PaymentDetailType::setRoutingDetail()
     * @uses PaymentDetailType::setAdditionalDetail()
     * @uses PaymentDetailType::setInstallmentDetail()
     * @uses PaymentDetailType::setVirtualPaymentDetail()
     * @uses PaymentDetailType::setFOP_RPH()
     * @uses PaymentDetailType::setPaymentRef()
     * @uses PaymentDetailType::setDeferredPaymentPeriod()
     * @param \StructType\FOPType $fOP
     * @param \StructType\PaymentCard $paymentCard
     * @param \StructType\AmountDetail $amountDetail
     * @param \StructType\AuthorizationResult $authorizationResult
     * @param \StructType\AccountValidationResult $accountValidationResult
     * @param \StructType\CardUsageResult $cardUsageResult
     * @param \StructType\ReturnURLsType $returnURLs
     * @param \StructType\RoutingDetail $routingDetail
     * @param \StructType\AdditionalDetailType $additionalDetail
     * @param \StructType\InstallmentDetail $installmentDetail
     * @param \StructType\VirtualPaymentDetail $virtualPaymentDetail
     * @param string $fOP_RPH
     * @param string $paymentRef
     * @param string $deferredPaymentPeriod
     */
    public function __construct(\StructType\FOPType $fOP = null, \StructType\PaymentCard $paymentCard = null, \StructType\AmountDetail $amountDetail = null, \StructType\AuthorizationResult $authorizationResult = null, \StructType\AccountValidationResult $accountValidationResult = null, \StructType\CardUsageResult $cardUsageResult = null, \StructType\ReturnURLsType $returnURLs = null, \StructType\RoutingDetail $routingDetail = null, \StructType\AdditionalDetailType $additionalDetail = null, \StructType\InstallmentDetail $installmentDetail = null, \StructType\VirtualPaymentDetail $virtualPaymentDetail = null, $fOP_RPH = null, $paymentRef = null, $deferredPaymentPeriod = null)
    {
        $this
            ->setFOP($fOP)
            ->setPaymentCard($paymentCard)
            ->setAmountDetail($amountDetail)
            ->setAuthorizationResult($authorizationResult)
            ->setAccountValidationResult($accountValidationResult)
            ->setCardUsageResult($cardUsageResult)
            ->setReturnURLs($returnURLs)
            ->setRoutingDetail($routingDetail)
            ->setAdditionalDetail($additionalDetail)
            ->setInstallmentDetail($installmentDetail)
            ->setVirtualPaymentDetail($virtualPaymentDetail)
            ->setFOP_RPH($fOP_RPH)
            ->setPaymentRef($paymentRef)
            ->setDeferredPaymentPeriod($deferredPaymentPeriod);
    }
    /**
     * Get FOP value
     * @return \StructType\FOPType|null
     */
    public function getFOP()
    {
        return $this->FOP;
    }
    /**
     * Set FOP value
     * @param \StructType\FOPType $fOP
     * @return \StructType\PaymentDetailType
     */
    public function setFOP(\StructType\FOPType $fOP = null)
    {
        $this->FOP = $fOP;
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \StructType\PaymentCard|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param \StructType\PaymentCard $paymentCard
     * @return \StructType\PaymentDetailType
     */
    public function setPaymentCard(\StructType\PaymentCard $paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get AmountDetail value
     * @return \StructType\AmountDetail|null
     */
    public function getAmountDetail()
    {
        return $this->AmountDetail;
    }
    /**
     * Set AmountDetail value
     * @param \StructType\AmountDetail $amountDetail
     * @return \StructType\PaymentDetailType
     */
    public function setAmountDetail(\StructType\AmountDetail $amountDetail = null)
    {
        $this->AmountDetail = $amountDetail;
        return $this;
    }
    /**
     * Get AuthorizationResult value
     * @return \StructType\AuthorizationResult|null
     */
    public function getAuthorizationResult()
    {
        return $this->AuthorizationResult;
    }
    /**
     * Set AuthorizationResult value
     * @param \StructType\AuthorizationResult $authorizationResult
     * @return \StructType\PaymentDetailType
     */
    public function setAuthorizationResult(\StructType\AuthorizationResult $authorizationResult = null)
    {
        $this->AuthorizationResult = $authorizationResult;
        return $this;
    }
    /**
     * Get AccountValidationResult value
     * @return \StructType\AccountValidationResult|null
     */
    public function getAccountValidationResult()
    {
        return $this->AccountValidationResult;
    }
    /**
     * Set AccountValidationResult value
     * @param \StructType\AccountValidationResult $accountValidationResult
     * @return \StructType\PaymentDetailType
     */
    public function setAccountValidationResult(\StructType\AccountValidationResult $accountValidationResult = null)
    {
        $this->AccountValidationResult = $accountValidationResult;
        return $this;
    }
    /**
     * Get CardUsageResult value
     * @return \StructType\CardUsageResult|null
     */
    public function getCardUsageResult()
    {
        return $this->CardUsageResult;
    }
    /**
     * Set CardUsageResult value
     * @param \StructType\CardUsageResult $cardUsageResult
     * @return \StructType\PaymentDetailType
     */
    public function setCardUsageResult(\StructType\CardUsageResult $cardUsageResult = null)
    {
        $this->CardUsageResult = $cardUsageResult;
        return $this;
    }
    /**
     * Get ReturnURLs value
     * @return \StructType\ReturnURLsType|null
     */
    public function getReturnURLs()
    {
        return $this->ReturnURLs;
    }
    /**
     * Set ReturnURLs value
     * @param \StructType\ReturnURLsType $returnURLs
     * @return \StructType\PaymentDetailType
     */
    public function setReturnURLs(\StructType\ReturnURLsType $returnURLs = null)
    {
        $this->ReturnURLs = $returnURLs;
        return $this;
    }
    /**
     * Get RoutingDetail value
     * @return \StructType\RoutingDetail|null
     */
    public function getRoutingDetail()
    {
        return $this->RoutingDetail;
    }
    /**
     * Set RoutingDetail value
     * @param \StructType\RoutingDetail $routingDetail
     * @return \StructType\PaymentDetailType
     */
    public function setRoutingDetail(\StructType\RoutingDetail $routingDetail = null)
    {
        $this->RoutingDetail = $routingDetail;
        return $this;
    }
    /**
     * Get AdditionalDetail value
     * @return \StructType\AdditionalDetailType|null
     */
    public function getAdditionalDetail()
    {
        return $this->AdditionalDetail;
    }
    /**
     * Set AdditionalDetail value
     * @param \StructType\AdditionalDetailType $additionalDetail
     * @return \StructType\PaymentDetailType
     */
    public function setAdditionalDetail(\StructType\AdditionalDetailType $additionalDetail = null)
    {
        $this->AdditionalDetail = $additionalDetail;
        return $this;
    }
    /**
     * Get InstallmentDetail value
     * @return \StructType\InstallmentDetail|null
     */
    public function getInstallmentDetail()
    {
        return $this->InstallmentDetail;
    }
    /**
     * Set InstallmentDetail value
     * @param \StructType\InstallmentDetail $installmentDetail
     * @return \StructType\PaymentDetailType
     */
    public function setInstallmentDetail(\StructType\InstallmentDetail $installmentDetail = null)
    {
        $this->InstallmentDetail = $installmentDetail;
        return $this;
    }
    /**
     * Get VirtualPaymentDetail value
     * @return \StructType\VirtualPaymentDetail|null
     */
    public function getVirtualPaymentDetail()
    {
        return $this->VirtualPaymentDetail;
    }
    /**
     * Set VirtualPaymentDetail value
     * @param \StructType\VirtualPaymentDetail $virtualPaymentDetail
     * @return \StructType\PaymentDetailType
     */
    public function setVirtualPaymentDetail(\StructType\VirtualPaymentDetail $virtualPaymentDetail = null)
    {
        $this->VirtualPaymentDetail = $virtualPaymentDetail;
        return $this;
    }
    /**
     * Get FOP_RPH value
     * @return string|null
     */
    public function getFOP_RPH()
    {
        return $this->FOP_RPH;
    }
    /**
     * Set FOP_RPH value
     * @param string $fOP_RPH
     * @return \StructType\PaymentDetailType
     */
    public function setFOP_RPH($fOP_RPH = null)
    {
        // validation for constraint: string
        if (!is_null($fOP_RPH) && !is_string($fOP_RPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fOP_RPH, true), gettype($fOP_RPH)), __LINE__);
        }
        $this->FOP_RPH = $fOP_RPH;
        return $this;
    }
    /**
     * Get PaymentRef value
     * @return string|null
     */
    public function getPaymentRef()
    {
        return $this->PaymentRef;
    }
    /**
     * Set PaymentRef value
     * @param string $paymentRef
     * @return \StructType\PaymentDetailType
     */
    public function setPaymentRef($paymentRef = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRef) && !is_string($paymentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRef, true), gettype($paymentRef)), __LINE__);
        }
        $this->PaymentRef = $paymentRef;
        return $this;
    }
    /**
     * Get DeferredPaymentPeriod value
     * @return string|null
     */
    public function getDeferredPaymentPeriod()
    {
        return $this->DeferredPaymentPeriod;
    }
    /**
     * Set DeferredPaymentPeriod value
     * @param string $deferredPaymentPeriod
     * @return \StructType\PaymentDetailType
     */
    public function setDeferredPaymentPeriod($deferredPaymentPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($deferredPaymentPeriod) && !is_string($deferredPaymentPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deferredPaymentPeriod, true), gettype($deferredPaymentPeriod)), __LINE__);
        }
        $this->DeferredPaymentPeriod = $deferredPaymentPeriod;
        return $this;
    }
}
