<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Passport StructType
 * @subpackage Structs
 */
class Passport extends AbstractStructBase
{
    /**
     * The CountryOfIssue
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CountryOfIssue;
    /**
     * The Nationality
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Nationality;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Number;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ExpireDate;
    /**
     * Constructor method for Passport
     * @uses Passport::setCountryOfIssue()
     * @uses Passport::setNationality()
     * @uses Passport::setNumber()
     * @uses Passport::setExpireDate()
     * @param string $countryOfIssue
     * @param string $nationality
     * @param string $number
     * @param string $expireDate
     */
    public function __construct($countryOfIssue = null, $nationality = null, $number = null, $expireDate = null)
    {
        $this
            ->setCountryOfIssue($countryOfIssue)
            ->setNationality($nationality)
            ->setNumber($number)
            ->setExpireDate($expireDate);
    }
    /**
     * Get CountryOfIssue value
     * @return string
     */
    public function getCountryOfIssue()
    {
        return $this->CountryOfIssue;
    }
    /**
     * Set CountryOfIssue value
     * @param string $countryOfIssue
     * @return \StructType\Passport
     */
    public function setCountryOfIssue($countryOfIssue = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfIssue) && !is_string($countryOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfIssue, true), gettype($countryOfIssue)), __LINE__);
        }
        $this->CountryOfIssue = $countryOfIssue;
        return $this;
    }
    /**
     * Get Nationality value
     * @return string
     */
    public function getNationality()
    {
        return $this->Nationality;
    }
    /**
     * Set Nationality value
     * @param string $nationality
     * @return \StructType\Passport
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationality, true), gettype($nationality)), __LINE__);
        }
        $this->Nationality = $nationality;
        return $this;
    }
    /**
     * Get Number value
     * @return string
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\Passport
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\Passport
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
}
