<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageData StructType
 * @subpackage Structs
 */
class MessageData extends AbstractStructBase
{
    /**
     * The MessageId
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - ref: tns:MessageId
     * @var string
     */
    public $MessageId;
    /**
     * The Timestamp
     * Meta information extracted from the WSDL
     * - ref: tns:Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The RefToMessageId
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - minOccurs: 0
     * - ref: tns:RefToMessageId
     * @var string
     */
    public $RefToMessageId;
    /**
     * The TimeToLive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:TimeToLive
     * @var string
     */
    public $TimeToLive;
    /**
     * The Timeout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Timeout
     * @var int
     */
    public $Timeout;
    /**
     * Constructor method for MessageData
     * @uses MessageData::setMessageId()
     * @uses MessageData::setTimestamp()
     * @uses MessageData::setRefToMessageId()
     * @uses MessageData::setTimeToLive()
     * @uses MessageData::setTimeout()
     * @param string $messageId
     * @param string $timestamp
     * @param string $refToMessageId
     * @param string $timeToLive
     * @param int $timeout
     */
    public function __construct($messageId = null, $timestamp = null, $refToMessageId = null, $timeToLive = null, $timeout = null)
    {
        $this
            ->setMessageId($messageId)
            ->setTimestamp($timestamp)
            ->setRefToMessageId($refToMessageId)
            ->setTimeToLive($timeToLive)
            ->setTimeout($timeout);
    }
    /**
     * Get MessageId value
     * @return string|null
     */
    public function getMessageId()
    {
        return $this->MessageId;
    }
    /**
     * Set MessageId value
     * @param string $messageId
     * @return \StructType\MessageData
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: string
        if (!is_null($messageId) && !is_string($messageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageId, true), gettype($messageId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($messageId) && mb_strlen($messageId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($messageId)), __LINE__);
        }
        $this->MessageId = $messageId;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \StructType\MessageData
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get RefToMessageId value
     * @return string|null
     */
    public function getRefToMessageId()
    {
        return $this->RefToMessageId;
    }
    /**
     * Set RefToMessageId value
     * @param string $refToMessageId
     * @return \StructType\MessageData
     */
    public function setRefToMessageId($refToMessageId = null)
    {
        // validation for constraint: string
        if (!is_null($refToMessageId) && !is_string($refToMessageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refToMessageId, true), gettype($refToMessageId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($refToMessageId) && mb_strlen($refToMessageId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($refToMessageId)), __LINE__);
        }
        $this->RefToMessageId = $refToMessageId;
        return $this;
    }
    /**
     * Get TimeToLive value
     * @return string|null
     */
    public function getTimeToLive()
    {
        return $this->TimeToLive;
    }
    /**
     * Set TimeToLive value
     * @param string $timeToLive
     * @return \StructType\MessageData
     */
    public function setTimeToLive($timeToLive = null)
    {
        // validation for constraint: string
        if (!is_null($timeToLive) && !is_string($timeToLive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeToLive, true), gettype($timeToLive)), __LINE__);
        }
        $this->TimeToLive = $timeToLive;
        return $this;
    }
    /**
     * Get Timeout value
     * @return int|null
     */
    public function getTimeout()
    {
        return $this->Timeout;
    }
    /**
     * Set Timeout value
     * @param int $timeout
     * @return \StructType\MessageData
     */
    public function setTimeout($timeout = null)
    {
        // validation for constraint: int
        if (!is_null($timeout) && !(is_int($timeout) || ctype_digit($timeout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeout, true), gettype($timeout)), __LINE__);
        }
        $this->Timeout = $timeout;
        return $this;
    }
}
