<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestType StructType
 * @subpackage Structs
 */
class GuestType extends AbstractStructBase
{
    /**
     * The AgeQualifyingCode
     * Meta information extracted from the WSDL
     * - documentation: A code representing a business rule that determines the charges for a guest based upon age rannge (e.g. Adult, Child, Senior, Child With Adult, Child Without Adult). This attribute allows for an increase in rate by occupant class.
     * Refer to OTA Code List Age Qualifying Code (AQC). | Used for codes in the OTA code tables.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}
     * - use: optional
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The VIP
     * Meta information extracted from the WSDL
     * - documentation: Guest is VIP indicator.
     * - use: optional
     * @var bool
     */
    public $VIP;
    /**
     * The PrimaryIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true indicates this is the primary guest.
     * - use: optional
     * @var bool
     */
    public $PrimaryIndicator;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Title;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $FirstName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $MiddleName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $LastName;
    /**
     * Constructor method for GuestType
     * @uses GuestType::setAgeQualifyingCode()
     * @uses GuestType::setVIP()
     * @uses GuestType::setPrimaryIndicator()
     * @uses GuestType::setName()
     * @uses GuestType::setTitle()
     * @uses GuestType::setFirstName()
     * @uses GuestType::setMiddleName()
     * @uses GuestType::setLastName()
     * @param string $ageQualifyingCode
     * @param bool $vIP
     * @param bool $primaryIndicator
     * @param string $name
     * @param string $title
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     */
    public function __construct($ageQualifyingCode = null, $vIP = null, $primaryIndicator = null, $name = null, $title = null, $firstName = null, $middleName = null, $lastName = null)
    {
        $this
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setVIP($vIP)
            ->setPrimaryIndicator($primaryIndicator)
            ->setName($name)
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName);
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \StructType\GuestType
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3})
        if (!is_null($ageQualifyingCode) && !preg_match('/[0-9A-Z]{1,3}/', $ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}', var_export($ageQualifyingCode, true)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get VIP value
     * @return bool|null
     */
    public function getVIP()
    {
        return $this->VIP;
    }
    /**
     * Set VIP value
     * @param bool $vIP
     * @return \StructType\GuestType
     */
    public function setVIP($vIP = null)
    {
        // validation for constraint: boolean
        if (!is_null($vIP) && !is_bool($vIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vIP, true), gettype($vIP)), __LINE__);
        }
        $this->VIP = $vIP;
        return $this;
    }
    /**
     * Get PrimaryIndicator value
     * @return bool|null
     */
    public function getPrimaryIndicator()
    {
        return $this->PrimaryIndicator;
    }
    /**
     * Set PrimaryIndicator value
     * @param bool $primaryIndicator
     * @return \StructType\GuestType
     */
    public function setPrimaryIndicator($primaryIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryIndicator) && !is_bool($primaryIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primaryIndicator, true), gettype($primaryIndicator)), __LINE__);
        }
        $this->PrimaryIndicator = $primaryIndicator;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\GuestType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\GuestType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\GuestType
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\GuestType
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\GuestType
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
}
