<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fault StructType
 * Meta information extracted from the WSDL
 * - documentation: Fault reporting structure
 * - final: extension
 * - type: tns:Fault
 * @subpackage Structs
 */
class Fault extends AbstractStructBase
{
    /**
     * The faultcode
     * @var string
     */
    public $faultcode;
    /**
     * The faultstring
     * @var string
     */
    public $faultstring;
    /**
     * The faultactor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $faultactor;
    /**
     * The detail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Detail
     */
    public $detail;
    /**
     * Constructor method for Fault
     * @uses Fault::setFaultcode()
     * @uses Fault::setFaultstring()
     * @uses Fault::setFaultactor()
     * @uses Fault::setDetail()
     * @param string $faultcode
     * @param string $faultstring
     * @param string $faultactor
     * @param \StructType\Detail $detail
     */
    public function __construct($faultcode = null, $faultstring = null, $faultactor = null, \StructType\Detail $detail = null)
    {
        $this
            ->setFaultcode($faultcode)
            ->setFaultstring($faultstring)
            ->setFaultactor($faultactor)
            ->setDetail($detail);
    }
    /**
     * Get faultcode value
     * @return string|null
     */
    public function getFaultcode()
    {
        return $this->faultcode;
    }
    /**
     * Set faultcode value
     * @param string $faultcode
     * @return \StructType\Fault
     */
    public function setFaultcode($faultcode = null)
    {
        // validation for constraint: string
        if (!is_null($faultcode) && !is_string($faultcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultcode, true), gettype($faultcode)), __LINE__);
        }
        $this->faultcode = $faultcode;
        return $this;
    }
    /**
     * Get faultstring value
     * @return string|null
     */
    public function getFaultstring()
    {
        return $this->faultstring;
    }
    /**
     * Set faultstring value
     * @param string $faultstring
     * @return \StructType\Fault
     */
    public function setFaultstring($faultstring = null)
    {
        // validation for constraint: string
        if (!is_null($faultstring) && !is_string($faultstring)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultstring, true), gettype($faultstring)), __LINE__);
        }
        $this->faultstring = $faultstring;
        return $this;
    }
    /**
     * Get faultactor value
     * @return string|null
     */
    public function getFaultactor()
    {
        return $this->faultactor;
    }
    /**
     * Set faultactor value
     * @param string $faultactor
     * @return \StructType\Fault
     */
    public function setFaultactor($faultactor = null)
    {
        // validation for constraint: string
        if (!is_null($faultactor) && !is_string($faultactor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultactor, true), gettype($faultactor)), __LINE__);
        }
        $this->faultactor = $faultactor;
        return $this;
    }
    /**
     * Get detail value
     * @return \StructType\Detail|null
     */
    public function getDetail()
    {
        return $this->detail;
    }
    /**
     * Set detail value
     * @param \StructType\Detail $detail
     * @return \StructType\Fault
     */
    public function setDetail(\StructType\Detail $detail = null)
    {
        $this->detail = $detail;
        return $this;
    }
}
