<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorList StructType
 * @subpackage Structs
 */
class ErrorList extends AbstractStructBase
{
    /**
     * The highestSeverity
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $highestSeverity;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: tns:Error
     * @var \StructType\Error[]
     */
    public $Error;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for ErrorList
     * @uses ErrorList::setHighestSeverity()
     * @uses ErrorList::setError()
     * @uses ErrorList::setAny()
     * @uses ErrorList::setId()
     * @uses ErrorList::setVersion()
     * @param string $highestSeverity
     * @param \StructType\Error[] $error
     * @param \DOMDocument $any
     * @param string $id
     * @param string $version
     */
    public function __construct($highestSeverity = null, array $error = array(), \DOMDocument $any = null, $id = null, $version = null)
    {
        $this
            ->setHighestSeverity($highestSeverity)
            ->setError($error)
            ->setAny($any)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get highestSeverity value
     * @return string
     */
    public function getHighestSeverity()
    {
        return $this->highestSeverity;
    }
    /**
     * Set highestSeverity value
     * @uses \EnumType\Severity_type::valueIsValid()
     * @uses \EnumType\Severity_type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $highestSeverity
     * @return \StructType\ErrorList
     */
    public function setHighestSeverity($highestSeverity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Severity_type::valueIsValid($highestSeverity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Severity_type', is_array($highestSeverity) ? implode(', ', $highestSeverity) : var_export($highestSeverity, true), implode(', ', \EnumType\Severity_type::getValidValues())), __LINE__);
        }
        $this->highestSeverity = $highestSeverity;
        return $this;
    }
    /**
     * Get Error value
     * @return \StructType\Error[]|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * This method is responsible for validating the values passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorForArrayConstraintsFromSetError(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorListErrorItem) {
            // validation for constraint: itemType
            if (!$errorListErrorItem instanceof \StructType\Error) {
                $invalidValues[] = is_object($errorListErrorItem) ? get_class($errorListErrorItem) : sprintf('%s(%s)', gettype($errorListErrorItem), var_export($errorListErrorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Error property can only contain items of type \StructType\Error, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Error value
     * @throws \InvalidArgumentException
     * @param \StructType\Error[] $error
     * @return \StructType\ErrorList
     */
    public function setError(array $error = array())
    {
        // validation for constraint: array
        if ('' !== ($errorArrayErrorMessage = self::validateErrorForArrayConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorArrayErrorMessage, __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Add item to Error value
     * @throws \InvalidArgumentException
     * @param \StructType\Error $item
     * @return \StructType\ErrorList
     */
    public function addToError(\StructType\Error $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Error) {
            throw new \InvalidArgumentException(sprintf('The Error property can only contain items of type \StructType\Error, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Error[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\ErrorList
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ErrorList
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\ErrorList
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($version) && mb_strlen($version) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
