<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DBIItems StructType
 * Meta information extracted from the WSDL
 * - documentation: Descriptive Billing Information (DBI) Items
 * @subpackage Structs
 */
class DBIItems extends AbstractStructBase
{
    /**
     * The PassengerDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\PassengerDetail[]
     */
    public $PassengerDetail;
    /**
     * Constructor method for DBIItems
     * @uses DBIItems::setPassengerDetail()
     * @param \StructType\PassengerDetail[] $passengerDetail
     */
    public function __construct(array $passengerDetail = array())
    {
        $this
            ->setPassengerDetail($passengerDetail);
    }
    /**
     * Get PassengerDetail value
     * @return \StructType\PassengerDetail[]|null
     */
    public function getPassengerDetail()
    {
        return $this->PassengerDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setPassengerDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassengerDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerDetailForArrayConstraintsFromSetPassengerDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dBIItemsPassengerDetailItem) {
            // validation for constraint: itemType
            if (!$dBIItemsPassengerDetailItem instanceof \StructType\PassengerDetail) {
                $invalidValues[] = is_object($dBIItemsPassengerDetailItem) ? get_class($dBIItemsPassengerDetailItem) : sprintf('%s(%s)', gettype($dBIItemsPassengerDetailItem), var_export($dBIItemsPassengerDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PassengerDetail property can only contain items of type \StructType\PassengerDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PassengerDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerDetail[] $passengerDetail
     * @return \StructType\DBIItems
     */
    public function setPassengerDetail(array $passengerDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerDetailArrayErrorMessage = self::validatePassengerDetailForArrayConstraintsFromSetPassengerDetail($passengerDetail))) {
            throw new \InvalidArgumentException($passengerDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($passengerDetail) && count($passengerDetail) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($passengerDetail)), __LINE__);
        }
        $this->PassengerDetail = $passengerDetail;
        return $this;
    }
    /**
     * Add item to PassengerDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerDetail $item
     * @return \StructType\DBIItems
     */
    public function addToPassengerDetail(\StructType\PassengerDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PassengerDetail) {
            throw new \InvalidArgumentException(sprintf('The PassengerDetail property can only contain items of type \StructType\PassengerDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->PassengerDetail) && count($this->PassengerDetail) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->PassengerDetail)), __LINE__);
        }
        $this->PassengerDetail[] = $item;
        return $this;
    }
}
