<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerificationResult StructType
 * @subpackage Structs
 */
class VerificationResult extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ResponseCode;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The ApprovedAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $ApprovedAmount;
    /**
     * The BonusAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $BonusAmount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Transaction currency
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ExchangeRate
     * @var float
     */
    public $ExchangeRate;
    /**
     * The SupplierTransID
     * @var string
     */
    public $SupplierTransID;
    /**
     * The SupplierResponseCode
     * @var string
     */
    public $SupplierResponseCode;
    /**
     * Constructor method for VerificationResult
     * @uses VerificationResult::setResponseCode()
     * @uses VerificationResult::setDescription()
     * @uses VerificationResult::setApprovedAmount()
     * @uses VerificationResult::setBonusAmount()
     * @uses VerificationResult::setCurrencyCode()
     * @uses VerificationResult::setExchangeRate()
     * @uses VerificationResult::setSupplierTransID()
     * @uses VerificationResult::setSupplierResponseCode()
     * @param string $responseCode
     * @param string $description
     * @param float $approvedAmount
     * @param float $bonusAmount
     * @param string $currencyCode
     * @param float $exchangeRate
     * @param string $supplierTransID
     * @param string $supplierResponseCode
     */
    public function __construct($responseCode = null, $description = null, $approvedAmount = null, $bonusAmount = null, $currencyCode = null, $exchangeRate = null, $supplierTransID = null, $supplierResponseCode = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setDescription($description)
            ->setApprovedAmount($approvedAmount)
            ->setBonusAmount($bonusAmount)
            ->setCurrencyCode($currencyCode)
            ->setExchangeRate($exchangeRate)
            ->setSupplierTransID($supplierTransID)
            ->setSupplierResponseCode($supplierResponseCode);
    }
    /**
     * Get ResponseCode value
     * @return string
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \StructType\VerificationResult
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\VerificationResult
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ApprovedAmount value
     * @return float|null
     */
    public function getApprovedAmount()
    {
        return $this->ApprovedAmount;
    }
    /**
     * Set ApprovedAmount value
     * @param float $approvedAmount
     * @return \StructType\VerificationResult
     */
    public function setApprovedAmount($approvedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($approvedAmount) && !(is_float($approvedAmount) || is_numeric($approvedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($approvedAmount, true), gettype($approvedAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($approvedAmount) && mb_strlen(mb_substr($approvedAmount, false !== mb_strpos($approvedAmount, '.') ? mb_strpos($approvedAmount, '.') + 1 : mb_strlen($approvedAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($approvedAmount, true), mb_strlen(mb_substr($approvedAmount, mb_strpos($approvedAmount, '.') + 1))), __LINE__);
        }
        $this->ApprovedAmount = $approvedAmount;
        return $this;
    }
    /**
     * Get BonusAmount value
     * @return float|null
     */
    public function getBonusAmount()
    {
        return $this->BonusAmount;
    }
    /**
     * Set BonusAmount value
     * @param float $bonusAmount
     * @return \StructType\VerificationResult
     */
    public function setBonusAmount($bonusAmount = null)
    {
        // validation for constraint: float
        if (!is_null($bonusAmount) && !(is_float($bonusAmount) || is_numeric($bonusAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonusAmount, true), gettype($bonusAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($bonusAmount) && mb_strlen(mb_substr($bonusAmount, false !== mb_strpos($bonusAmount, '.') ? mb_strpos($bonusAmount, '.') + 1 : mb_strlen($bonusAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($bonusAmount, true), mb_strlen(mb_substr($bonusAmount, mb_strpos($bonusAmount, '.') + 1))), __LINE__);
        }
        $this->BonusAmount = $bonusAmount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\VerificationResult
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\VerificationResult
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \StructType\VerificationResult
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransID) && !is_string($supplierTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransID, true), gettype($supplierTransID)), __LINE__);
        }
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
    /**
     * Get SupplierResponseCode value
     * @return string|null
     */
    public function getSupplierResponseCode()
    {
        return $this->SupplierResponseCode;
    }
    /**
     * Set SupplierResponseCode value
     * @param string $supplierResponseCode
     * @return \StructType\VerificationResult
     */
    public function setSupplierResponseCode($supplierResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierResponseCode) && !is_string($supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierResponseCode, true), gettype($supplierResponseCode)), __LINE__);
        }
        $this->SupplierResponseCode = $supplierResponseCode;
        return $this;
    }
}
