<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VCL_Info StructType
 * @subpackage Structs
 */
class VCL_Info extends AbstractStructBase
{
    /**
     * The MCC
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MCC;
    /**
     * The AID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AID;
    /**
     * The CAI
     * Meta information extracted from the WSDL
     * - documentation: CAI or SE number
     * - use: optional
     * @var string
     */
    public $CAI;
    /**
     * Constructor method for VCL_Info
     * @uses VCL_Info::setMCC()
     * @uses VCL_Info::setAID()
     * @uses VCL_Info::setCAI()
     * @param string $mCC
     * @param string $aID
     * @param string $cAI
     */
    public function __construct($mCC = null, $aID = null, $cAI = null)
    {
        $this
            ->setMCC($mCC)
            ->setAID($aID)
            ->setCAI($cAI);
    }
    /**
     * Get MCC value
     * @return string|null
     */
    public function getMCC()
    {
        return $this->MCC;
    }
    /**
     * Set MCC value
     * @param string $mCC
     * @return \StructType\VCL_Info
     */
    public function setMCC($mCC = null)
    {
        // validation for constraint: string
        if (!is_null($mCC) && !is_string($mCC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mCC, true), gettype($mCC)), __LINE__);
        }
        $this->MCC = $mCC;
        return $this;
    }
    /**
     * Get AID value
     * @return string|null
     */
    public function getAID()
    {
        return $this->AID;
    }
    /**
     * Set AID value
     * @param string $aID
     * @return \StructType\VCL_Info
     */
    public function setAID($aID = null)
    {
        // validation for constraint: string
        if (!is_null($aID) && !is_string($aID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aID, true), gettype($aID)), __LINE__);
        }
        $this->AID = $aID;
        return $this;
    }
    /**
     * Get CAI value
     * @return string|null
     */
    public function getCAI()
    {
        return $this->CAI;
    }
    /**
     * Set CAI value
     * @param string $cAI
     * @return \StructType\VCL_Info
     */
    public function setCAI($cAI = null)
    {
        // validation for constraint: string
        if (!is_null($cAI) && !is_string($cAI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAI, true), gettype($cAI)), __LINE__);
        }
        $this->CAI = $cAI;
        return $this;
    }
}
