<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Results StructType
 * @subpackage Structs
 */
class Results extends AbstractStructBase
{
    /**
     * The FOP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FOP
     */
    public $FOP;
    /**
     * The AccountValidationResult
     * Meta information extracted from the WSDL
     * - choice: AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | RegisterAuthResult | ValidateAndQueryPaymentDetailResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountValidationResult
     */
    public $AccountValidationResult;
    /**
     * The AuthorizationResult
     * Meta information extracted from the WSDL
     * - choice: AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | RegisterAuthResult | ValidateAndQueryPaymentDetailResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AuthorizationResultType
     */
    public $AuthorizationResult;
    /**
     * The ConfirmAuthResult
     * Meta information extracted from the WSDL
     * - choice: AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | RegisterAuthResult | ValidateAndQueryPaymentDetailResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\ConfirmAuthResultType[]
     */
    public $ConfirmAuthResult;
    /**
     * The CancelAuthResult
     * Meta information extracted from the WSDL
     * - choice: AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | RegisterAuthResult | ValidateAndQueryPaymentDetailResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\CancelAuthResultType[]
     */
    public $CancelAuthResult;
    /**
     * The RefundResult
     * Meta information extracted from the WSDL
     * - choice: AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | RegisterAuthResult | ValidateAndQueryPaymentDetailResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\RefundResultType[]
     */
    public $RefundResult;
    /**
     * The CancelRefundResult
     * Meta information extracted from the WSDL
     * - choice: AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | RegisterAuthResult | ValidateAndQueryPaymentDetailResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\CancelRefundResultType[]
     */
    public $CancelRefundResult;
    /**
     * The RegisterAuthResult
     * Meta information extracted from the WSDL
     * - choice: AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | RegisterAuthResult | ValidateAndQueryPaymentDetailResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RegisterAuthResultType
     */
    public $RegisterAuthResult;
    /**
     * The ValidateAndQueryPaymentDetailResult
     * Meta information extracted from the WSDL
     * - choice: AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | RegisterAuthResult | ValidateAndQueryPaymentDetailResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ValidateAndQueryPaymentDetailResultType
     */
    public $ValidateAndQueryPaymentDetailResult;
    /**
     * The T3DS_AuthenticationResult
     * Meta information extracted from the WSDL
     * - documentation: 3DS Authentication result details
     * - choice: AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | RegisterAuthResult | ValidateAndQueryPaymentDetailResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\T3DS_AuthenticationResultType[]
     */
    public $T3DS_AuthenticationResult;
    /**
     * The PaymentDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentDetailType
     */
    public $PaymentDetail;
    /**
     * The FraudScreenResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FraudScreenResultType
     */
    public $FraudScreenResult;
    /**
     * The TokenizationResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TokenizationResultType
     */
    public $TokenizationResult;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RemarksType
     */
    public $Remarks;
    /**
     * The ReturnURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReturnURL;
    /**
     * The FOP_RPH
     * @var string
     */
    public $FOP_RPH;
    /**
     * The POSActionCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $POSActionCode;
    /**
     * Constructor method for Results
     * @uses Results::setFOP()
     * @uses Results::setAccountValidationResult()
     * @uses Results::setAuthorizationResult()
     * @uses Results::setConfirmAuthResult()
     * @uses Results::setCancelAuthResult()
     * @uses Results::setRefundResult()
     * @uses Results::setCancelRefundResult()
     * @uses Results::setRegisterAuthResult()
     * @uses Results::setValidateAndQueryPaymentDetailResult()
     * @uses Results::setT3DS_AuthenticationResult()
     * @uses Results::setPaymentDetail()
     * @uses Results::setFraudScreenResult()
     * @uses Results::setTokenizationResult()
     * @uses Results::setRemarks()
     * @uses Results::setReturnURL()
     * @uses Results::setFOP_RPH()
     * @uses Results::setPOSActionCode()
     * @param \StructType\FOP $fOP
     * @param \StructType\AccountValidationResult $accountValidationResult
     * @param \StructType\AuthorizationResultType $authorizationResult
     * @param \StructType\ConfirmAuthResultType[] $confirmAuthResult
     * @param \StructType\CancelAuthResultType[] $cancelAuthResult
     * @param \StructType\RefundResultType[] $refundResult
     * @param \StructType\CancelRefundResultType[] $cancelRefundResult
     * @param \StructType\RegisterAuthResultType $registerAuthResult
     * @param \StructType\ValidateAndQueryPaymentDetailResultType $validateAndQueryPaymentDetailResult
     * @param \StructType\T3DS_AuthenticationResultType[] $t3DS_AuthenticationResult
     * @param \StructType\PaymentDetailType $paymentDetail
     * @param \StructType\FraudScreenResultType $fraudScreenResult
     * @param \StructType\TokenizationResultType $tokenizationResult
     * @param \StructType\RemarksType $remarks
     * @param string $returnURL
     * @param string $fOP_RPH
     * @param string $pOSActionCode
     */
    public function __construct(\StructType\FOP $fOP = null, \StructType\AccountValidationResult $accountValidationResult = null, \StructType\AuthorizationResultType $authorizationResult = null, array $confirmAuthResult = array(), array $cancelAuthResult = array(), array $refundResult = array(), array $cancelRefundResult = array(), \StructType\RegisterAuthResultType $registerAuthResult = null, \StructType\ValidateAndQueryPaymentDetailResultType $validateAndQueryPaymentDetailResult = null, array $t3DS_AuthenticationResult = array(), \StructType\PaymentDetailType $paymentDetail = null, \StructType\FraudScreenResultType $fraudScreenResult = null, \StructType\TokenizationResultType $tokenizationResult = null, \StructType\RemarksType $remarks = null, $returnURL = null, $fOP_RPH = null, $pOSActionCode = null)
    {
        $this
            ->setFOP($fOP)
            ->setAccountValidationResult($accountValidationResult)
            ->setAuthorizationResult($authorizationResult)
            ->setConfirmAuthResult($confirmAuthResult)
            ->setCancelAuthResult($cancelAuthResult)
            ->setRefundResult($refundResult)
            ->setCancelRefundResult($cancelRefundResult)
            ->setRegisterAuthResult($registerAuthResult)
            ->setValidateAndQueryPaymentDetailResult($validateAndQueryPaymentDetailResult)
            ->setT3DS_AuthenticationResult($t3DS_AuthenticationResult)
            ->setPaymentDetail($paymentDetail)
            ->setFraudScreenResult($fraudScreenResult)
            ->setTokenizationResult($tokenizationResult)
            ->setRemarks($remarks)
            ->setReturnURL($returnURL)
            ->setFOP_RPH($fOP_RPH)
            ->setPOSActionCode($pOSActionCode);
    }
    /**
     * Get FOP value
     * @return \StructType\FOP|null
     */
    public function getFOP()
    {
        return $this->FOP;
    }
    /**
     * Set FOP value
     * @param \StructType\FOP $fOP
     * @return \StructType\Results
     */
    public function setFOP(\StructType\FOP $fOP = null)
    {
        $this->FOP = $fOP;
        return $this;
    }
    /**
     * Get AccountValidationResult value
     * @return \StructType\AccountValidationResult|null
     */
    public function getAccountValidationResult()
    {
        return isset($this->AccountValidationResult) ? $this->AccountValidationResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAccountValidationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountValidationResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAccountValidationResultForChoiceConstraintsFromSetAccountValidationResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'RegisterAuthResult',
            'ValidateAndQueryPaymentDetailResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AccountValidationResult can\'t be set as the property %s is already set. Only one property must be set among these properties: AccountValidationResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AccountValidationResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccountValidationResult $accountValidationResult
     * @return \StructType\Results
     */
    public function setAccountValidationResult(\StructType\AccountValidationResult $accountValidationResult = null)
    {
        // validation for constraint: choice(AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, RegisterAuthResult, ValidateAndQueryPaymentDetailResult, T3DS_AuthenticationResult)
        if ('' !== ($accountValidationResultChoiceErrorMessage = self::validateAccountValidationResultForChoiceConstraintsFromSetAccountValidationResult($accountValidationResult))) {
            throw new \InvalidArgumentException($accountValidationResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($accountValidationResult) || (is_array($accountValidationResult) && empty($accountValidationResult))) {
            unset($this->AccountValidationResult);
        } else {
            $this->AccountValidationResult = $accountValidationResult;
        }
        return $this;
    }
    /**
     * Get AuthorizationResult value
     * @return \StructType\AuthorizationResultType|null
     */
    public function getAuthorizationResult()
    {
        return isset($this->AuthorizationResult) ? $this->AuthorizationResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAuthorizationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthorizationResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAuthorizationResultForChoiceConstraintsFromSetAuthorizationResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountValidationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'RegisterAuthResult',
            'ValidateAndQueryPaymentDetailResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AuthorizationResult can\'t be set as the property %s is already set. Only one property must be set among these properties: AuthorizationResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AuthorizationResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorizationResultType $authorizationResult
     * @return \StructType\Results
     */
    public function setAuthorizationResult(\StructType\AuthorizationResultType $authorizationResult = null)
    {
        // validation for constraint: choice(AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, RegisterAuthResult, ValidateAndQueryPaymentDetailResult, T3DS_AuthenticationResult)
        if ('' !== ($authorizationResultChoiceErrorMessage = self::validateAuthorizationResultForChoiceConstraintsFromSetAuthorizationResult($authorizationResult))) {
            throw new \InvalidArgumentException($authorizationResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($authorizationResult) || (is_array($authorizationResult) && empty($authorizationResult))) {
            unset($this->AuthorizationResult);
        } else {
            $this->AuthorizationResult = $authorizationResult;
        }
        return $this;
    }
    /**
     * Get ConfirmAuthResult value
     * @return \StructType\ConfirmAuthResultType[]|null
     */
    public function getConfirmAuthResult()
    {
        return isset($this->ConfirmAuthResult) ? $this->ConfirmAuthResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setConfirmAuthResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConfirmAuthResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConfirmAuthResultForArrayConstraintsFromSetConfirmAuthResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resultsConfirmAuthResultItem) {
            // validation for constraint: itemType
            if (!$resultsConfirmAuthResultItem instanceof \StructType\ConfirmAuthResultType) {
                $invalidValues[] = is_object($resultsConfirmAuthResultItem) ? get_class($resultsConfirmAuthResultItem) : sprintf('%s(%s)', gettype($resultsConfirmAuthResultItem), var_export($resultsConfirmAuthResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConfirmAuthResult property can only contain items of type \StructType\ConfirmAuthResultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setConfirmAuthResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConfirmAuthResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateConfirmAuthResultForChoiceConstraintsFromSetConfirmAuthResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountValidationResult',
            'AuthorizationResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'RegisterAuthResult',
            'ValidateAndQueryPaymentDetailResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ConfirmAuthResult can\'t be set as the property %s is already set. Only one property must be set among these properties: ConfirmAuthResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ConfirmAuthResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\ConfirmAuthResultType[] $confirmAuthResult
     * @return \StructType\Results
     */
    public function setConfirmAuthResult(array $confirmAuthResult = array())
    {
        // validation for constraint: array
        if ('' !== ($confirmAuthResultArrayErrorMessage = self::validateConfirmAuthResultForArrayConstraintsFromSetConfirmAuthResult($confirmAuthResult))) {
            throw new \InvalidArgumentException($confirmAuthResultArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, RegisterAuthResult, ValidateAndQueryPaymentDetailResult, T3DS_AuthenticationResult)
        if ('' !== ($confirmAuthResultChoiceErrorMessage = self::validateConfirmAuthResultForChoiceConstraintsFromSetConfirmAuthResult($confirmAuthResult))) {
            throw new \InvalidArgumentException($confirmAuthResultChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($confirmAuthResult) && count($confirmAuthResult) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($confirmAuthResult)), __LINE__);
        }
        if (is_null($confirmAuthResult) || (is_array($confirmAuthResult) && empty($confirmAuthResult))) {
            unset($this->ConfirmAuthResult);
        } else {
            $this->ConfirmAuthResult = $confirmAuthResult;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToConfirmAuthResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToConfirmAuthResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToConfirmAuthResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountValidationResult',
            'AuthorizationResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'RegisterAuthResult',
            'ValidateAndQueryPaymentDetailResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ConfirmAuthResult can\'t be set as the property %s is already set. Only one property must be set among these properties: ConfirmAuthResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to ConfirmAuthResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ConfirmAuthResultType $item
     * @return \StructType\Results
     */
    public function addToConfirmAuthResult(\StructType\ConfirmAuthResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConfirmAuthResultType) {
            throw new \InvalidArgumentException(sprintf('The ConfirmAuthResult property can only contain items of type \StructType\ConfirmAuthResultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, RegisterAuthResult, ValidateAndQueryPaymentDetailResult, T3DS_AuthenticationResult)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToConfirmAuthResult($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->ConfirmAuthResult) && count($this->ConfirmAuthResult) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->ConfirmAuthResult)), __LINE__);
        }
        $this->ConfirmAuthResult[] = $item;
        return $this;
    }
    /**
     * Get CancelAuthResult value
     * @return \StructType\CancelAuthResultType[]|null
     */
    public function getCancelAuthResult()
    {
        return isset($this->CancelAuthResult) ? $this->CancelAuthResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelAuthResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelAuthResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelAuthResultForArrayConstraintsFromSetCancelAuthResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resultsCancelAuthResultItem) {
            // validation for constraint: itemType
            if (!$resultsCancelAuthResultItem instanceof \StructType\CancelAuthResultType) {
                $invalidValues[] = is_object($resultsCancelAuthResultItem) ? get_class($resultsCancelAuthResultItem) : sprintf('%s(%s)', gettype($resultsCancelAuthResultItem), var_export($resultsCancelAuthResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelAuthResult property can only contain items of type \StructType\CancelAuthResultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setCancelAuthResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelAuthResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCancelAuthResultForChoiceConstraintsFromSetCancelAuthResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'RegisterAuthResult',
            'ValidateAndQueryPaymentDetailResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CancelAuthResult can\'t be set as the property %s is already set. Only one property must be set among these properties: CancelAuthResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CancelAuthResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\CancelAuthResultType[] $cancelAuthResult
     * @return \StructType\Results
     */
    public function setCancelAuthResult(array $cancelAuthResult = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelAuthResultArrayErrorMessage = self::validateCancelAuthResultForArrayConstraintsFromSetCancelAuthResult($cancelAuthResult))) {
            throw new \InvalidArgumentException($cancelAuthResultArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, RegisterAuthResult, ValidateAndQueryPaymentDetailResult, T3DS_AuthenticationResult)
        if ('' !== ($cancelAuthResultChoiceErrorMessage = self::validateCancelAuthResultForChoiceConstraintsFromSetCancelAuthResult($cancelAuthResult))) {
            throw new \InvalidArgumentException($cancelAuthResultChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($cancelAuthResult) && count($cancelAuthResult) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($cancelAuthResult)), __LINE__);
        }
        if (is_null($cancelAuthResult) || (is_array($cancelAuthResult) && empty($cancelAuthResult))) {
            unset($this->CancelAuthResult);
        } else {
            $this->CancelAuthResult = $cancelAuthResult;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToCancelAuthResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToCancelAuthResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToCancelAuthResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'RegisterAuthResult',
            'ValidateAndQueryPaymentDetailResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CancelAuthResult can\'t be set as the property %s is already set. Only one property must be set among these properties: CancelAuthResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to CancelAuthResult value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelAuthResultType $item
     * @return \StructType\Results
     */
    public function addToCancelAuthResult(\StructType\CancelAuthResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelAuthResultType) {
            throw new \InvalidArgumentException(sprintf('The CancelAuthResult property can only contain items of type \StructType\CancelAuthResultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, RegisterAuthResult, ValidateAndQueryPaymentDetailResult, T3DS_AuthenticationResult)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToCancelAuthResult($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->CancelAuthResult) && count($this->CancelAuthResult) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->CancelAuthResult)), __LINE__);
        }
        $this->CancelAuthResult[] = $item;
        return $this;
    }
    /**
     * Get RefundResult value
     * @return \StructType\RefundResultType[]|null
     */
    public function getRefundResult()
    {
        return isset($this->RefundResult) ? $this->RefundResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRefundResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRefundResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRefundResultForArrayConstraintsFromSetRefundResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resultsRefundResultItem) {
            // validation for constraint: itemType
            if (!$resultsRefundResultItem instanceof \StructType\RefundResultType) {
                $invalidValues[] = is_object($resultsRefundResultItem) ? get_class($resultsRefundResultItem) : sprintf('%s(%s)', gettype($resultsRefundResultItem), var_export($resultsRefundResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RefundResult property can only contain items of type \StructType\RefundResultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setRefundResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRefundResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRefundResultForChoiceConstraintsFromSetRefundResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'CancelRefundResult',
            'RegisterAuthResult',
            'ValidateAndQueryPaymentDetailResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RefundResult can\'t be set as the property %s is already set. Only one property must be set among these properties: RefundResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RefundResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\RefundResultType[] $refundResult
     * @return \StructType\Results
     */
    public function setRefundResult(array $refundResult = array())
    {
        // validation for constraint: array
        if ('' !== ($refundResultArrayErrorMessage = self::validateRefundResultForArrayConstraintsFromSetRefundResult($refundResult))) {
            throw new \InvalidArgumentException($refundResultArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, RegisterAuthResult, ValidateAndQueryPaymentDetailResult, T3DS_AuthenticationResult)
        if ('' !== ($refundResultChoiceErrorMessage = self::validateRefundResultForChoiceConstraintsFromSetRefundResult($refundResult))) {
            throw new \InvalidArgumentException($refundResultChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($refundResult) && count($refundResult) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($refundResult)), __LINE__);
        }
        if (is_null($refundResult) || (is_array($refundResult) && empty($refundResult))) {
            unset($this->RefundResult);
        } else {
            $this->RefundResult = $refundResult;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToRefundResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToRefundResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToRefundResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'CancelRefundResult',
            'RegisterAuthResult',
            'ValidateAndQueryPaymentDetailResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RefundResult can\'t be set as the property %s is already set. Only one property must be set among these properties: RefundResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to RefundResult value
     * @throws \InvalidArgumentException
     * @param \StructType\RefundResultType $item
     * @return \StructType\Results
     */
    public function addToRefundResult(\StructType\RefundResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RefundResultType) {
            throw new \InvalidArgumentException(sprintf('The RefundResult property can only contain items of type \StructType\RefundResultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, RegisterAuthResult, ValidateAndQueryPaymentDetailResult, T3DS_AuthenticationResult)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToRefundResult($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->RefundResult) && count($this->RefundResult) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->RefundResult)), __LINE__);
        }
        $this->RefundResult[] = $item;
        return $this;
    }
    /**
     * Get CancelRefundResult value
     * @return \StructType\CancelRefundResultType[]|null
     */
    public function getCancelRefundResult()
    {
        return isset($this->CancelRefundResult) ? $this->CancelRefundResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelRefundResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelRefundResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelRefundResultForArrayConstraintsFromSetCancelRefundResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resultsCancelRefundResultItem) {
            // validation for constraint: itemType
            if (!$resultsCancelRefundResultItem instanceof \StructType\CancelRefundResultType) {
                $invalidValues[] = is_object($resultsCancelRefundResultItem) ? get_class($resultsCancelRefundResultItem) : sprintf('%s(%s)', gettype($resultsCancelRefundResultItem), var_export($resultsCancelRefundResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelRefundResult property can only contain items of type \StructType\CancelRefundResultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setCancelRefundResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelRefundResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCancelRefundResultForChoiceConstraintsFromSetCancelRefundResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'RegisterAuthResult',
            'ValidateAndQueryPaymentDetailResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CancelRefundResult can\'t be set as the property %s is already set. Only one property must be set among these properties: CancelRefundResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CancelRefundResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRefundResultType[] $cancelRefundResult
     * @return \StructType\Results
     */
    public function setCancelRefundResult(array $cancelRefundResult = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelRefundResultArrayErrorMessage = self::validateCancelRefundResultForArrayConstraintsFromSetCancelRefundResult($cancelRefundResult))) {
            throw new \InvalidArgumentException($cancelRefundResultArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, RegisterAuthResult, ValidateAndQueryPaymentDetailResult, T3DS_AuthenticationResult)
        if ('' !== ($cancelRefundResultChoiceErrorMessage = self::validateCancelRefundResultForChoiceConstraintsFromSetCancelRefundResult($cancelRefundResult))) {
            throw new \InvalidArgumentException($cancelRefundResultChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($cancelRefundResult) && count($cancelRefundResult) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($cancelRefundResult)), __LINE__);
        }
        if (is_null($cancelRefundResult) || (is_array($cancelRefundResult) && empty($cancelRefundResult))) {
            unset($this->CancelRefundResult);
        } else {
            $this->CancelRefundResult = $cancelRefundResult;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToCancelRefundResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToCancelRefundResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToCancelRefundResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'RegisterAuthResult',
            'ValidateAndQueryPaymentDetailResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CancelRefundResult can\'t be set as the property %s is already set. Only one property must be set among these properties: CancelRefundResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to CancelRefundResult value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRefundResultType $item
     * @return \StructType\Results
     */
    public function addToCancelRefundResult(\StructType\CancelRefundResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelRefundResultType) {
            throw new \InvalidArgumentException(sprintf('The CancelRefundResult property can only contain items of type \StructType\CancelRefundResultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, RegisterAuthResult, ValidateAndQueryPaymentDetailResult, T3DS_AuthenticationResult)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToCancelRefundResult($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->CancelRefundResult) && count($this->CancelRefundResult) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->CancelRefundResult)), __LINE__);
        }
        $this->CancelRefundResult[] = $item;
        return $this;
    }
    /**
     * Get RegisterAuthResult value
     * @return \StructType\RegisterAuthResultType|null
     */
    public function getRegisterAuthResult()
    {
        return isset($this->RegisterAuthResult) ? $this->RegisterAuthResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRegisterAuthResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegisterAuthResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRegisterAuthResultForChoiceConstraintsFromSetRegisterAuthResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'ValidateAndQueryPaymentDetailResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RegisterAuthResult can\'t be set as the property %s is already set. Only one property must be set among these properties: RegisterAuthResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RegisterAuthResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RegisterAuthResultType $registerAuthResult
     * @return \StructType\Results
     */
    public function setRegisterAuthResult(\StructType\RegisterAuthResultType $registerAuthResult = null)
    {
        // validation for constraint: choice(AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, RegisterAuthResult, ValidateAndQueryPaymentDetailResult, T3DS_AuthenticationResult)
        if ('' !== ($registerAuthResultChoiceErrorMessage = self::validateRegisterAuthResultForChoiceConstraintsFromSetRegisterAuthResult($registerAuthResult))) {
            throw new \InvalidArgumentException($registerAuthResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($registerAuthResult) || (is_array($registerAuthResult) && empty($registerAuthResult))) {
            unset($this->RegisterAuthResult);
        } else {
            $this->RegisterAuthResult = $registerAuthResult;
        }
        return $this;
    }
    /**
     * Get ValidateAndQueryPaymentDetailResult value
     * @return \StructType\ValidateAndQueryPaymentDetailResultType|null
     */
    public function getValidateAndQueryPaymentDetailResult()
    {
        return isset($this->ValidateAndQueryPaymentDetailResult) ? $this->ValidateAndQueryPaymentDetailResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setValidateAndQueryPaymentDetailResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValidateAndQueryPaymentDetailResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateValidateAndQueryPaymentDetailResultForChoiceConstraintsFromSetValidateAndQueryPaymentDetailResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'RegisterAuthResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ValidateAndQueryPaymentDetailResult can\'t be set as the property %s is already set. Only one property must be set among these properties: ValidateAndQueryPaymentDetailResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ValidateAndQueryPaymentDetailResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ValidateAndQueryPaymentDetailResultType $validateAndQueryPaymentDetailResult
     * @return \StructType\Results
     */
    public function setValidateAndQueryPaymentDetailResult(\StructType\ValidateAndQueryPaymentDetailResultType $validateAndQueryPaymentDetailResult = null)
    {
        // validation for constraint: choice(AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, RegisterAuthResult, ValidateAndQueryPaymentDetailResult, T3DS_AuthenticationResult)
        if ('' !== ($validateAndQueryPaymentDetailResultChoiceErrorMessage = self::validateValidateAndQueryPaymentDetailResultForChoiceConstraintsFromSetValidateAndQueryPaymentDetailResult($validateAndQueryPaymentDetailResult))) {
            throw new \InvalidArgumentException($validateAndQueryPaymentDetailResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($validateAndQueryPaymentDetailResult) || (is_array($validateAndQueryPaymentDetailResult) && empty($validateAndQueryPaymentDetailResult))) {
            unset($this->ValidateAndQueryPaymentDetailResult);
        } else {
            $this->ValidateAndQueryPaymentDetailResult = $validateAndQueryPaymentDetailResult;
        }
        return $this;
    }
    /**
     * Get T3DS_AuthenticationResult value
     * @return \StructType\T3DS_AuthenticationResultType[]|null
     */
    public function getT3DS_AuthenticationResult()
    {
        return isset($this->T3DS_AuthenticationResult) ? $this->T3DS_AuthenticationResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setT3DS_AuthenticationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setT3DS_AuthenticationResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateT3DS_AuthenticationResultForArrayConstraintsFromSetT3DS_AuthenticationResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resultsT3DS_AuthenticationResultItem) {
            // validation for constraint: itemType
            if (!$resultsT3DS_AuthenticationResultItem instanceof \StructType\T3DS_AuthenticationResultType) {
                $invalidValues[] = is_object($resultsT3DS_AuthenticationResultItem) ? get_class($resultsT3DS_AuthenticationResultItem) : sprintf('%s(%s)', gettype($resultsT3DS_AuthenticationResultItem), var_export($resultsT3DS_AuthenticationResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The T3DS_AuthenticationResult property can only contain items of type \StructType\T3DS_AuthenticationResultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setT3DS_AuthenticationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setT3DS_AuthenticationResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateT3DS_AuthenticationResultForChoiceConstraintsFromSetT3DS_AuthenticationResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'RegisterAuthResult',
            'ValidateAndQueryPaymentDetailResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property T3DS_AuthenticationResult can\'t be set as the property %s is already set. Only one property must be set among these properties: T3DS_AuthenticationResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set T3DS_AuthenticationResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\T3DS_AuthenticationResultType[] $t3DS_AuthenticationResult
     * @return \StructType\Results
     */
    public function setT3DS_AuthenticationResult(array $t3DS_AuthenticationResult = array())
    {
        // validation for constraint: array
        if ('' !== ($t3DS_AuthenticationResultArrayErrorMessage = self::validateT3DS_AuthenticationResultForArrayConstraintsFromSetT3DS_AuthenticationResult($t3DS_AuthenticationResult))) {
            throw new \InvalidArgumentException($t3DS_AuthenticationResultArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, RegisterAuthResult, ValidateAndQueryPaymentDetailResult, T3DS_AuthenticationResult)
        if ('' !== ($t3DS_AuthenticationResultChoiceErrorMessage = self::validateT3DS_AuthenticationResultForChoiceConstraintsFromSetT3DS_AuthenticationResult($t3DS_AuthenticationResult))) {
            throw new \InvalidArgumentException($t3DS_AuthenticationResultChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($t3DS_AuthenticationResult) && count($t3DS_AuthenticationResult) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($t3DS_AuthenticationResult)), __LINE__);
        }
        if (is_null($t3DS_AuthenticationResult) || (is_array($t3DS_AuthenticationResult) && empty($t3DS_AuthenticationResult))) {
            unset($this->T3DS_AuthenticationResult);
        } else {
            $this->T3DS_AuthenticationResult = $t3DS_AuthenticationResult;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToT3DS_AuthenticationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToT3DS_AuthenticationResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToT3DS_AuthenticationResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'RegisterAuthResult',
            'ValidateAndQueryPaymentDetailResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property T3DS_AuthenticationResult can\'t be set as the property %s is already set. Only one property must be set among these properties: T3DS_AuthenticationResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to T3DS_AuthenticationResult value
     * @throws \InvalidArgumentException
     * @param \StructType\T3DS_AuthenticationResultType $item
     * @return \StructType\Results
     */
    public function addToT3DS_AuthenticationResult(\StructType\T3DS_AuthenticationResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\T3DS_AuthenticationResultType) {
            throw new \InvalidArgumentException(sprintf('The T3DS_AuthenticationResult property can only contain items of type \StructType\T3DS_AuthenticationResultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, RegisterAuthResult, ValidateAndQueryPaymentDetailResult, T3DS_AuthenticationResult)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToT3DS_AuthenticationResult($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->T3DS_AuthenticationResult) && count($this->T3DS_AuthenticationResult) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->T3DS_AuthenticationResult)), __LINE__);
        }
        $this->T3DS_AuthenticationResult[] = $item;
        return $this;
    }
    /**
     * Get PaymentDetail value
     * @return \StructType\PaymentDetailType|null
     */
    public function getPaymentDetail()
    {
        return $this->PaymentDetail;
    }
    /**
     * Set PaymentDetail value
     * @param \StructType\PaymentDetailType $paymentDetail
     * @return \StructType\Results
     */
    public function setPaymentDetail(\StructType\PaymentDetailType $paymentDetail = null)
    {
        $this->PaymentDetail = $paymentDetail;
        return $this;
    }
    /**
     * Get FraudScreenResult value
     * @return \StructType\FraudScreenResultType|null
     */
    public function getFraudScreenResult()
    {
        return $this->FraudScreenResult;
    }
    /**
     * Set FraudScreenResult value
     * @param \StructType\FraudScreenResultType $fraudScreenResult
     * @return \StructType\Results
     */
    public function setFraudScreenResult(\StructType\FraudScreenResultType $fraudScreenResult = null)
    {
        $this->FraudScreenResult = $fraudScreenResult;
        return $this;
    }
    /**
     * Get TokenizationResult value
     * @return \StructType\TokenizationResultType|null
     */
    public function getTokenizationResult()
    {
        return $this->TokenizationResult;
    }
    /**
     * Set TokenizationResult value
     * @param \StructType\TokenizationResultType $tokenizationResult
     * @return \StructType\Results
     */
    public function setTokenizationResult(\StructType\TokenizationResultType $tokenizationResult = null)
    {
        $this->TokenizationResult = $tokenizationResult;
        return $this;
    }
    /**
     * Get Remarks value
     * @return \StructType\RemarksType|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param \StructType\RemarksType $remarks
     * @return \StructType\Results
     */
    public function setRemarks(\StructType\RemarksType $remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get ReturnURL value
     * @return string|null
     */
    public function getReturnURL()
    {
        return $this->ReturnURL;
    }
    /**
     * Set ReturnURL value
     * @param string $returnURL
     * @return \StructType\Results
     */
    public function setReturnURL($returnURL = null)
    {
        // validation for constraint: string
        if (!is_null($returnURL) && !is_string($returnURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnURL, true), gettype($returnURL)), __LINE__);
        }
        $this->ReturnURL = $returnURL;
        return $this;
    }
    /**
     * Get FOP_RPH value
     * @return string|null
     */
    public function getFOP_RPH()
    {
        return $this->FOP_RPH;
    }
    /**
     * Set FOP_RPH value
     * @param string $fOP_RPH
     * @return \StructType\Results
     */
    public function setFOP_RPH($fOP_RPH = null)
    {
        // validation for constraint: string
        if (!is_null($fOP_RPH) && !is_string($fOP_RPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fOP_RPH, true), gettype($fOP_RPH)), __LINE__);
        }
        $this->FOP_RPH = $fOP_RPH;
        return $this;
    }
    /**
     * Get POSActionCode value
     * @return string|null
     */
    public function getPOSActionCode()
    {
        return $this->POSActionCode;
    }
    /**
     * Set POSActionCode value
     * @param string $pOSActionCode
     * @return \StructType\Results
     */
    public function setPOSActionCode($pOSActionCode = null)
    {
        // validation for constraint: string
        if (!is_null($pOSActionCode) && !is_string($pOSActionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOSActionCode, true), gettype($pOSActionCode)), __LINE__);
        }
        $this->POSActionCode = $pOSActionCode;
        return $this;
    }
}
