<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemarksType StructType
 * @subpackage Structs
 */
class RemarksType extends AbstractStructBase
{
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $Remark;
    /**
     * Constructor method for RemarksType
     * @uses RemarksType::setRemark()
     * @param string[] $remark
     */
    public function __construct(array $remark = array())
    {
        $this
            ->setRemark($remark);
    }
    /**
     * Get Remark value
     * @return string[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $remarksTypeRemarkItem) {
            // validation for constraint: itemType
            if (!is_string($remarksTypeRemarkItem)) {
                $invalidValues[] = is_object($remarksTypeRemarkItem) ? get_class($remarksTypeRemarkItem) : sprintf('%s(%s)', gettype($remarksTypeRemarkItem), var_export($remarksTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param string[] $remark
     * @return \StructType\RemarksType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RemarksType
     */
    public function addToRemark($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
}
