<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefundResultType StructType
 * @subpackage Structs
 */
class RefundResultType extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ResponseCode;
    /**
     * The RefundAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CurrencyAmountType
     */
    public $RefundAmount;
    /**
     * The RefundRemarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RemarksType
     */
    public $RefundRemarks;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Remarks;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * The SupplierTransID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierTransID;
    /**
     * The SupplierResponseCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierResponseCode;
    /**
     * The ApprovalCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ApprovalCode;
    /**
     * Constructor method for RefundResultType
     * @uses RefundResultType::setResponseCode()
     * @uses RefundResultType::setRefundAmount()
     * @uses RefundResultType::setRefundRemarks()
     * @uses RefundResultType::setDescription()
     * @uses RefundResultType::setRemarks()
     * @uses RefundResultType::setSupplierID()
     * @uses RefundResultType::setSupplierTransID()
     * @uses RefundResultType::setSupplierResponseCode()
     * @uses RefundResultType::setApprovalCode()
     * @param string $responseCode
     * @param \StructType\CurrencyAmountType $refundAmount
     * @param \StructType\RemarksType $refundRemarks
     * @param string $description
     * @param string $remarks
     * @param string $supplierID
     * @param string $supplierTransID
     * @param string $supplierResponseCode
     * @param string $approvalCode
     */
    public function __construct($responseCode = null, \StructType\CurrencyAmountType $refundAmount = null, \StructType\RemarksType $refundRemarks = null, $description = null, $remarks = null, $supplierID = null, $supplierTransID = null, $supplierResponseCode = null, $approvalCode = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setRefundAmount($refundAmount)
            ->setRefundRemarks($refundRemarks)
            ->setDescription($description)
            ->setRemarks($remarks)
            ->setSupplierID($supplierID)
            ->setSupplierTransID($supplierTransID)
            ->setSupplierResponseCode($supplierResponseCode)
            ->setApprovalCode($approvalCode);
    }
    /**
     * Get ResponseCode value
     * @return string
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \StructType\RefundResultType
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get RefundAmount value
     * @return \StructType\CurrencyAmountType|null
     */
    public function getRefundAmount()
    {
        return $this->RefundAmount;
    }
    /**
     * Set RefundAmount value
     * @param \StructType\CurrencyAmountType $refundAmount
     * @return \StructType\RefundResultType
     */
    public function setRefundAmount(\StructType\CurrencyAmountType $refundAmount = null)
    {
        $this->RefundAmount = $refundAmount;
        return $this;
    }
    /**
     * Get RefundRemarks value
     * @return \StructType\RemarksType|null
     */
    public function getRefundRemarks()
    {
        return $this->RefundRemarks;
    }
    /**
     * Set RefundRemarks value
     * @param \StructType\RemarksType $refundRemarks
     * @return \StructType\RefundResultType
     */
    public function setRefundRemarks(\StructType\RemarksType $refundRemarks = null)
    {
        $this->RefundRemarks = $refundRemarks;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\RefundResultType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \StructType\RefundResultType
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarks, true), gettype($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \StructType\RefundResultType
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \StructType\RefundResultType
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransID) && !is_string($supplierTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransID, true), gettype($supplierTransID)), __LINE__);
        }
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
    /**
     * Get SupplierResponseCode value
     * @return string|null
     */
    public function getSupplierResponseCode()
    {
        return $this->SupplierResponseCode;
    }
    /**
     * Set SupplierResponseCode value
     * @param string $supplierResponseCode
     * @return \StructType\RefundResultType
     */
    public function setSupplierResponseCode($supplierResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierResponseCode) && !is_string($supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierResponseCode, true), gettype($supplierResponseCode)), __LINE__);
        }
        $this->SupplierResponseCode = $supplierResponseCode;
        return $this;
    }
    /**
     * Get ApprovalCode value
     * @return string|null
     */
    public function getApprovalCode()
    {
        return $this->ApprovalCode;
    }
    /**
     * Set ApprovalCode value
     * @param string $approvalCode
     * @return \StructType\RefundResultType
     */
    public function setApprovalCode($approvalCode = null)
    {
        // validation for constraint: string
        if (!is_null($approvalCode) && !is_string($approvalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalCode, true), gettype($approvalCode)), __LINE__);
        }
        $this->ApprovalCode = $approvalCode;
        return $this;
    }
}
