<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PGPDataType StructType
 * @subpackage Structs
 */
class PGPDataType extends AbstractStructBase
{
    /**
     * The PGPKeyID
     * @var string
     */
    public $PGPKeyID;
    /**
     * The PGPKeyPacket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PGPKeyPacket;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for PGPDataType
     * @uses PGPDataType::setPGPKeyID()
     * @uses PGPDataType::setPGPKeyPacket()
     * @uses PGPDataType::setAny()
     * @param string $pGPKeyID
     * @param string $pGPKeyPacket
     * @param \DOMDocument $any
     */
    public function __construct($pGPKeyID = null, $pGPKeyPacket = null, \DOMDocument $any = null)
    {
        $this
            ->setPGPKeyID($pGPKeyID)
            ->setPGPKeyPacket($pGPKeyPacket)
            ->setAny($any);
    }
    /**
     * Get PGPKeyID value
     * @return string|null
     */
    public function getPGPKeyID()
    {
        return $this->PGPKeyID;
    }
    /**
     * Set PGPKeyID value
     * @param string $pGPKeyID
     * @return \StructType\PGPDataType
     */
    public function setPGPKeyID($pGPKeyID = null)
    {
        // validation for constraint: string
        if (!is_null($pGPKeyID) && !is_string($pGPKeyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pGPKeyID, true), gettype($pGPKeyID)), __LINE__);
        }
        $this->PGPKeyID = $pGPKeyID;
        return $this;
    }
    /**
     * Get PGPKeyPacket value
     * @return string|null
     */
    public function getPGPKeyPacket()
    {
        return $this->PGPKeyPacket;
    }
    /**
     * Set PGPKeyPacket value
     * @param string $pGPKeyPacket
     * @return \StructType\PGPDataType
     */
    public function setPGPKeyPacket($pGPKeyPacket = null)
    {
        // validation for constraint: string
        if (!is_null($pGPKeyPacket) && !is_string($pGPKeyPacket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pGPKeyPacket, true), gettype($pGPKeyPacket)), __LINE__);
        }
        $this->PGPKeyPacket = $pGPKeyPacket;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\PGPDataType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
