<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MiscItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Misc doc detail
 * @subpackage Structs
 */
class MiscItemType extends AbstractStructBase
{
    /**
     * The CategoryCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CategoryCode;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: required
     * @var float
     */
    public $UnitPrice;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Quantity;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * Constructor method for MiscItemType
     * @uses MiscItemType::setCategoryCode()
     * @uses MiscItemType::setUnitPrice()
     * @uses MiscItemType::setQuantity()
     * @uses MiscItemType::setDescription()
     * @param string $categoryCode
     * @param float $unitPrice
     * @param int $quantity
     * @param string $description
     */
    public function __construct($categoryCode = null, $unitPrice = null, $quantity = null, $description = null)
    {
        $this
            ->setCategoryCode($categoryCode)
            ->setUnitPrice($unitPrice)
            ->setQuantity($quantity)
            ->setDescription($description);
    }
    /**
     * Get CategoryCode value
     * @return string
     */
    public function getCategoryCode()
    {
        return $this->CategoryCode;
    }
    /**
     * Set CategoryCode value
     * @param string $categoryCode
     * @return \StructType\MiscItemType
     */
    public function setCategoryCode($categoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($categoryCode) && !is_string($categoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryCode, true), gettype($categoryCode)), __LINE__);
        }
        $this->CategoryCode = $categoryCode;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return float
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return \StructType\MiscItemType
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($unitPrice) && mb_strlen(mb_substr($unitPrice, false !== mb_strpos($unitPrice, '.') ? mb_strpos($unitPrice, '.') + 1 : mb_strlen($unitPrice))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($unitPrice, true), mb_strlen(mb_substr($unitPrice, mb_strpos($unitPrice, '.') + 1))), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\MiscItemType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\MiscItemType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
