<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageHeader StructType
 * @subpackage Structs
 */
class MessageHeader extends AbstractStructBase
{
    /**
     * The From
     * Meta information extracted from the WSDL
     * - ref: tns:From
     * @var \StructType\From
     */
    public $From;
    /**
     * The To
     * Meta information extracted from the WSDL
     * - ref: tns:To
     * @var \StructType\To
     */
    public $To;
    /**
     * The CPAId
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - ref: tns:CPAId
     * @var string
     */
    public $CPAId;
    /**
     * The ConversationId
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - ref: tns:ConversationId
     * @var string
     */
    public $ConversationId;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - ref: tns:Service
     * @var \StructType\Service
     */
    public $Service;
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - ref: tns:Action
     * @var string
     */
    public $Action;
    /**
     * The MessageData
     * Meta information extracted from the WSDL
     * - ref: tns:MessageData
     * @var \StructType\MessageData
     */
    public $MessageData;
    /**
     * The DuplicateElimination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:DuplicateElimination
     * @var mixed
     */
    public $DuplicateElimination;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Description
     * @var \StructType\Description[]
     */
    public $Description;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for MessageHeader
     * @uses MessageHeader::setFrom()
     * @uses MessageHeader::setTo()
     * @uses MessageHeader::setCPAId()
     * @uses MessageHeader::setConversationId()
     * @uses MessageHeader::setService()
     * @uses MessageHeader::setAction()
     * @uses MessageHeader::setMessageData()
     * @uses MessageHeader::setDuplicateElimination()
     * @uses MessageHeader::setDescription()
     * @uses MessageHeader::setAny()
     * @uses MessageHeader::setId()
     * @uses MessageHeader::setVersion()
     * @param \StructType\From $from
     * @param \StructType\To $to
     * @param string $cPAId
     * @param string $conversationId
     * @param \StructType\Service $service
     * @param string $action
     * @param \StructType\MessageData $messageData
     * @param mixed $duplicateElimination
     * @param \StructType\Description[] $description
     * @param \DOMDocument $any
     * @param string $id
     * @param string $version
     */
    public function __construct(\StructType\From $from = null, \StructType\To $to = null, $cPAId = null, $conversationId = null, \StructType\Service $service = null, $action = null, \StructType\MessageData $messageData = null, $duplicateElimination = null, array $description = array(), \DOMDocument $any = null, $id = null, $version = null)
    {
        $this
            ->setFrom($from)
            ->setTo($to)
            ->setCPAId($cPAId)
            ->setConversationId($conversationId)
            ->setService($service)
            ->setAction($action)
            ->setMessageData($messageData)
            ->setDuplicateElimination($duplicateElimination)
            ->setDescription($description)
            ->setAny($any)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get From value
     * @return \StructType\From|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param \StructType\From $from
     * @return \StructType\MessageHeader
     */
    public function setFrom(\StructType\From $from = null)
    {
        $this->From = $from;
        return $this;
    }
    /**
     * Get To value
     * @return \StructType\To|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param \StructType\To $to
     * @return \StructType\MessageHeader
     */
    public function setTo(\StructType\To $to = null)
    {
        $this->To = $to;
        return $this;
    }
    /**
     * Get CPAId value
     * @return string|null
     */
    public function getCPAId()
    {
        return $this->CPAId;
    }
    /**
     * Set CPAId value
     * @param string $cPAId
     * @return \StructType\MessageHeader
     */
    public function setCPAId($cPAId = null)
    {
        // validation for constraint: string
        if (!is_null($cPAId) && !is_string($cPAId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cPAId, true), gettype($cPAId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($cPAId) && mb_strlen($cPAId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($cPAId)), __LINE__);
        }
        $this->CPAId = $cPAId;
        return $this;
    }
    /**
     * Get ConversationId value
     * @return string|null
     */
    public function getConversationId()
    {
        return $this->ConversationId;
    }
    /**
     * Set ConversationId value
     * @param string $conversationId
     * @return \StructType\MessageHeader
     */
    public function setConversationId($conversationId = null)
    {
        // validation for constraint: string
        if (!is_null($conversationId) && !is_string($conversationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conversationId, true), gettype($conversationId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($conversationId) && mb_strlen($conversationId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($conversationId)), __LINE__);
        }
        $this->ConversationId = $conversationId;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\Service|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \StructType\Service $service
     * @return \StructType\MessageHeader
     */
    public function setService(\StructType\Service $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param string $action
     * @return \StructType\MessageHeader
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($action) && mb_strlen($action) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($action)), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get MessageData value
     * @return \StructType\MessageData|null
     */
    public function getMessageData()
    {
        return $this->MessageData;
    }
    /**
     * Set MessageData value
     * @param \StructType\MessageData $messageData
     * @return \StructType\MessageHeader
     */
    public function setMessageData(\StructType\MessageData $messageData = null)
    {
        $this->MessageData = $messageData;
        return $this;
    }
    /**
     * Get DuplicateElimination value
     * @return mixed|null
     */
    public function getDuplicateElimination()
    {
        return $this->DuplicateElimination;
    }
    /**
     * Set DuplicateElimination value
     * @param mixed $duplicateElimination
     * @return \StructType\MessageHeader
     */
    public function setDuplicateElimination($duplicateElimination = null)
    {
        $this->DuplicateElimination = $duplicateElimination;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Description[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $messageHeaderDescriptionItem) {
            // validation for constraint: itemType
            if (!$messageHeaderDescriptionItem instanceof \StructType\Description) {
                $invalidValues[] = is_object($messageHeaderDescriptionItem) ? get_class($messageHeaderDescriptionItem) : sprintf('%s(%s)', gettype($messageHeaderDescriptionItem), var_export($messageHeaderDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\Description, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\Description[] $description
     * @return \StructType\MessageHeader
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\Description $item
     * @return \StructType\MessageHeader
     */
    public function addToDescription(\StructType\Description $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Description) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\Description, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\MessageHeader
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\MessageHeader
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\MessageHeader
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($version) && mb_strlen($version) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
