<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyMembershipDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Customer Loyalty detail
 * @subpackage Structs
 */
class LoyaltyMembershipDetailType extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var string[]
     */
    public $EmailAddress;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 7
     * - minOccurs: 0
     * @var \StructType\PhoneType[]
     */
    public $PhoneNumber;
    /**
     * The MemberLoggedInInd
     * @var string
     */
    public $MemberLoggedInInd;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Membership Identifcation Number
     * @var string
     */
    public $ID;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Membership status e.g. ACTIVE
     * @var string
     */
    public $Status;
    /**
     * The Level
     * Meta information extracted from the WSDL
     * - documentation: Membership levels e.g. GOLD/PLATINUM
     * @var string
     */
    public $Level;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - documentation: Membership Issue Date in UTC format; YYYY-MM-DD e.g. 2018-12-07
     * @var string
     */
    public $IssueDate;
    /**
     * The LoyaltyOalCode
     * Meta information extracted from the WSDL
     * - documentation: Loyalty code for other airlines
     * @var string
     */
    public $LoyaltyOalCode;
    /**
     * The CurrentBalance
     * Meta information extracted from the WSDL
     * - documentation: Royalty reward balance
     * @var string
     */
    public $CurrentBalance;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Title;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $FirstName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $MiddleName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $LastName;
    /**
     * Constructor method for LoyaltyMembershipDetailType
     * @uses LoyaltyMembershipDetailType::setAddress()
     * @uses LoyaltyMembershipDetailType::setEmailAddress()
     * @uses LoyaltyMembershipDetailType::setPhoneNumber()
     * @uses LoyaltyMembershipDetailType::setMemberLoggedInInd()
     * @uses LoyaltyMembershipDetailType::setID()
     * @uses LoyaltyMembershipDetailType::setStatus()
     * @uses LoyaltyMembershipDetailType::setLevel()
     * @uses LoyaltyMembershipDetailType::setIssueDate()
     * @uses LoyaltyMembershipDetailType::setLoyaltyOalCode()
     * @uses LoyaltyMembershipDetailType::setCurrentBalance()
     * @uses LoyaltyMembershipDetailType::setName()
     * @uses LoyaltyMembershipDetailType::setTitle()
     * @uses LoyaltyMembershipDetailType::setFirstName()
     * @uses LoyaltyMembershipDetailType::setMiddleName()
     * @uses LoyaltyMembershipDetailType::setLastName()
     * @param \StructType\AddressType $address
     * @param string[] $emailAddress
     * @param \StructType\PhoneType[] $phoneNumber
     * @param string $memberLoggedInInd
     * @param string $iD
     * @param string $status
     * @param string $level
     * @param string $issueDate
     * @param string $loyaltyOalCode
     * @param string $currentBalance
     * @param string $name
     * @param string $title
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     */
    public function __construct(\StructType\AddressType $address = null, array $emailAddress = array(), array $phoneNumber = array(), $memberLoggedInInd = null, $iD = null, $status = null, $level = null, $issueDate = null, $loyaltyOalCode = null, $currentBalance = null, $name = null, $title = null, $firstName = null, $middleName = null, $lastName = null)
    {
        $this
            ->setAddress($address)
            ->setEmailAddress($emailAddress)
            ->setPhoneNumber($phoneNumber)
            ->setMemberLoggedInInd($memberLoggedInInd)
            ->setID($iD)
            ->setStatus($status)
            ->setLevel($level)
            ->setIssueDate($issueDate)
            ->setLoyaltyOalCode($loyaltyOalCode)
            ->setCurrentBalance($currentBalance)
            ->setName($name)
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName);
    }
    /**
     * Get Address value
     * @return \StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string[]|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * This method is responsible for validating the values passed to the setEmailAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmailAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailAddressForArrayConstraintsFromSetEmailAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $loyaltyMembershipDetailTypeEmailAddressItem) {
            // validation for constraint: itemType
            if (!is_string($loyaltyMembershipDetailTypeEmailAddressItem)) {
                $invalidValues[] = is_object($loyaltyMembershipDetailTypeEmailAddressItem) ? get_class($loyaltyMembershipDetailTypeEmailAddressItem) : sprintf('%s(%s)', gettype($loyaltyMembershipDetailTypeEmailAddressItem), var_export($loyaltyMembershipDetailTypeEmailAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmailAddress property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmailAddress value
     * @throws \InvalidArgumentException
     * @param string[] $emailAddress
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function setEmailAddress(array $emailAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($emailAddressArrayErrorMessage = self::validateEmailAddressForArrayConstraintsFromSetEmailAddress($emailAddress))) {
            throw new \InvalidArgumentException($emailAddressArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($emailAddress) && count($emailAddress) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Add item to EmailAddress value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function addToEmailAddress($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The EmailAddress property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->EmailAddress) && count($this->EmailAddress) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->EmailAddress)), __LINE__);
        }
        $this->EmailAddress[] = $item;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return \StructType\PhoneType[]|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setPhoneNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhoneNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhoneNumberForArrayConstraintsFromSetPhoneNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $loyaltyMembershipDetailTypePhoneNumberItem) {
            // validation for constraint: itemType
            if (!$loyaltyMembershipDetailTypePhoneNumberItem instanceof \StructType\PhoneType) {
                $invalidValues[] = is_object($loyaltyMembershipDetailTypePhoneNumberItem) ? get_class($loyaltyMembershipDetailTypePhoneNumberItem) : sprintf('%s(%s)', gettype($loyaltyMembershipDetailTypePhoneNumberItem), var_export($loyaltyMembershipDetailTypePhoneNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PhoneNumber property can only contain items of type \StructType\PhoneType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhoneNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneType[] $phoneNumber
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function setPhoneNumber(array $phoneNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($phoneNumberArrayErrorMessage = self::validatePhoneNumberForArrayConstraintsFromSetPhoneNumber($phoneNumber))) {
            throw new \InvalidArgumentException($phoneNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(7)
        if (is_array($phoneNumber) && count($phoneNumber) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 7', count($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Add item to PhoneNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneType $item
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function addToPhoneNumber(\StructType\PhoneType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhoneType) {
            throw new \InvalidArgumentException(sprintf('The PhoneNumber property can only contain items of type \StructType\PhoneType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(7)
        if (is_array($this->PhoneNumber) && count($this->PhoneNumber) >= 7) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 7', count($this->PhoneNumber)), __LINE__);
        }
        $this->PhoneNumber[] = $item;
        return $this;
    }
    /**
     * Get MemberLoggedInInd value
     * @return string|null
     */
    public function getMemberLoggedInInd()
    {
        return $this->MemberLoggedInInd;
    }
    /**
     * Set MemberLoggedInInd value
     * @param string $memberLoggedInInd
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function setMemberLoggedInInd($memberLoggedInInd = null)
    {
        // validation for constraint: string
        if (!is_null($memberLoggedInInd) && !is_string($memberLoggedInInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberLoggedInInd, true), gettype($memberLoggedInInd)), __LINE__);
        }
        $this->MemberLoggedInInd = $memberLoggedInInd;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Level value
     * @return string|null
     */
    public function getLevel()
    {
        return $this->Level;
    }
    /**
     * Set Level value
     * @param string $level
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function setLevel($level = null)
    {
        // validation for constraint: string
        if (!is_null($level) && !is_string($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($level, true), gettype($level)), __LINE__);
        }
        $this->Level = $level;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get LoyaltyOalCode value
     * @return string|null
     */
    public function getLoyaltyOalCode()
    {
        return $this->LoyaltyOalCode;
    }
    /**
     * Set LoyaltyOalCode value
     * @param string $loyaltyOalCode
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function setLoyaltyOalCode($loyaltyOalCode = null)
    {
        // validation for constraint: string
        if (!is_null($loyaltyOalCode) && !is_string($loyaltyOalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyaltyOalCode, true), gettype($loyaltyOalCode)), __LINE__);
        }
        $this->LoyaltyOalCode = $loyaltyOalCode;
        return $this;
    }
    /**
     * Get CurrentBalance value
     * @return string|null
     */
    public function getCurrentBalance()
    {
        return $this->CurrentBalance;
    }
    /**
     * Set CurrentBalance value
     * @param string $currentBalance
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function setCurrentBalance($currentBalance = null)
    {
        // validation for constraint: string
        if (!is_null($currentBalance) && !is_string($currentBalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentBalance, true), gettype($currentBalance)), __LINE__);
        }
        $this->CurrentBalance = $currentBalance;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\LoyaltyMembershipDetailType
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
}
