<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HttpHeaders StructType
 * @subpackage Structs
 */
class HttpHeaders extends AbstractStructBase
{
    /**
     * The HttpHeader
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\HttpHeader[]
     */
    public $HttpHeader;
    /**
     * Constructor method for HttpHeaders
     * @uses HttpHeaders::setHttpHeader()
     * @param \StructType\HttpHeader[] $httpHeader
     */
    public function __construct(array $httpHeader = array())
    {
        $this
            ->setHttpHeader($httpHeader);
    }
    /**
     * Get HttpHeader value
     * @return \StructType\HttpHeader[]|null
     */
    public function getHttpHeader()
    {
        return $this->HttpHeader;
    }
    /**
     * This method is responsible for validating the values passed to the setHttpHeader method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHttpHeader method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHttpHeaderForArrayConstraintsFromSetHttpHeader(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $httpHeadersHttpHeaderItem) {
            // validation for constraint: itemType
            if (!$httpHeadersHttpHeaderItem instanceof \StructType\HttpHeader) {
                $invalidValues[] = is_object($httpHeadersHttpHeaderItem) ? get_class($httpHeadersHttpHeaderItem) : sprintf('%s(%s)', gettype($httpHeadersHttpHeaderItem), var_export($httpHeadersHttpHeaderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HttpHeader property can only contain items of type \StructType\HttpHeader, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HttpHeader value
     * @throws \InvalidArgumentException
     * @param \StructType\HttpHeader[] $httpHeader
     * @return \StructType\HttpHeaders
     */
    public function setHttpHeader(array $httpHeader = array())
    {
        // validation for constraint: array
        if ('' !== ($httpHeaderArrayErrorMessage = self::validateHttpHeaderForArrayConstraintsFromSetHttpHeader($httpHeader))) {
            throw new \InvalidArgumentException($httpHeaderArrayErrorMessage, __LINE__);
        }
        $this->HttpHeader = $httpHeader;
        return $this;
    }
    /**
     * Add item to HttpHeader value
     * @throws \InvalidArgumentException
     * @param \StructType\HttpHeader $item
     * @return \StructType\HttpHeaders
     */
    public function addToHttpHeader(\StructType\HttpHeader $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HttpHeader) {
            throw new \InvalidArgumentException(sprintf('The HttpHeader property can only contain items of type \StructType\HttpHeader, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HttpHeader[] = $item;
        return $this;
    }
}
