<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FraudScreenResultType StructType
 * @subpackage Structs
 */
class FraudScreenResultType extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - documentation: Either "ACCEPT", "REJECT", "REVIEW" or "ERROR"
     * - use: required
     * @var string
     */
    public $Result;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RemarksType
     */
    public $Remarks;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - documentation: As returned by supplier.
     * - use: optional
     * @var string
     */
    public $ReasonCode;
    /**
     * The Score
     * Meta information extracted from the WSDL
     * - documentation: As returned by supplier.
     * - use: optional
     * @var string
     */
    public $Score;
    /**
     * The SupplierTransID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierTransID;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - documentation: Provider of fraud management (e.g. Accertify, CyberSource)
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * The PreviouslyProcessedRqst
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $PreviouslyProcessedRqst;
    /**
     * The PresentCreditCardInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the verification will be performed on any of credit cards that match on a ticket purchased.
     * - use: optional
     * @var bool
     */
    public $PresentCreditCardInd;
    /**
     * Constructor method for FraudScreenResultType
     * @uses FraudScreenResultType::setResult()
     * @uses FraudScreenResultType::setRemarks()
     * @uses FraudScreenResultType::setReasonCode()
     * @uses FraudScreenResultType::setScore()
     * @uses FraudScreenResultType::setSupplierTransID()
     * @uses FraudScreenResultType::setSupplierID()
     * @uses FraudScreenResultType::setPreviouslyProcessedRqst()
     * @uses FraudScreenResultType::setPresentCreditCardInd()
     * @param string $result
     * @param \StructType\RemarksType $remarks
     * @param string $reasonCode
     * @param string $score
     * @param string $supplierTransID
     * @param string $supplierID
     * @param bool $previouslyProcessedRqst
     * @param bool $presentCreditCardInd
     */
    public function __construct($result = null, \StructType\RemarksType $remarks = null, $reasonCode = null, $score = null, $supplierTransID = null, $supplierID = null, $previouslyProcessedRqst = null, $presentCreditCardInd = null)
    {
        $this
            ->setResult($result)
            ->setRemarks($remarks)
            ->setReasonCode($reasonCode)
            ->setScore($score)
            ->setSupplierTransID($supplierTransID)
            ->setSupplierID($supplierID)
            ->setPreviouslyProcessedRqst($previouslyProcessedRqst)
            ->setPresentCreditCardInd($presentCreditCardInd);
    }
    /**
     * Get Result value
     * @return string
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param string $result
     * @return \StructType\FraudScreenResultType
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get Remarks value
     * @return \StructType\RemarksType|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param \StructType\RemarksType $remarks
     * @return \StructType\FraudScreenResultType
     */
    public function setRemarks(\StructType\RemarksType $remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param string $reasonCode
     * @return \StructType\FraudScreenResultType
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get Score value
     * @return string|null
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param string $score
     * @return \StructType\FraudScreenResultType
     */
    public function setScore($score = null)
    {
        // validation for constraint: string
        if (!is_null($score) && !is_string($score)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($score, true), gettype($score)), __LINE__);
        }
        $this->Score = $score;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \StructType\FraudScreenResultType
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransID) && !is_string($supplierTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransID, true), gettype($supplierTransID)), __LINE__);
        }
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \StructType\FraudScreenResultType
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get PreviouslyProcessedRqst value
     * @return bool|null
     */
    public function getPreviouslyProcessedRqst()
    {
        return $this->PreviouslyProcessedRqst;
    }
    /**
     * Set PreviouslyProcessedRqst value
     * @param bool $previouslyProcessedRqst
     * @return \StructType\FraudScreenResultType
     */
    public function setPreviouslyProcessedRqst($previouslyProcessedRqst = null)
    {
        // validation for constraint: boolean
        if (!is_null($previouslyProcessedRqst) && !is_bool($previouslyProcessedRqst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($previouslyProcessedRqst, true), gettype($previouslyProcessedRqst)), __LINE__);
        }
        $this->PreviouslyProcessedRqst = $previouslyProcessedRqst;
        return $this;
    }
    /**
     * Get PresentCreditCardInd value
     * @return bool|null
     */
    public function getPresentCreditCardInd()
    {
        return $this->PresentCreditCardInd;
    }
    /**
     * Set PresentCreditCardInd value
     * @param bool $presentCreditCardInd
     * @return \StructType\FraudScreenResultType
     */
    public function setPresentCreditCardInd($presentCreditCardInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($presentCreditCardInd) && !is_bool($presentCreditCardInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($presentCreditCardInd, true), gettype($presentCreditCardInd)), __LINE__);
        }
        $this->PresentCreditCardInd = $presentCreditCardInd;
        return $this;
    }
}
