<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepartureInfo StructType
 * @subpackage Structs
 */
class DepartureInfo extends AbstractStructBase
{
    /**
     * The DepartureAirport
     * Meta information extracted from the WSDL
     * - documentation: 3-alpha IATA airport city code.
     * - use: required
     * @var string
     */
    public $DepartureAirport;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The CurrentLocalDateTime
     * Meta information extracted from the WSDL
     * - documentation: Current local date/time of the departure city.
     * - use: optional
     * @var string
     */
    public $CurrentLocalDateTime;
    /**
     * Constructor method for DepartureInfo
     * @uses DepartureInfo::setDepartureAirport()
     * @uses DepartureInfo::setDepartureDateTime()
     * @uses DepartureInfo::setCurrentLocalDateTime()
     * @param string $departureAirport
     * @param string $departureDateTime
     * @param string $currentLocalDateTime
     */
    public function __construct($departureAirport = null, $departureDateTime = null, $currentLocalDateTime = null)
    {
        $this
            ->setDepartureAirport($departureAirport)
            ->setDepartureDateTime($departureDateTime)
            ->setCurrentLocalDateTime($currentLocalDateTime);
    }
    /**
     * Get DepartureAirport value
     * @return string
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param string $departureAirport
     * @return \StructType\DepartureInfo
     */
    public function setDepartureAirport($departureAirport = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirport) && !is_string($departureAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirport, true), gettype($departureAirport)), __LINE__);
        }
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \StructType\DepartureInfo
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateTime, true), gettype($departureDateTime)), __LINE__);
        }
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get CurrentLocalDateTime value
     * @return string|null
     */
    public function getCurrentLocalDateTime()
    {
        return $this->CurrentLocalDateTime;
    }
    /**
     * Set CurrentLocalDateTime value
     * @param string $currentLocalDateTime
     * @return \StructType\DepartureInfo
     */
    public function setCurrentLocalDateTime($currentLocalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($currentLocalDateTime) && !is_string($currentLocalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentLocalDateTime, true), gettype($currentLocalDateTime)), __LINE__);
        }
        $this->CurrentLocalDateTime = $currentLocalDateTime;
        return $this;
    }
}
