<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DCCType StructType
 * Meta information extracted from the WSDL
 * - documentation: Dynamic Currency Conversion
 * @subpackage Structs
 */
class DCCType extends AbstractStructBase
{
    /**
     * The DCC_TransID
     * Meta information extracted from the WSDL
     * - documentation: SabreTransactionID as returned in DCC response
     * - use: required
     * @var string
     */
    public $DCC_TransID;
    /**
     * The OptedIn
     * Meta information extracted from the WSDL
     * - documentation: "true" if cardholder opted to pay in card currency.
     * - use: optional
     * @var bool
     */
    public $OptedIn;
    /**
     * Constructor method for DCCType
     * @uses DCCType::setDCC_TransID()
     * @uses DCCType::setOptedIn()
     * @param string $dCC_TransID
     * @param bool $optedIn
     */
    public function __construct($dCC_TransID = null, $optedIn = null)
    {
        $this
            ->setDCC_TransID($dCC_TransID)
            ->setOptedIn($optedIn);
    }
    /**
     * Get DCC_TransID value
     * @return string
     */
    public function getDCC_TransID()
    {
        return $this->DCC_TransID;
    }
    /**
     * Set DCC_TransID value
     * @param string $dCC_TransID
     * @return \StructType\DCCType
     */
    public function setDCC_TransID($dCC_TransID = null)
    {
        // validation for constraint: string
        if (!is_null($dCC_TransID) && !is_string($dCC_TransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dCC_TransID, true), gettype($dCC_TransID)), __LINE__);
        }
        $this->DCC_TransID = $dCC_TransID;
        return $this;
    }
    /**
     * Get OptedIn value
     * @return bool|null
     */
    public function getOptedIn()
    {
        return $this->OptedIn;
    }
    /**
     * Set OptedIn value
     * @param bool $optedIn
     * @return \StructType\DCCType
     */
    public function setOptedIn($optedIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($optedIn) && !is_bool($optedIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optedIn, true), gettype($optedIn)), __LINE__);
        }
        $this->OptedIn = $optedIn;
        return $this;
    }
}
