<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerDetail StructType
 * @subpackage Structs
 */
class CustomerDetail extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\PhoneType[]
     */
    public $PhoneNumber;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PersonID_Type
     */
    public $CustomerID;
    /**
     * The LoyaltyMemberDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LoyaltyMembershipDetailType
     */
    public $LoyaltyMemberDetail;
    /**
     * The DOB
     * Meta information extracted from the WSDL
     * - documentation: 1980-07-31
     * - use: optional
     * @var string
     */
    public $DOB;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - documentation: M/F
     * - use: optional
     * @var string
     */
    public $Gender;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: N - New E - Existing
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Title;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $FirstName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $MiddleName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $LastName;
    /**
     * Constructor method for CustomerDetail
     * @uses CustomerDetail::setAddress()
     * @uses CustomerDetail::setEmailAddress()
     * @uses CustomerDetail::setPhoneNumber()
     * @uses CustomerDetail::setCustomerID()
     * @uses CustomerDetail::setLoyaltyMemberDetail()
     * @uses CustomerDetail::setDOB()
     * @uses CustomerDetail::setGender()
     * @uses CustomerDetail::setType()
     * @uses CustomerDetail::setName()
     * @uses CustomerDetail::setTitle()
     * @uses CustomerDetail::setFirstName()
     * @uses CustomerDetail::setMiddleName()
     * @uses CustomerDetail::setLastName()
     * @param \StructType\AddressType $address
     * @param string $emailAddress
     * @param \StructType\PhoneType[] $phoneNumber
     * @param \StructType\PersonID_Type $customerID
     * @param \StructType\LoyaltyMembershipDetailType $loyaltyMemberDetail
     * @param string $dOB
     * @param string $gender
     * @param string $type
     * @param string $name
     * @param string $title
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     */
    public function __construct(\StructType\AddressType $address = null, $emailAddress = null, array $phoneNumber = array(), \StructType\PersonID_Type $customerID = null, \StructType\LoyaltyMembershipDetailType $loyaltyMemberDetail = null, $dOB = null, $gender = null, $type = null, $name = null, $title = null, $firstName = null, $middleName = null, $lastName = null)
    {
        $this
            ->setAddress($address)
            ->setEmailAddress($emailAddress)
            ->setPhoneNumber($phoneNumber)
            ->setCustomerID($customerID)
            ->setLoyaltyMemberDetail($loyaltyMemberDetail)
            ->setDOB($dOB)
            ->setGender($gender)
            ->setType($type)
            ->setName($name)
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName);
    }
    /**
     * Get Address value
     * @return \StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\CustomerDetail
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\CustomerDetail
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return \StructType\PhoneType[]|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setPhoneNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhoneNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhoneNumberForArrayConstraintsFromSetPhoneNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerDetailPhoneNumberItem) {
            // validation for constraint: itemType
            if (!$customerDetailPhoneNumberItem instanceof \StructType\PhoneType) {
                $invalidValues[] = is_object($customerDetailPhoneNumberItem) ? get_class($customerDetailPhoneNumberItem) : sprintf('%s(%s)', gettype($customerDetailPhoneNumberItem), var_export($customerDetailPhoneNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PhoneNumber property can only contain items of type \StructType\PhoneType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhoneNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneType[] $phoneNumber
     * @return \StructType\CustomerDetail
     */
    public function setPhoneNumber(array $phoneNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($phoneNumberArrayErrorMessage = self::validatePhoneNumberForArrayConstraintsFromSetPhoneNumber($phoneNumber))) {
            throw new \InvalidArgumentException($phoneNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($phoneNumber) && count($phoneNumber) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Add item to PhoneNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneType $item
     * @return \StructType\CustomerDetail
     */
    public function addToPhoneNumber(\StructType\PhoneType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhoneType) {
            throw new \InvalidArgumentException(sprintf('The PhoneNumber property can only contain items of type \StructType\PhoneType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->PhoneNumber) && count($this->PhoneNumber) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->PhoneNumber)), __LINE__);
        }
        $this->PhoneNumber[] = $item;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return \StructType\PersonID_Type|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param \StructType\PersonID_Type $customerID
     * @return \StructType\CustomerDetail
     */
    public function setCustomerID(\StructType\PersonID_Type $customerID = null)
    {
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get LoyaltyMemberDetail value
     * @return \StructType\LoyaltyMembershipDetailType|null
     */
    public function getLoyaltyMemberDetail()
    {
        return $this->LoyaltyMemberDetail;
    }
    /**
     * Set LoyaltyMemberDetail value
     * @param \StructType\LoyaltyMembershipDetailType $loyaltyMemberDetail
     * @return \StructType\CustomerDetail
     */
    public function setLoyaltyMemberDetail(\StructType\LoyaltyMembershipDetailType $loyaltyMemberDetail = null)
    {
        $this->LoyaltyMemberDetail = $loyaltyMemberDetail;
        return $this;
    }
    /**
     * Get DOB value
     * @return string|null
     */
    public function getDOB()
    {
        return $this->DOB;
    }
    /**
     * Set DOB value
     * @param string $dOB
     * @return \StructType\CustomerDetail
     */
    public function setDOB($dOB = null)
    {
        // validation for constraint: string
        if (!is_null($dOB) && !is_string($dOB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dOB, true), gettype($dOB)), __LINE__);
        }
        $this->DOB = $dOB;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \StructType\CustomerDetail
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\CustomerDetail
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CustomerDetail
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\CustomerDetail
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\CustomerDetail
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\CustomerDetail
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\CustomerDetail
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
}
