<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardReaderResult StructType
 * @subpackage Structs
 */
class CardReaderResult extends AbstractStructBase
{
    /**
     * The Tokens
     * Meta information extracted from the WSDL
     * - documentation: As returned by supplier.
     * - minOccurs: 0
     * @var \StructType\TokensType
     */
    public $Tokens;
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ResultCode;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Remarks;
    /**
     * Constructor method for CardReaderResult
     * @uses CardReaderResult::setTokens()
     * @uses CardReaderResult::setResultCode()
     * @uses CardReaderResult::setRemarks()
     * @param \StructType\TokensType $tokens
     * @param string $resultCode
     * @param string $remarks
     */
    public function __construct(\StructType\TokensType $tokens = null, $resultCode = null, $remarks = null)
    {
        $this
            ->setTokens($tokens)
            ->setResultCode($resultCode)
            ->setRemarks($remarks);
    }
    /**
     * Get Tokens value
     * @return \StructType\TokensType|null
     */
    public function getTokens()
    {
        return $this->Tokens;
    }
    /**
     * Set Tokens value
     * @param \StructType\TokensType $tokens
     * @return \StructType\CardReaderResult
     */
    public function setTokens(\StructType\TokensType $tokens = null)
    {
        $this->Tokens = $tokens;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \StructType\CardReaderResult
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \StructType\CardReaderResult
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarks, true), gettype($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
}
