<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardActivityType StructType
 * @subpackage Structs
 */
class CardActivityType extends AbstractStructBase
{
    /**
     * The MerchantDetail
     * Meta information extracted from the WSDL
     * - documentation: Merchant who will bill the virtual card
     * - minOccurs: 0
     * @var \StructType\MerchantDetailType
     */
    public $MerchantDetail;
    /**
     * The AmountDetail
     * Meta information extracted from the WSDL
     * - documentation: Payment amount is assigned to the virtual card
     * - minOccurs: 0
     * @var \StructType\CurrencyAmountType
     */
    public $AmountDetail;
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - documentation: Card activity result e.g. Authorise
     * - use: optional
     * @var string
     */
    public $ResultCode;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Type of activity performed against the card e.g. Authorisation
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The TransactionDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date and time of the card activity. Time is related to the time-zone of the Card Issuers processor
     * - use: optional
     * @var string
     */
    public $TransactionDateTime;
    /**
     * The CardIssuerDescription
     * Meta information extracted from the WSDL
     * - documentation: Information provided by the Card Issuer
     * - use: optional
     * @var string
     */
    public $CardIssuerDescription;
    /**
     * Constructor method for CardActivityType
     * @uses CardActivityType::setMerchantDetail()
     * @uses CardActivityType::setAmountDetail()
     * @uses CardActivityType::setResultCode()
     * @uses CardActivityType::setType()
     * @uses CardActivityType::setTransactionDateTime()
     * @uses CardActivityType::setCardIssuerDescription()
     * @param \StructType\MerchantDetailType $merchantDetail
     * @param \StructType\CurrencyAmountType $amountDetail
     * @param string $resultCode
     * @param string $type
     * @param string $transactionDateTime
     * @param string $cardIssuerDescription
     */
    public function __construct(\StructType\MerchantDetailType $merchantDetail = null, \StructType\CurrencyAmountType $amountDetail = null, $resultCode = null, $type = null, $transactionDateTime = null, $cardIssuerDescription = null)
    {
        $this
            ->setMerchantDetail($merchantDetail)
            ->setAmountDetail($amountDetail)
            ->setResultCode($resultCode)
            ->setType($type)
            ->setTransactionDateTime($transactionDateTime)
            ->setCardIssuerDescription($cardIssuerDescription);
    }
    /**
     * Get MerchantDetail value
     * @return \StructType\MerchantDetailType|null
     */
    public function getMerchantDetail()
    {
        return $this->MerchantDetail;
    }
    /**
     * Set MerchantDetail value
     * @param \StructType\MerchantDetailType $merchantDetail
     * @return \StructType\CardActivityType
     */
    public function setMerchantDetail(\StructType\MerchantDetailType $merchantDetail = null)
    {
        $this->MerchantDetail = $merchantDetail;
        return $this;
    }
    /**
     * Get AmountDetail value
     * @return \StructType\CurrencyAmountType|null
     */
    public function getAmountDetail()
    {
        return $this->AmountDetail;
    }
    /**
     * Set AmountDetail value
     * @param \StructType\CurrencyAmountType $amountDetail
     * @return \StructType\CardActivityType
     */
    public function setAmountDetail(\StructType\CurrencyAmountType $amountDetail = null)
    {
        $this->AmountDetail = $amountDetail;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \StructType\CardActivityType
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\CardActivityType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get TransactionDateTime value
     * @return string|null
     */
    public function getTransactionDateTime()
    {
        return $this->TransactionDateTime;
    }
    /**
     * Set TransactionDateTime value
     * @param string $transactionDateTime
     * @return \StructType\CardActivityType
     */
    public function setTransactionDateTime($transactionDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateTime) && !is_string($transactionDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDateTime, true), gettype($transactionDateTime)), __LINE__);
        }
        $this->TransactionDateTime = $transactionDateTime;
        return $this;
    }
    /**
     * Get CardIssuerDescription value
     * @return string|null
     */
    public function getCardIssuerDescription()
    {
        return $this->CardIssuerDescription;
    }
    /**
     * Set CardIssuerDescription value
     * @param string $cardIssuerDescription
     * @return \StructType\CardActivityType
     */
    public function setCardIssuerDescription($cardIssuerDescription = null)
    {
        // validation for constraint: string
        if (!is_null($cardIssuerDescription) && !is_string($cardIssuerDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardIssuerDescription, true), gettype($cardIssuerDescription)), __LINE__);
        }
        $this->CardIssuerDescription = $cardIssuerDescription;
        return $this;
    }
}
