<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BrowserDetail StructType
 * @subpackage Structs
 */
class BrowserDetail extends AbstractStructBase
{
    /**
     * The HttpHeaders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HttpHeaders
     */
    public $HttpHeaders;
    /**
     * The BrowserSessionID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrowserSessionID;
    /**
     * The BrowserHostName
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrowserHostName;
    /**
     * The BrowserAccept
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrowserAccept;
    /**
     * The BrowserAcceptEncoding
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrowserAcceptEncoding;
    /**
     * The BrowserAcceptCharset
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrowserAcceptCharset;
    /**
     * The BrowserID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrowserID;
    /**
     * The BrowserLanguageCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrowserLanguageCode;
    /**
     * The BrowserCookie
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrowserCookie;
    /**
     * The BrowserConnectionType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrowserConnectionType;
    /**
     * The BrowserReferer
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrowserReferer;
    /**
     * The BrowserJavaEnabled
     * Meta information extracted from the WSDL
     * - documentation: Indicates the ability of the cardholder browser to execute Java
     * - use: optional
     * @var bool
     */
    public $BrowserJavaEnabled;
    /**
     * The BrowserJavascriptEnabled
     * Meta information extracted from the WSDL
     * - documentation: Indicates the ability of the cardholder browser to execute JavaScript
     * - use: optional
     * @var bool
     */
    public $BrowserJavascriptEnabled;
    /**
     * The BrowserScreenColorDepth
     * Meta information extracted from the WSDL
     * - documentation: Value representing the bit depth of the colour palette for displaying images, in bits per pixel
     * - use: optional
     * @var int
     */
    public $BrowserScreenColorDepth;
    /**
     * The BrowserScreenHeight
     * Meta information extracted from the WSDL
     * - documentation: Total height of the Cardholder's screen in pixels
     * - use: optional
     * @var int
     */
    public $BrowserScreenHeight;
    /**
     * The BrowserScreenWidth
     * Meta information extracted from the WSDL
     * - documentation: Total width of the Cardholder's screen in pixels
     * - use: optional
     * @var int
     */
    public $BrowserScreenWidth;
    /**
     * The BrowserTimeZoneOffset
     * Meta information extracted from the WSDL
     * - documentation: Time difference between UTC time and the Cardholder browser local time, in minutes
     * - use: optional
     * @var int
     */
    public $BrowserTimeZoneOffset;
    /**
     * The ChallengeWindowSize
     * Meta information extracted from the WSDL
     * - documentation: Dimensions of the challenge window that has been displayed to the Cardholder. ChallengeWindowSize 01 = 250 x 400, 02 = 390 x 400, 03 = 500 x 600, 04 = 600 x 400, 05 = Full screen
     * - use: optional
     * @var int
     */
    public $ChallengeWindowSize;
    /**
     * Constructor method for BrowserDetail
     * @uses BrowserDetail::setHttpHeaders()
     * @uses BrowserDetail::setBrowserSessionID()
     * @uses BrowserDetail::setBrowserHostName()
     * @uses BrowserDetail::setBrowserAccept()
     * @uses BrowserDetail::setBrowserAcceptEncoding()
     * @uses BrowserDetail::setBrowserAcceptCharset()
     * @uses BrowserDetail::setBrowserID()
     * @uses BrowserDetail::setBrowserLanguageCode()
     * @uses BrowserDetail::setBrowserCookie()
     * @uses BrowserDetail::setBrowserConnectionType()
     * @uses BrowserDetail::setBrowserReferer()
     * @uses BrowserDetail::setBrowserJavaEnabled()
     * @uses BrowserDetail::setBrowserJavascriptEnabled()
     * @uses BrowserDetail::setBrowserScreenColorDepth()
     * @uses BrowserDetail::setBrowserScreenHeight()
     * @uses BrowserDetail::setBrowserScreenWidth()
     * @uses BrowserDetail::setBrowserTimeZoneOffset()
     * @uses BrowserDetail::setChallengeWindowSize()
     * @param \StructType\HttpHeaders $httpHeaders
     * @param string $browserSessionID
     * @param string $browserHostName
     * @param string $browserAccept
     * @param string $browserAcceptEncoding
     * @param string $browserAcceptCharset
     * @param string $browserID
     * @param string $browserLanguageCode
     * @param string $browserCookie
     * @param string $browserConnectionType
     * @param string $browserReferer
     * @param bool $browserJavaEnabled
     * @param bool $browserJavascriptEnabled
     * @param int $browserScreenColorDepth
     * @param int $browserScreenHeight
     * @param int $browserScreenWidth
     * @param int $browserTimeZoneOffset
     * @param int $challengeWindowSize
     */
    public function __construct(\StructType\HttpHeaders $httpHeaders = null, $browserSessionID = null, $browserHostName = null, $browserAccept = null, $browserAcceptEncoding = null, $browserAcceptCharset = null, $browserID = null, $browserLanguageCode = null, $browserCookie = null, $browserConnectionType = null, $browserReferer = null, $browserJavaEnabled = null, $browserJavascriptEnabled = null, $browserScreenColorDepth = null, $browserScreenHeight = null, $browserScreenWidth = null, $browserTimeZoneOffset = null, $challengeWindowSize = null)
    {
        $this
            ->setHttpHeaders($httpHeaders)
            ->setBrowserSessionID($browserSessionID)
            ->setBrowserHostName($browserHostName)
            ->setBrowserAccept($browserAccept)
            ->setBrowserAcceptEncoding($browserAcceptEncoding)
            ->setBrowserAcceptCharset($browserAcceptCharset)
            ->setBrowserID($browserID)
            ->setBrowserLanguageCode($browserLanguageCode)
            ->setBrowserCookie($browserCookie)
            ->setBrowserConnectionType($browserConnectionType)
            ->setBrowserReferer($browserReferer)
            ->setBrowserJavaEnabled($browserJavaEnabled)
            ->setBrowserJavascriptEnabled($browserJavascriptEnabled)
            ->setBrowserScreenColorDepth($browserScreenColorDepth)
            ->setBrowserScreenHeight($browserScreenHeight)
            ->setBrowserScreenWidth($browserScreenWidth)
            ->setBrowserTimeZoneOffset($browserTimeZoneOffset)
            ->setChallengeWindowSize($challengeWindowSize);
    }
    /**
     * Get HttpHeaders value
     * @return \StructType\HttpHeaders|null
     */
    public function getHttpHeaders()
    {
        return $this->HttpHeaders;
    }
    /**
     * Set HttpHeaders value
     * @param \StructType\HttpHeaders $httpHeaders
     * @return \StructType\BrowserDetail
     */
    public function setHttpHeaders(\StructType\HttpHeaders $httpHeaders = null)
    {
        $this->HttpHeaders = $httpHeaders;
        return $this;
    }
    /**
     * Get BrowserSessionID value
     * @return string|null
     */
    public function getBrowserSessionID()
    {
        return $this->BrowserSessionID;
    }
    /**
     * Set BrowserSessionID value
     * @param string $browserSessionID
     * @return \StructType\BrowserDetail
     */
    public function setBrowserSessionID($browserSessionID = null)
    {
        // validation for constraint: string
        if (!is_null($browserSessionID) && !is_string($browserSessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($browserSessionID, true), gettype($browserSessionID)), __LINE__);
        }
        $this->BrowserSessionID = $browserSessionID;
        return $this;
    }
    /**
     * Get BrowserHostName value
     * @return string|null
     */
    public function getBrowserHostName()
    {
        return $this->BrowserHostName;
    }
    /**
     * Set BrowserHostName value
     * @param string $browserHostName
     * @return \StructType\BrowserDetail
     */
    public function setBrowserHostName($browserHostName = null)
    {
        // validation for constraint: string
        if (!is_null($browserHostName) && !is_string($browserHostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($browserHostName, true), gettype($browserHostName)), __LINE__);
        }
        $this->BrowserHostName = $browserHostName;
        return $this;
    }
    /**
     * Get BrowserAccept value
     * @return string|null
     */
    public function getBrowserAccept()
    {
        return $this->BrowserAccept;
    }
    /**
     * Set BrowserAccept value
     * @param string $browserAccept
     * @return \StructType\BrowserDetail
     */
    public function setBrowserAccept($browserAccept = null)
    {
        // validation for constraint: string
        if (!is_null($browserAccept) && !is_string($browserAccept)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($browserAccept, true), gettype($browserAccept)), __LINE__);
        }
        $this->BrowserAccept = $browserAccept;
        return $this;
    }
    /**
     * Get BrowserAcceptEncoding value
     * @return string|null
     */
    public function getBrowserAcceptEncoding()
    {
        return $this->BrowserAcceptEncoding;
    }
    /**
     * Set BrowserAcceptEncoding value
     * @param string $browserAcceptEncoding
     * @return \StructType\BrowserDetail
     */
    public function setBrowserAcceptEncoding($browserAcceptEncoding = null)
    {
        // validation for constraint: string
        if (!is_null($browserAcceptEncoding) && !is_string($browserAcceptEncoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($browserAcceptEncoding, true), gettype($browserAcceptEncoding)), __LINE__);
        }
        $this->BrowserAcceptEncoding = $browserAcceptEncoding;
        return $this;
    }
    /**
     * Get BrowserAcceptCharset value
     * @return string|null
     */
    public function getBrowserAcceptCharset()
    {
        return $this->BrowserAcceptCharset;
    }
    /**
     * Set BrowserAcceptCharset value
     * @param string $browserAcceptCharset
     * @return \StructType\BrowserDetail
     */
    public function setBrowserAcceptCharset($browserAcceptCharset = null)
    {
        // validation for constraint: string
        if (!is_null($browserAcceptCharset) && !is_string($browserAcceptCharset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($browserAcceptCharset, true), gettype($browserAcceptCharset)), __LINE__);
        }
        $this->BrowserAcceptCharset = $browserAcceptCharset;
        return $this;
    }
    /**
     * Get BrowserID value
     * @return string|null
     */
    public function getBrowserID()
    {
        return $this->BrowserID;
    }
    /**
     * Set BrowserID value
     * @param string $browserID
     * @return \StructType\BrowserDetail
     */
    public function setBrowserID($browserID = null)
    {
        // validation for constraint: string
        if (!is_null($browserID) && !is_string($browserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($browserID, true), gettype($browserID)), __LINE__);
        }
        $this->BrowserID = $browserID;
        return $this;
    }
    /**
     * Get BrowserLanguageCode value
     * @return string|null
     */
    public function getBrowserLanguageCode()
    {
        return $this->BrowserLanguageCode;
    }
    /**
     * Set BrowserLanguageCode value
     * @param string $browserLanguageCode
     * @return \StructType\BrowserDetail
     */
    public function setBrowserLanguageCode($browserLanguageCode = null)
    {
        // validation for constraint: string
        if (!is_null($browserLanguageCode) && !is_string($browserLanguageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($browserLanguageCode, true), gettype($browserLanguageCode)), __LINE__);
        }
        $this->BrowserLanguageCode = $browserLanguageCode;
        return $this;
    }
    /**
     * Get BrowserCookie value
     * @return string|null
     */
    public function getBrowserCookie()
    {
        return $this->BrowserCookie;
    }
    /**
     * Set BrowserCookie value
     * @param string $browserCookie
     * @return \StructType\BrowserDetail
     */
    public function setBrowserCookie($browserCookie = null)
    {
        // validation for constraint: string
        if (!is_null($browserCookie) && !is_string($browserCookie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($browserCookie, true), gettype($browserCookie)), __LINE__);
        }
        $this->BrowserCookie = $browserCookie;
        return $this;
    }
    /**
     * Get BrowserConnectionType value
     * @return string|null
     */
    public function getBrowserConnectionType()
    {
        return $this->BrowserConnectionType;
    }
    /**
     * Set BrowserConnectionType value
     * @param string $browserConnectionType
     * @return \StructType\BrowserDetail
     */
    public function setBrowserConnectionType($browserConnectionType = null)
    {
        // validation for constraint: string
        if (!is_null($browserConnectionType) && !is_string($browserConnectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($browserConnectionType, true), gettype($browserConnectionType)), __LINE__);
        }
        $this->BrowserConnectionType = $browserConnectionType;
        return $this;
    }
    /**
     * Get BrowserReferer value
     * @return string|null
     */
    public function getBrowserReferer()
    {
        return $this->BrowserReferer;
    }
    /**
     * Set BrowserReferer value
     * @param string $browserReferer
     * @return \StructType\BrowserDetail
     */
    public function setBrowserReferer($browserReferer = null)
    {
        // validation for constraint: string
        if (!is_null($browserReferer) && !is_string($browserReferer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($browserReferer, true), gettype($browserReferer)), __LINE__);
        }
        $this->BrowserReferer = $browserReferer;
        return $this;
    }
    /**
     * Get BrowserJavaEnabled value
     * @return bool|null
     */
    public function getBrowserJavaEnabled()
    {
        return $this->BrowserJavaEnabled;
    }
    /**
     * Set BrowserJavaEnabled value
     * @param bool $browserJavaEnabled
     * @return \StructType\BrowserDetail
     */
    public function setBrowserJavaEnabled($browserJavaEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($browserJavaEnabled) && !is_bool($browserJavaEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($browserJavaEnabled, true), gettype($browserJavaEnabled)), __LINE__);
        }
        $this->BrowserJavaEnabled = $browserJavaEnabled;
        return $this;
    }
    /**
     * Get BrowserJavascriptEnabled value
     * @return bool|null
     */
    public function getBrowserJavascriptEnabled()
    {
        return $this->BrowserJavascriptEnabled;
    }
    /**
     * Set BrowserJavascriptEnabled value
     * @param bool $browserJavascriptEnabled
     * @return \StructType\BrowserDetail
     */
    public function setBrowserJavascriptEnabled($browserJavascriptEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($browserJavascriptEnabled) && !is_bool($browserJavascriptEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($browserJavascriptEnabled, true), gettype($browserJavascriptEnabled)), __LINE__);
        }
        $this->BrowserJavascriptEnabled = $browserJavascriptEnabled;
        return $this;
    }
    /**
     * Get BrowserScreenColorDepth value
     * @return int|null
     */
    public function getBrowserScreenColorDepth()
    {
        return $this->BrowserScreenColorDepth;
    }
    /**
     * Set BrowserScreenColorDepth value
     * @param int $browserScreenColorDepth
     * @return \StructType\BrowserDetail
     */
    public function setBrowserScreenColorDepth($browserScreenColorDepth = null)
    {
        // validation for constraint: int
        if (!is_null($browserScreenColorDepth) && !(is_int($browserScreenColorDepth) || ctype_digit($browserScreenColorDepth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($browserScreenColorDepth, true), gettype($browserScreenColorDepth)), __LINE__);
        }
        $this->BrowserScreenColorDepth = $browserScreenColorDepth;
        return $this;
    }
    /**
     * Get BrowserScreenHeight value
     * @return int|null
     */
    public function getBrowserScreenHeight()
    {
        return $this->BrowserScreenHeight;
    }
    /**
     * Set BrowserScreenHeight value
     * @param int $browserScreenHeight
     * @return \StructType\BrowserDetail
     */
    public function setBrowserScreenHeight($browserScreenHeight = null)
    {
        // validation for constraint: int
        if (!is_null($browserScreenHeight) && !(is_int($browserScreenHeight) || ctype_digit($browserScreenHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($browserScreenHeight, true), gettype($browserScreenHeight)), __LINE__);
        }
        $this->BrowserScreenHeight = $browserScreenHeight;
        return $this;
    }
    /**
     * Get BrowserScreenWidth value
     * @return int|null
     */
    public function getBrowserScreenWidth()
    {
        return $this->BrowserScreenWidth;
    }
    /**
     * Set BrowserScreenWidth value
     * @param int $browserScreenWidth
     * @return \StructType\BrowserDetail
     */
    public function setBrowserScreenWidth($browserScreenWidth = null)
    {
        // validation for constraint: int
        if (!is_null($browserScreenWidth) && !(is_int($browserScreenWidth) || ctype_digit($browserScreenWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($browserScreenWidth, true), gettype($browserScreenWidth)), __LINE__);
        }
        $this->BrowserScreenWidth = $browserScreenWidth;
        return $this;
    }
    /**
     * Get BrowserTimeZoneOffset value
     * @return int|null
     */
    public function getBrowserTimeZoneOffset()
    {
        return $this->BrowserTimeZoneOffset;
    }
    /**
     * Set BrowserTimeZoneOffset value
     * @param int $browserTimeZoneOffset
     * @return \StructType\BrowserDetail
     */
    public function setBrowserTimeZoneOffset($browserTimeZoneOffset = null)
    {
        // validation for constraint: int
        if (!is_null($browserTimeZoneOffset) && !(is_int($browserTimeZoneOffset) || ctype_digit($browserTimeZoneOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($browserTimeZoneOffset, true), gettype($browserTimeZoneOffset)), __LINE__);
        }
        $this->BrowserTimeZoneOffset = $browserTimeZoneOffset;
        return $this;
    }
    /**
     * Get ChallengeWindowSize value
     * @return int|null
     */
    public function getChallengeWindowSize()
    {
        return $this->ChallengeWindowSize;
    }
    /**
     * Set ChallengeWindowSize value
     * @param int $challengeWindowSize
     * @return \StructType\BrowserDetail
     */
    public function setChallengeWindowSize($challengeWindowSize = null)
    {
        // validation for constraint: int
        if (!is_null($challengeWindowSize) && !(is_int($challengeWindowSize) || ctype_digit($challengeWindowSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($challengeWindowSize, true), gettype($challengeWindowSize)), __LINE__);
        }
        $this->ChallengeWindowSize = $challengeWindowSize;
        return $this;
    }
}
