<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BalanceInquiryResult StructType
 * @subpackage Structs
 */
class BalanceInquiryResult extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ResponseCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The SupplierTransID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierTransID;
    /**
     * The SupplierResponseCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierResponseCode;
    /**
     * Constructor method for BalanceInquiryResult
     * @uses BalanceInquiryResult::setResponseCode()
     * @uses BalanceInquiryResult::setDescription()
     * @uses BalanceInquiryResult::setSupplierTransID()
     * @uses BalanceInquiryResult::setSupplierResponseCode()
     * @param string $responseCode
     * @param string $description
     * @param string $supplierTransID
     * @param string $supplierResponseCode
     */
    public function __construct($responseCode = null, $description = null, $supplierTransID = null, $supplierResponseCode = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setDescription($description)
            ->setSupplierTransID($supplierTransID)
            ->setSupplierResponseCode($supplierResponseCode);
    }
    /**
     * Get ResponseCode value
     * @return string
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \StructType\BalanceInquiryResult
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\BalanceInquiryResult
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \StructType\BalanceInquiryResult
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransID) && !is_string($supplierTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransID, true), gettype($supplierTransID)), __LINE__);
        }
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
    /**
     * Get SupplierResponseCode value
     * @return string|null
     */
    public function getSupplierResponseCode()
    {
        return $this->SupplierResponseCode;
    }
    /**
     * Set SupplierResponseCode value
     * @param string $supplierResponseCode
     * @return \StructType\BalanceInquiryResult
     */
    public function setSupplierResponseCode($supplierResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierResponseCode) && !is_string($supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierResponseCode, true), gettype($supplierResponseCode)), __LINE__);
        }
        $this->SupplierResponseCode = $supplierResponseCode;
        return $this;
    }
}
