<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorizationResultType StructType
 * @subpackage Structs
 */
class AuthorizationResultType extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ResponseCode;
    /**
     * The CardReaderResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CardReaderResult
     */
    public $CardReaderResult;
    /**
     * The T3DS_Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\T3DS_Result
     */
    public $T3DS_Result;
    /**
     * The CSC_Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CSC_ResultType
     */
    public $CSC_Result;
    /**
     * The PIN_Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PIN_Result
     */
    public $PIN_Result;
    /**
     * The AVS_Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AVS_ResultType
     */
    public $AVS_Result;
    /**
     * The AuthResponseDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AuthResponseDetail
     */
    public $AuthResponseDetail;
    /**
     * The TokenizationResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TokenizationResultType
     */
    public $TokenizationResult;
    /**
     * The SupplierMessages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SupplierMessagesType
     */
    public $SupplierMessages;
    /**
     * The LocalCardDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocalCardDetail
     */
    public $LocalCardDetail;
    /**
     * The ReturnURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReturnURL;
    /**
     * The PayByLinkURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PayByLinkURL;
    /**
     * The FulfillmentNotificationURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FulfillmentNotificationURL;
    /**
     * The RedirectHTML
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RedirectHTML;
    /**
     * The RedirectURL
     * Meta information extracted from the WSDL
     * - documentation: URL redirection
     * - minOccurs: 0
     * @var string
     */
    public $RedirectURL;
    /**
     * The AdditionalApprovals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionalApprovals
     */
    public $AdditionalApprovals;
    /**
     * The VoucherDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VoucherDetail
     */
    public $VoucherDetail;
    /**
     * The AdditionalRemarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RemarksType
     */
    public $AdditionalRemarks;
    /**
     * The AdditionalNonHistoricalRemarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RemarksType
     */
    public $AdditionalNonHistoricalRemarks;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RemarksType
     */
    public $Remarks;
    /**
     * The AdditionalDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionalDetailType
     */
    public $AdditionalDetail;
    /**
     * The ListOfReferenceNbrs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ListOfReferenceNbrs
     */
    public $ListOfReferenceNbrs;
    /**
     * The NetworkTokenDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NetworkTokenDetail
     */
    public $NetworkTokenDetail;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The ApprovalCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ApprovalCode;
    /**
     * The ApprovedAmount
     * Meta information extracted from the WSDL
     * - documentation: Total authorized including Bonus. | Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $ApprovedAmount;
    /**
     * The AuthAmountSent
     * Meta information extracted from the WSDL
     * - documentation: Internal use only | Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $AuthAmountSent;
    /**
     * The BonusAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $BonusAmount;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * The SupplierTransID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierTransID;
    /**
     * The SupplierReferenceID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierReferenceID;
    /**
     * The SupplierResponseCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierResponseCode;
    /**
     * The AcquirerResponseCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AcquirerResponseCode;
    /**
     * The MerchantAccountNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MerchantAccountNumber;
    /**
     * The CAVV_ResultCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CAVV_ResultCode;
    /**
     * The AuthRemarks1
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AuthRemarks1;
    /**
     * The AuthRemarks2
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AuthRemarks2;
    /**
     * The DCC_Remarks
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DCC_Remarks;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The PaymentConfirmInd
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PaymentConfirmInd;
    /**
     * The FulfillmentNotificationInd
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $FulfillmentNotificationInd;
    /**
     * The PaymentRef
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PaymentRef;
    /**
     * The ReverseFlagInd
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ReverseFlagInd;
    /**
     * The PreviouslyProcessedRqst
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $PreviouslyProcessedRqst;
    /**
     * The NetworkTransactionReference
     * Meta information extracted from the WSDL
     * - documentation: Transaction ID that supports merchant-initiated transaction (MIT) exemptions
     * - use: optional
     * @var string
     */
    public $NetworkTransactionReference;
    /**
     * The SabreGeneratedApprovalCodeInd
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the credit card approval code is generated by Sabre (PWS) not via a card issuer.
     * - use: optional
     * @var bool
     */
    public $SabreGeneratedApprovalCodeInd;
    /**
     * Constructor method for AuthorizationResultType
     * @uses AuthorizationResultType::setResponseCode()
     * @uses AuthorizationResultType::setCardReaderResult()
     * @uses AuthorizationResultType::setT3DS_Result()
     * @uses AuthorizationResultType::setCSC_Result()
     * @uses AuthorizationResultType::setPIN_Result()
     * @uses AuthorizationResultType::setAVS_Result()
     * @uses AuthorizationResultType::setAuthResponseDetail()
     * @uses AuthorizationResultType::setTokenizationResult()
     * @uses AuthorizationResultType::setSupplierMessages()
     * @uses AuthorizationResultType::setLocalCardDetail()
     * @uses AuthorizationResultType::setReturnURL()
     * @uses AuthorizationResultType::setPayByLinkURL()
     * @uses AuthorizationResultType::setFulfillmentNotificationURL()
     * @uses AuthorizationResultType::setRedirectHTML()
     * @uses AuthorizationResultType::setRedirectURL()
     * @uses AuthorizationResultType::setAdditionalApprovals()
     * @uses AuthorizationResultType::setVoucherDetail()
     * @uses AuthorizationResultType::setAdditionalRemarks()
     * @uses AuthorizationResultType::setAdditionalNonHistoricalRemarks()
     * @uses AuthorizationResultType::setRemarks()
     * @uses AuthorizationResultType::setAdditionalDetail()
     * @uses AuthorizationResultType::setListOfReferenceNbrs()
     * @uses AuthorizationResultType::setNetworkTokenDetail()
     * @uses AuthorizationResultType::setDescription()
     * @uses AuthorizationResultType::setApprovalCode()
     * @uses AuthorizationResultType::setApprovedAmount()
     * @uses AuthorizationResultType::setAuthAmountSent()
     * @uses AuthorizationResultType::setBonusAmount()
     * @uses AuthorizationResultType::setSupplierID()
     * @uses AuthorizationResultType::setSupplierTransID()
     * @uses AuthorizationResultType::setSupplierReferenceID()
     * @uses AuthorizationResultType::setSupplierResponseCode()
     * @uses AuthorizationResultType::setAcquirerResponseCode()
     * @uses AuthorizationResultType::setMerchantAccountNumber()
     * @uses AuthorizationResultType::setCAVV_ResultCode()
     * @uses AuthorizationResultType::setAuthRemarks1()
     * @uses AuthorizationResultType::setAuthRemarks2()
     * @uses AuthorizationResultType::setDCC_Remarks()
     * @uses AuthorizationResultType::setCurrencyCode()
     * @uses AuthorizationResultType::setPaymentConfirmInd()
     * @uses AuthorizationResultType::setFulfillmentNotificationInd()
     * @uses AuthorizationResultType::setPaymentRef()
     * @uses AuthorizationResultType::setReverseFlagInd()
     * @uses AuthorizationResultType::setPreviouslyProcessedRqst()
     * @uses AuthorizationResultType::setNetworkTransactionReference()
     * @uses AuthorizationResultType::setSabreGeneratedApprovalCodeInd()
     * @param string $responseCode
     * @param \StructType\CardReaderResult $cardReaderResult
     * @param \StructType\T3DS_Result $t3DS_Result
     * @param \StructType\CSC_ResultType $cSC_Result
     * @param \StructType\PIN_Result $pIN_Result
     * @param \StructType\AVS_ResultType $aVS_Result
     * @param \StructType\AuthResponseDetail $authResponseDetail
     * @param \StructType\TokenizationResultType $tokenizationResult
     * @param \StructType\SupplierMessagesType $supplierMessages
     * @param \StructType\LocalCardDetail $localCardDetail
     * @param string $returnURL
     * @param string $payByLinkURL
     * @param string $fulfillmentNotificationURL
     * @param string $redirectHTML
     * @param string $redirectURL
     * @param \StructType\AdditionalApprovals $additionalApprovals
     * @param \StructType\VoucherDetail $voucherDetail
     * @param \StructType\RemarksType $additionalRemarks
     * @param \StructType\RemarksType $additionalNonHistoricalRemarks
     * @param \StructType\RemarksType $remarks
     * @param \StructType\AdditionalDetailType $additionalDetail
     * @param \StructType\ListOfReferenceNbrs $listOfReferenceNbrs
     * @param \StructType\NetworkTokenDetail $networkTokenDetail
     * @param string $description
     * @param string $approvalCode
     * @param float $approvedAmount
     * @param float $authAmountSent
     * @param float $bonusAmount
     * @param string $supplierID
     * @param string $supplierTransID
     * @param string $supplierReferenceID
     * @param string $supplierResponseCode
     * @param string $acquirerResponseCode
     * @param string $merchantAccountNumber
     * @param string $cAVV_ResultCode
     * @param string $authRemarks1
     * @param string $authRemarks2
     * @param string $dCC_Remarks
     * @param string $currencyCode
     * @param string $paymentConfirmInd
     * @param bool $fulfillmentNotificationInd
     * @param string $paymentRef
     * @param bool $reverseFlagInd
     * @param bool $previouslyProcessedRqst
     * @param string $networkTransactionReference
     * @param bool $sabreGeneratedApprovalCodeInd
     */
    public function __construct($responseCode = null, \StructType\CardReaderResult $cardReaderResult = null, \StructType\T3DS_Result $t3DS_Result = null, \StructType\CSC_ResultType $cSC_Result = null, \StructType\PIN_Result $pIN_Result = null, \StructType\AVS_ResultType $aVS_Result = null, \StructType\AuthResponseDetail $authResponseDetail = null, \StructType\TokenizationResultType $tokenizationResult = null, \StructType\SupplierMessagesType $supplierMessages = null, \StructType\LocalCardDetail $localCardDetail = null, $returnURL = null, $payByLinkURL = null, $fulfillmentNotificationURL = null, $redirectHTML = null, $redirectURL = null, \StructType\AdditionalApprovals $additionalApprovals = null, \StructType\VoucherDetail $voucherDetail = null, \StructType\RemarksType $additionalRemarks = null, \StructType\RemarksType $additionalNonHistoricalRemarks = null, \StructType\RemarksType $remarks = null, \StructType\AdditionalDetailType $additionalDetail = null, \StructType\ListOfReferenceNbrs $listOfReferenceNbrs = null, \StructType\NetworkTokenDetail $networkTokenDetail = null, $description = null, $approvalCode = null, $approvedAmount = null, $authAmountSent = null, $bonusAmount = null, $supplierID = null, $supplierTransID = null, $supplierReferenceID = null, $supplierResponseCode = null, $acquirerResponseCode = null, $merchantAccountNumber = null, $cAVV_ResultCode = null, $authRemarks1 = null, $authRemarks2 = null, $dCC_Remarks = null, $currencyCode = null, $paymentConfirmInd = null, $fulfillmentNotificationInd = null, $paymentRef = null, $reverseFlagInd = null, $previouslyProcessedRqst = null, $networkTransactionReference = null, $sabreGeneratedApprovalCodeInd = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setCardReaderResult($cardReaderResult)
            ->setT3DS_Result($t3DS_Result)
            ->setCSC_Result($cSC_Result)
            ->setPIN_Result($pIN_Result)
            ->setAVS_Result($aVS_Result)
            ->setAuthResponseDetail($authResponseDetail)
            ->setTokenizationResult($tokenizationResult)
            ->setSupplierMessages($supplierMessages)
            ->setLocalCardDetail($localCardDetail)
            ->setReturnURL($returnURL)
            ->setPayByLinkURL($payByLinkURL)
            ->setFulfillmentNotificationURL($fulfillmentNotificationURL)
            ->setRedirectHTML($redirectHTML)
            ->setRedirectURL($redirectURL)
            ->setAdditionalApprovals($additionalApprovals)
            ->setVoucherDetail($voucherDetail)
            ->setAdditionalRemarks($additionalRemarks)
            ->setAdditionalNonHistoricalRemarks($additionalNonHistoricalRemarks)
            ->setRemarks($remarks)
            ->setAdditionalDetail($additionalDetail)
            ->setListOfReferenceNbrs($listOfReferenceNbrs)
            ->setNetworkTokenDetail($networkTokenDetail)
            ->setDescription($description)
            ->setApprovalCode($approvalCode)
            ->setApprovedAmount($approvedAmount)
            ->setAuthAmountSent($authAmountSent)
            ->setBonusAmount($bonusAmount)
            ->setSupplierID($supplierID)
            ->setSupplierTransID($supplierTransID)
            ->setSupplierReferenceID($supplierReferenceID)
            ->setSupplierResponseCode($supplierResponseCode)
            ->setAcquirerResponseCode($acquirerResponseCode)
            ->setMerchantAccountNumber($merchantAccountNumber)
            ->setCAVV_ResultCode($cAVV_ResultCode)
            ->setAuthRemarks1($authRemarks1)
            ->setAuthRemarks2($authRemarks2)
            ->setDCC_Remarks($dCC_Remarks)
            ->setCurrencyCode($currencyCode)
            ->setPaymentConfirmInd($paymentConfirmInd)
            ->setFulfillmentNotificationInd($fulfillmentNotificationInd)
            ->setPaymentRef($paymentRef)
            ->setReverseFlagInd($reverseFlagInd)
            ->setPreviouslyProcessedRqst($previouslyProcessedRqst)
            ->setNetworkTransactionReference($networkTransactionReference)
            ->setSabreGeneratedApprovalCodeInd($sabreGeneratedApprovalCodeInd);
    }
    /**
     * Get ResponseCode value
     * @return string
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \StructType\AuthorizationResultType
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get CardReaderResult value
     * @return \StructType\CardReaderResult|null
     */
    public function getCardReaderResult()
    {
        return $this->CardReaderResult;
    }
    /**
     * Set CardReaderResult value
     * @param \StructType\CardReaderResult $cardReaderResult
     * @return \StructType\AuthorizationResultType
     */
    public function setCardReaderResult(\StructType\CardReaderResult $cardReaderResult = null)
    {
        $this->CardReaderResult = $cardReaderResult;
        return $this;
    }
    /**
     * Get T3DS_Result value
     * @return \StructType\T3DS_Result|null
     */
    public function getT3DS_Result()
    {
        return $this->T3DS_Result;
    }
    /**
     * Set T3DS_Result value
     * @param \StructType\T3DS_Result $t3DS_Result
     * @return \StructType\AuthorizationResultType
     */
    public function setT3DS_Result(\StructType\T3DS_Result $t3DS_Result = null)
    {
        $this->T3DS_Result = $t3DS_Result;
        return $this;
    }
    /**
     * Get CSC_Result value
     * @return \StructType\CSC_ResultType|null
     */
    public function getCSC_Result()
    {
        return $this->CSC_Result;
    }
    /**
     * Set CSC_Result value
     * @param \StructType\CSC_ResultType $cSC_Result
     * @return \StructType\AuthorizationResultType
     */
    public function setCSC_Result(\StructType\CSC_ResultType $cSC_Result = null)
    {
        $this->CSC_Result = $cSC_Result;
        return $this;
    }
    /**
     * Get PIN_Result value
     * @return \StructType\PIN_Result|null
     */
    public function getPIN_Result()
    {
        return $this->PIN_Result;
    }
    /**
     * Set PIN_Result value
     * @param \StructType\PIN_Result $pIN_Result
     * @return \StructType\AuthorizationResultType
     */
    public function setPIN_Result(\StructType\PIN_Result $pIN_Result = null)
    {
        $this->PIN_Result = $pIN_Result;
        return $this;
    }
    /**
     * Get AVS_Result value
     * @return \StructType\AVS_ResultType|null
     */
    public function getAVS_Result()
    {
        return $this->AVS_Result;
    }
    /**
     * Set AVS_Result value
     * @param \StructType\AVS_ResultType $aVS_Result
     * @return \StructType\AuthorizationResultType
     */
    public function setAVS_Result(\StructType\AVS_ResultType $aVS_Result = null)
    {
        $this->AVS_Result = $aVS_Result;
        return $this;
    }
    /**
     * Get AuthResponseDetail value
     * @return \StructType\AuthResponseDetail|null
     */
    public function getAuthResponseDetail()
    {
        return $this->AuthResponseDetail;
    }
    /**
     * Set AuthResponseDetail value
     * @param \StructType\AuthResponseDetail $authResponseDetail
     * @return \StructType\AuthorizationResultType
     */
    public function setAuthResponseDetail(\StructType\AuthResponseDetail $authResponseDetail = null)
    {
        $this->AuthResponseDetail = $authResponseDetail;
        return $this;
    }
    /**
     * Get TokenizationResult value
     * @return \StructType\TokenizationResultType|null
     */
    public function getTokenizationResult()
    {
        return $this->TokenizationResult;
    }
    /**
     * Set TokenizationResult value
     * @param \StructType\TokenizationResultType $tokenizationResult
     * @return \StructType\AuthorizationResultType
     */
    public function setTokenizationResult(\StructType\TokenizationResultType $tokenizationResult = null)
    {
        $this->TokenizationResult = $tokenizationResult;
        return $this;
    }
    /**
     * Get SupplierMessages value
     * @return \StructType\SupplierMessagesType|null
     */
    public function getSupplierMessages()
    {
        return $this->SupplierMessages;
    }
    /**
     * Set SupplierMessages value
     * @param \StructType\SupplierMessagesType $supplierMessages
     * @return \StructType\AuthorizationResultType
     */
    public function setSupplierMessages(\StructType\SupplierMessagesType $supplierMessages = null)
    {
        $this->SupplierMessages = $supplierMessages;
        return $this;
    }
    /**
     * Get LocalCardDetail value
     * @return \StructType\LocalCardDetail|null
     */
    public function getLocalCardDetail()
    {
        return $this->LocalCardDetail;
    }
    /**
     * Set LocalCardDetail value
     * @param \StructType\LocalCardDetail $localCardDetail
     * @return \StructType\AuthorizationResultType
     */
    public function setLocalCardDetail(\StructType\LocalCardDetail $localCardDetail = null)
    {
        $this->LocalCardDetail = $localCardDetail;
        return $this;
    }
    /**
     * Get ReturnURL value
     * @return string|null
     */
    public function getReturnURL()
    {
        return $this->ReturnURL;
    }
    /**
     * Set ReturnURL value
     * @param string $returnURL
     * @return \StructType\AuthorizationResultType
     */
    public function setReturnURL($returnURL = null)
    {
        // validation for constraint: string
        if (!is_null($returnURL) && !is_string($returnURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnURL, true), gettype($returnURL)), __LINE__);
        }
        $this->ReturnURL = $returnURL;
        return $this;
    }
    /**
     * Get PayByLinkURL value
     * @return string|null
     */
    public function getPayByLinkURL()
    {
        return $this->PayByLinkURL;
    }
    /**
     * Set PayByLinkURL value
     * @param string $payByLinkURL
     * @return \StructType\AuthorizationResultType
     */
    public function setPayByLinkURL($payByLinkURL = null)
    {
        // validation for constraint: string
        if (!is_null($payByLinkURL) && !is_string($payByLinkURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payByLinkURL, true), gettype($payByLinkURL)), __LINE__);
        }
        $this->PayByLinkURL = $payByLinkURL;
        return $this;
    }
    /**
     * Get FulfillmentNotificationURL value
     * @return string|null
     */
    public function getFulfillmentNotificationURL()
    {
        return $this->FulfillmentNotificationURL;
    }
    /**
     * Set FulfillmentNotificationURL value
     * @param string $fulfillmentNotificationURL
     * @return \StructType\AuthorizationResultType
     */
    public function setFulfillmentNotificationURL($fulfillmentNotificationURL = null)
    {
        // validation for constraint: string
        if (!is_null($fulfillmentNotificationURL) && !is_string($fulfillmentNotificationURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fulfillmentNotificationURL, true), gettype($fulfillmentNotificationURL)), __LINE__);
        }
        $this->FulfillmentNotificationURL = $fulfillmentNotificationURL;
        return $this;
    }
    /**
     * Get RedirectHTML value
     * @return string|null
     */
    public function getRedirectHTML()
    {
        return $this->RedirectHTML;
    }
    /**
     * Set RedirectHTML value
     * @param string $redirectHTML
     * @return \StructType\AuthorizationResultType
     */
    public function setRedirectHTML($redirectHTML = null)
    {
        // validation for constraint: string
        if (!is_null($redirectHTML) && !is_string($redirectHTML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectHTML, true), gettype($redirectHTML)), __LINE__);
        }
        $this->RedirectHTML = $redirectHTML;
        return $this;
    }
    /**
     * Get RedirectURL value
     * @return string|null
     */
    public function getRedirectURL()
    {
        return $this->RedirectURL;
    }
    /**
     * Set RedirectURL value
     * @param string $redirectURL
     * @return \StructType\AuthorizationResultType
     */
    public function setRedirectURL($redirectURL = null)
    {
        // validation for constraint: string
        if (!is_null($redirectURL) && !is_string($redirectURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectURL, true), gettype($redirectURL)), __LINE__);
        }
        $this->RedirectURL = $redirectURL;
        return $this;
    }
    /**
     * Get AdditionalApprovals value
     * @return \StructType\AdditionalApprovals|null
     */
    public function getAdditionalApprovals()
    {
        return $this->AdditionalApprovals;
    }
    /**
     * Set AdditionalApprovals value
     * @param \StructType\AdditionalApprovals $additionalApprovals
     * @return \StructType\AuthorizationResultType
     */
    public function setAdditionalApprovals(\StructType\AdditionalApprovals $additionalApprovals = null)
    {
        $this->AdditionalApprovals = $additionalApprovals;
        return $this;
    }
    /**
     * Get VoucherDetail value
     * @return \StructType\VoucherDetail|null
     */
    public function getVoucherDetail()
    {
        return $this->VoucherDetail;
    }
    /**
     * Set VoucherDetail value
     * @param \StructType\VoucherDetail $voucherDetail
     * @return \StructType\AuthorizationResultType
     */
    public function setVoucherDetail(\StructType\VoucherDetail $voucherDetail = null)
    {
        $this->VoucherDetail = $voucherDetail;
        return $this;
    }
    /**
     * Get AdditionalRemarks value
     * @return \StructType\RemarksType|null
     */
    public function getAdditionalRemarks()
    {
        return $this->AdditionalRemarks;
    }
    /**
     * Set AdditionalRemarks value
     * @param \StructType\RemarksType $additionalRemarks
     * @return \StructType\AuthorizationResultType
     */
    public function setAdditionalRemarks(\StructType\RemarksType $additionalRemarks = null)
    {
        $this->AdditionalRemarks = $additionalRemarks;
        return $this;
    }
    /**
     * Get AdditionalNonHistoricalRemarks value
     * @return \StructType\RemarksType|null
     */
    public function getAdditionalNonHistoricalRemarks()
    {
        return $this->AdditionalNonHistoricalRemarks;
    }
    /**
     * Set AdditionalNonHistoricalRemarks value
     * @param \StructType\RemarksType $additionalNonHistoricalRemarks
     * @return \StructType\AuthorizationResultType
     */
    public function setAdditionalNonHistoricalRemarks(\StructType\RemarksType $additionalNonHistoricalRemarks = null)
    {
        $this->AdditionalNonHistoricalRemarks = $additionalNonHistoricalRemarks;
        return $this;
    }
    /**
     * Get Remarks value
     * @return \StructType\RemarksType|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param \StructType\RemarksType $remarks
     * @return \StructType\AuthorizationResultType
     */
    public function setRemarks(\StructType\RemarksType $remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get AdditionalDetail value
     * @return \StructType\AdditionalDetailType|null
     */
    public function getAdditionalDetail()
    {
        return $this->AdditionalDetail;
    }
    /**
     * Set AdditionalDetail value
     * @param \StructType\AdditionalDetailType $additionalDetail
     * @return \StructType\AuthorizationResultType
     */
    public function setAdditionalDetail(\StructType\AdditionalDetailType $additionalDetail = null)
    {
        $this->AdditionalDetail = $additionalDetail;
        return $this;
    }
    /**
     * Get ListOfReferenceNbrs value
     * @return \StructType\ListOfReferenceNbrs|null
     */
    public function getListOfReferenceNbrs()
    {
        return $this->ListOfReferenceNbrs;
    }
    /**
     * Set ListOfReferenceNbrs value
     * @param \StructType\ListOfReferenceNbrs $listOfReferenceNbrs
     * @return \StructType\AuthorizationResultType
     */
    public function setListOfReferenceNbrs(\StructType\ListOfReferenceNbrs $listOfReferenceNbrs = null)
    {
        $this->ListOfReferenceNbrs = $listOfReferenceNbrs;
        return $this;
    }
    /**
     * Get NetworkTokenDetail value
     * @return \StructType\NetworkTokenDetail|null
     */
    public function getNetworkTokenDetail()
    {
        return $this->NetworkTokenDetail;
    }
    /**
     * Set NetworkTokenDetail value
     * @param \StructType\NetworkTokenDetail $networkTokenDetail
     * @return \StructType\AuthorizationResultType
     */
    public function setNetworkTokenDetail(\StructType\NetworkTokenDetail $networkTokenDetail = null)
    {
        $this->NetworkTokenDetail = $networkTokenDetail;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\AuthorizationResultType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ApprovalCode value
     * @return string|null
     */
    public function getApprovalCode()
    {
        return $this->ApprovalCode;
    }
    /**
     * Set ApprovalCode value
     * @param string $approvalCode
     * @return \StructType\AuthorizationResultType
     */
    public function setApprovalCode($approvalCode = null)
    {
        // validation for constraint: string
        if (!is_null($approvalCode) && !is_string($approvalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalCode, true), gettype($approvalCode)), __LINE__);
        }
        $this->ApprovalCode = $approvalCode;
        return $this;
    }
    /**
     * Get ApprovedAmount value
     * @return float|null
     */
    public function getApprovedAmount()
    {
        return $this->ApprovedAmount;
    }
    /**
     * Set ApprovedAmount value
     * @param float $approvedAmount
     * @return \StructType\AuthorizationResultType
     */
    public function setApprovedAmount($approvedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($approvedAmount) && !(is_float($approvedAmount) || is_numeric($approvedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($approvedAmount, true), gettype($approvedAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($approvedAmount) && mb_strlen(mb_substr($approvedAmount, false !== mb_strpos($approvedAmount, '.') ? mb_strpos($approvedAmount, '.') + 1 : mb_strlen($approvedAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($approvedAmount, true), mb_strlen(mb_substr($approvedAmount, mb_strpos($approvedAmount, '.') + 1))), __LINE__);
        }
        $this->ApprovedAmount = $approvedAmount;
        return $this;
    }
    /**
     * Get AuthAmountSent value
     * @return float|null
     */
    public function getAuthAmountSent()
    {
        return $this->AuthAmountSent;
    }
    /**
     * Set AuthAmountSent value
     * @param float $authAmountSent
     * @return \StructType\AuthorizationResultType
     */
    public function setAuthAmountSent($authAmountSent = null)
    {
        // validation for constraint: float
        if (!is_null($authAmountSent) && !(is_float($authAmountSent) || is_numeric($authAmountSent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($authAmountSent, true), gettype($authAmountSent)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($authAmountSent) && mb_strlen(mb_substr($authAmountSent, false !== mb_strpos($authAmountSent, '.') ? mb_strpos($authAmountSent, '.') + 1 : mb_strlen($authAmountSent))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($authAmountSent, true), mb_strlen(mb_substr($authAmountSent, mb_strpos($authAmountSent, '.') + 1))), __LINE__);
        }
        $this->AuthAmountSent = $authAmountSent;
        return $this;
    }
    /**
     * Get BonusAmount value
     * @return float|null
     */
    public function getBonusAmount()
    {
        return $this->BonusAmount;
    }
    /**
     * Set BonusAmount value
     * @param float $bonusAmount
     * @return \StructType\AuthorizationResultType
     */
    public function setBonusAmount($bonusAmount = null)
    {
        // validation for constraint: float
        if (!is_null($bonusAmount) && !(is_float($bonusAmount) || is_numeric($bonusAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonusAmount, true), gettype($bonusAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($bonusAmount) && mb_strlen(mb_substr($bonusAmount, false !== mb_strpos($bonusAmount, '.') ? mb_strpos($bonusAmount, '.') + 1 : mb_strlen($bonusAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($bonusAmount, true), mb_strlen(mb_substr($bonusAmount, mb_strpos($bonusAmount, '.') + 1))), __LINE__);
        }
        $this->BonusAmount = $bonusAmount;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \StructType\AuthorizationResultType
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \StructType\AuthorizationResultType
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransID) && !is_string($supplierTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransID, true), gettype($supplierTransID)), __LINE__);
        }
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
    /**
     * Get SupplierReferenceID value
     * @return string|null
     */
    public function getSupplierReferenceID()
    {
        return $this->SupplierReferenceID;
    }
    /**
     * Set SupplierReferenceID value
     * @param string $supplierReferenceID
     * @return \StructType\AuthorizationResultType
     */
    public function setSupplierReferenceID($supplierReferenceID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierReferenceID) && !is_string($supplierReferenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierReferenceID, true), gettype($supplierReferenceID)), __LINE__);
        }
        $this->SupplierReferenceID = $supplierReferenceID;
        return $this;
    }
    /**
     * Get SupplierResponseCode value
     * @return string|null
     */
    public function getSupplierResponseCode()
    {
        return $this->SupplierResponseCode;
    }
    /**
     * Set SupplierResponseCode value
     * @param string $supplierResponseCode
     * @return \StructType\AuthorizationResultType
     */
    public function setSupplierResponseCode($supplierResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierResponseCode) && !is_string($supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierResponseCode, true), gettype($supplierResponseCode)), __LINE__);
        }
        $this->SupplierResponseCode = $supplierResponseCode;
        return $this;
    }
    /**
     * Get AcquirerResponseCode value
     * @return string|null
     */
    public function getAcquirerResponseCode()
    {
        return $this->AcquirerResponseCode;
    }
    /**
     * Set AcquirerResponseCode value
     * @param string $acquirerResponseCode
     * @return \StructType\AuthorizationResultType
     */
    public function setAcquirerResponseCode($acquirerResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($acquirerResponseCode) && !is_string($acquirerResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acquirerResponseCode, true), gettype($acquirerResponseCode)), __LINE__);
        }
        $this->AcquirerResponseCode = $acquirerResponseCode;
        return $this;
    }
    /**
     * Get MerchantAccountNumber value
     * @return string|null
     */
    public function getMerchantAccountNumber()
    {
        return $this->MerchantAccountNumber;
    }
    /**
     * Set MerchantAccountNumber value
     * @param string $merchantAccountNumber
     * @return \StructType\AuthorizationResultType
     */
    public function setMerchantAccountNumber($merchantAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($merchantAccountNumber) && !is_string($merchantAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantAccountNumber, true), gettype($merchantAccountNumber)), __LINE__);
        }
        $this->MerchantAccountNumber = $merchantAccountNumber;
        return $this;
    }
    /**
     * Get CAVV_ResultCode value
     * @return string|null
     */
    public function getCAVV_ResultCode()
    {
        return $this->CAVV_ResultCode;
    }
    /**
     * Set CAVV_ResultCode value
     * @param string $cAVV_ResultCode
     * @return \StructType\AuthorizationResultType
     */
    public function setCAVV_ResultCode($cAVV_ResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($cAVV_ResultCode) && !is_string($cAVV_ResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAVV_ResultCode, true), gettype($cAVV_ResultCode)), __LINE__);
        }
        $this->CAVV_ResultCode = $cAVV_ResultCode;
        return $this;
    }
    /**
     * Get AuthRemarks1 value
     * @return string|null
     */
    public function getAuthRemarks1()
    {
        return $this->AuthRemarks1;
    }
    /**
     * Set AuthRemarks1 value
     * @param string $authRemarks1
     * @return \StructType\AuthorizationResultType
     */
    public function setAuthRemarks1($authRemarks1 = null)
    {
        // validation for constraint: string
        if (!is_null($authRemarks1) && !is_string($authRemarks1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authRemarks1, true), gettype($authRemarks1)), __LINE__);
        }
        $this->AuthRemarks1 = $authRemarks1;
        return $this;
    }
    /**
     * Get AuthRemarks2 value
     * @return string|null
     */
    public function getAuthRemarks2()
    {
        return $this->AuthRemarks2;
    }
    /**
     * Set AuthRemarks2 value
     * @param string $authRemarks2
     * @return \StructType\AuthorizationResultType
     */
    public function setAuthRemarks2($authRemarks2 = null)
    {
        // validation for constraint: string
        if (!is_null($authRemarks2) && !is_string($authRemarks2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authRemarks2, true), gettype($authRemarks2)), __LINE__);
        }
        $this->AuthRemarks2 = $authRemarks2;
        return $this;
    }
    /**
     * Get DCC_Remarks value
     * @return string|null
     */
    public function getDCC_Remarks()
    {
        return $this->DCC_Remarks;
    }
    /**
     * Set DCC_Remarks value
     * @param string $dCC_Remarks
     * @return \StructType\AuthorizationResultType
     */
    public function setDCC_Remarks($dCC_Remarks = null)
    {
        // validation for constraint: string
        if (!is_null($dCC_Remarks) && !is_string($dCC_Remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dCC_Remarks, true), gettype($dCC_Remarks)), __LINE__);
        }
        $this->DCC_Remarks = $dCC_Remarks;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\AuthorizationResultType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get PaymentConfirmInd value
     * @return string|null
     */
    public function getPaymentConfirmInd()
    {
        return $this->PaymentConfirmInd;
    }
    /**
     * Set PaymentConfirmInd value
     * @param string $paymentConfirmInd
     * @return \StructType\AuthorizationResultType
     */
    public function setPaymentConfirmInd($paymentConfirmInd = null)
    {
        // validation for constraint: string
        if (!is_null($paymentConfirmInd) && !is_string($paymentConfirmInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentConfirmInd, true), gettype($paymentConfirmInd)), __LINE__);
        }
        $this->PaymentConfirmInd = $paymentConfirmInd;
        return $this;
    }
    /**
     * Get FulfillmentNotificationInd value
     * @return bool|null
     */
    public function getFulfillmentNotificationInd()
    {
        return $this->FulfillmentNotificationInd;
    }
    /**
     * Set FulfillmentNotificationInd value
     * @param bool $fulfillmentNotificationInd
     * @return \StructType\AuthorizationResultType
     */
    public function setFulfillmentNotificationInd($fulfillmentNotificationInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($fulfillmentNotificationInd) && !is_bool($fulfillmentNotificationInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fulfillmentNotificationInd, true), gettype($fulfillmentNotificationInd)), __LINE__);
        }
        $this->FulfillmentNotificationInd = $fulfillmentNotificationInd;
        return $this;
    }
    /**
     * Get PaymentRef value
     * @return string|null
     */
    public function getPaymentRef()
    {
        return $this->PaymentRef;
    }
    /**
     * Set PaymentRef value
     * @param string $paymentRef
     * @return \StructType\AuthorizationResultType
     */
    public function setPaymentRef($paymentRef = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRef) && !is_string($paymentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRef, true), gettype($paymentRef)), __LINE__);
        }
        $this->PaymentRef = $paymentRef;
        return $this;
    }
    /**
     * Get ReverseFlagInd value
     * @return bool|null
     */
    public function getReverseFlagInd()
    {
        return $this->ReverseFlagInd;
    }
    /**
     * Set ReverseFlagInd value
     * @param bool $reverseFlagInd
     * @return \StructType\AuthorizationResultType
     */
    public function setReverseFlagInd($reverseFlagInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($reverseFlagInd) && !is_bool($reverseFlagInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reverseFlagInd, true), gettype($reverseFlagInd)), __LINE__);
        }
        $this->ReverseFlagInd = $reverseFlagInd;
        return $this;
    }
    /**
     * Get PreviouslyProcessedRqst value
     * @return bool|null
     */
    public function getPreviouslyProcessedRqst()
    {
        return $this->PreviouslyProcessedRqst;
    }
    /**
     * Set PreviouslyProcessedRqst value
     * @param bool $previouslyProcessedRqst
     * @return \StructType\AuthorizationResultType
     */
    public function setPreviouslyProcessedRqst($previouslyProcessedRqst = null)
    {
        // validation for constraint: boolean
        if (!is_null($previouslyProcessedRqst) && !is_bool($previouslyProcessedRqst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($previouslyProcessedRqst, true), gettype($previouslyProcessedRqst)), __LINE__);
        }
        $this->PreviouslyProcessedRqst = $previouslyProcessedRqst;
        return $this;
    }
    /**
     * Get NetworkTransactionReference value
     * @return string|null
     */
    public function getNetworkTransactionReference()
    {
        return $this->NetworkTransactionReference;
    }
    /**
     * Set NetworkTransactionReference value
     * @param string $networkTransactionReference
     * @return \StructType\AuthorizationResultType
     */
    public function setNetworkTransactionReference($networkTransactionReference = null)
    {
        // validation for constraint: string
        if (!is_null($networkTransactionReference) && !is_string($networkTransactionReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($networkTransactionReference, true), gettype($networkTransactionReference)), __LINE__);
        }
        $this->NetworkTransactionReference = $networkTransactionReference;
        return $this;
    }
    /**
     * Get SabreGeneratedApprovalCodeInd value
     * @return bool|null
     */
    public function getSabreGeneratedApprovalCodeInd()
    {
        return $this->SabreGeneratedApprovalCodeInd;
    }
    /**
     * Set SabreGeneratedApprovalCodeInd value
     * @param bool $sabreGeneratedApprovalCodeInd
     * @return \StructType\AuthorizationResultType
     */
    public function setSabreGeneratedApprovalCodeInd($sabreGeneratedApprovalCodeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($sabreGeneratedApprovalCodeInd) && !is_bool($sabreGeneratedApprovalCodeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sabreGeneratedApprovalCodeInd, true), gettype($sabreGeneratedApprovalCodeInd)), __LINE__);
        }
        $this->SabreGeneratedApprovalCodeInd = $sabreGeneratedApprovalCodeInd;
        return $this;
    }
}
