<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType StructType
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The StreetNmbr
     * Meta information extracted from the WSDL
     * - documentation: Street Name and Number within the address
     * - minOccurs: 0
     * @var \StructType\StreetNmbrType
     */
    public $StreetNmbr;
    /**
     * The BldgRoom
     * Meta information extracted from the WSDL
     * - documentation: Building name, room, apartment, or suite number.
     * - minOccurs: 0
     * @var string
     */
    public $BldgRoom;
    /**
     * The AddressLine1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine2;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - documentation: City name eg. Dublin
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - documentation: Post Office Code number.
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The District
     * Meta information extracted from the WSDL
     * - documentation: District Name
     * - minOccurs: 0
     * @var string
     */
    public $District;
    /**
     * The County
     * Meta information extracted from the WSDL
     * - documentation: County Name eg. Fairfax
     * - minOccurs: 0
     * @var string
     */
    public $County;
    /**
     * The StateProv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StateProv
     */
    public $StateProv;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CountryNameType
     */
    public $Country;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Defines the type of address (e.g. home, business, other). Refer to OTA Code List Communication Location Type (CLT). | Used for codes in the OTA code tables.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Can be used to further describe the address or location such as "Airport", "Downtown", etc. | Used for codes in the OTA code tables.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setStreetNmbr()
     * @uses AddressType::setBldgRoom()
     * @uses AddressType::setAddressLine1()
     * @uses AddressType::setAddressLine2()
     * @uses AddressType::setCityName()
     * @uses AddressType::setPostalCode()
     * @uses AddressType::setDistrict()
     * @uses AddressType::setCounty()
     * @uses AddressType::setStateProv()
     * @uses AddressType::setCountry()
     * @uses AddressType::setType()
     * @uses AddressType::setDescription()
     * @param \StructType\StreetNmbrType $streetNmbr
     * @param string $bldgRoom
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $cityName
     * @param string $postalCode
     * @param string $district
     * @param string $county
     * @param \StructType\StateProv $stateProv
     * @param \StructType\CountryNameType $country
     * @param string $type
     * @param string $description
     */
    public function __construct(\StructType\StreetNmbrType $streetNmbr = null, $bldgRoom = null, $addressLine1 = null, $addressLine2 = null, $cityName = null, $postalCode = null, $district = null, $county = null, \StructType\StateProv $stateProv = null, \StructType\CountryNameType $country = null, $type = null, $description = null)
    {
        $this
            ->setStreetNmbr($streetNmbr)
            ->setBldgRoom($bldgRoom)
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setCityName($cityName)
            ->setPostalCode($postalCode)
            ->setDistrict($district)
            ->setCounty($county)
            ->setStateProv($stateProv)
            ->setCountry($country)
            ->setType($type)
            ->setDescription($description);
    }
    /**
     * Get StreetNmbr value
     * @return \StructType\StreetNmbrType|null
     */
    public function getStreetNmbr()
    {
        return $this->StreetNmbr;
    }
    /**
     * Set StreetNmbr value
     * @param \StructType\StreetNmbrType $streetNmbr
     * @return \StructType\AddressType
     */
    public function setStreetNmbr(\StructType\StreetNmbrType $streetNmbr = null)
    {
        $this->StreetNmbr = $streetNmbr;
        return $this;
    }
    /**
     * Get BldgRoom value
     * @return string|null
     */
    public function getBldgRoom()
    {
        return $this->BldgRoom;
    }
    /**
     * Set BldgRoom value
     * @param string $bldgRoom
     * @return \StructType\AddressType
     */
    public function setBldgRoom($bldgRoom = null)
    {
        // validation for constraint: string
        if (!is_null($bldgRoom) && !is_string($bldgRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bldgRoom, true), gettype($bldgRoom)), __LINE__);
        }
        $this->BldgRoom = $bldgRoom;
        return $this;
    }
    /**
     * Get AddressLine1 value
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->AddressLine1;
    }
    /**
     * Set AddressLine1 value
     * @param string $addressLine1
     * @return \StructType\AddressType
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine1, true), gettype($addressLine1)), __LINE__);
        }
        $this->AddressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get AddressLine2 value
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->AddressLine2;
    }
    /**
     * Set AddressLine2 value
     * @param string $addressLine2
     * @return \StructType\AddressType
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine2, true), gettype($addressLine2)), __LINE__);
        }
        $this->AddressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\AddressType
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\AddressType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get District value
     * @return string|null
     */
    public function getDistrict()
    {
        return $this->District;
    }
    /**
     * Set District value
     * @param string $district
     * @return \StructType\AddressType
     */
    public function setDistrict($district = null)
    {
        // validation for constraint: string
        if (!is_null($district) && !is_string($district)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($district, true), gettype($district)), __LINE__);
        }
        $this->District = $district;
        return $this;
    }
    /**
     * Get County value
     * @return string|null
     */
    public function getCounty()
    {
        return $this->County;
    }
    /**
     * Set County value
     * @param string $county
     * @return \StructType\AddressType
     */
    public function setCounty($county = null)
    {
        // validation for constraint: string
        if (!is_null($county) && !is_string($county)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($county, true), gettype($county)), __LINE__);
        }
        $this->County = $county;
        return $this;
    }
    /**
     * Get StateProv value
     * @return \StructType\StateProv|null
     */
    public function getStateProv()
    {
        return $this->StateProv;
    }
    /**
     * Set StateProv value
     * @param \StructType\StateProv $stateProv
     * @return \StructType\AddressType
     */
    public function setStateProv(\StructType\StateProv $stateProv = null)
    {
        $this->StateProv = $stateProv;
        return $this;
    }
    /**
     * Get Country value
     * @return \StructType\CountryNameType|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\CountryNameType $country
     * @return \StructType\AddressType
     */
    public function setCountry(\StructType\CountryNameType $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\AddressType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3})
        if (!is_null($type) && !preg_match('/[0-9A-Z]{1,3}/', $type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}', var_export($type, true)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\AddressType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3})
        if (!is_null($description) && !preg_match('/[0-9A-Z]{1,3}/', $description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}', var_export($description, true)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
