<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AckRequested StructType
 * @subpackage Structs
 */
class AckRequested extends AbstractStructBase
{
    /**
     * The signed
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $signed;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The actor
     * Meta information extracted from the WSDL
     * - ref: soap:actor
     * @var string
     */
    public $actor;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for AckRequested
     * @uses AckRequested::setSigned()
     * @uses AckRequested::setAny()
     * @uses AckRequested::setActor()
     * @uses AckRequested::setId()
     * @uses AckRequested::setVersion()
     * @param bool $signed
     * @param \DOMDocument $any
     * @param string $actor
     * @param string $id
     * @param string $version
     */
    public function __construct($signed = null, \DOMDocument $any = null, $actor = null, $id = null, $version = null)
    {
        $this
            ->setSigned($signed)
            ->setAny($any)
            ->setActor($actor)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get signed value
     * @return bool
     */
    public function getSigned()
    {
        return $this->signed;
    }
    /**
     * Set signed value
     * @param bool $signed
     * @return \StructType\AckRequested
     */
    public function setSigned($signed = null)
    {
        // validation for constraint: boolean
        if (!is_null($signed) && !is_bool($signed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($signed, true), gettype($signed)), __LINE__);
        }
        $this->signed = $signed;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\AckRequested
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get actor value
     * @return string|null
     */
    public function getActor()
    {
        return $this->actor;
    }
    /**
     * Set actor value
     * @param string $actor
     * @return \StructType\AckRequested
     */
    public function setActor($actor = null)
    {
        // validation for constraint: string
        if (!is_null($actor) && !is_string($actor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actor, true), gettype($actor)), __LINE__);
        }
        $this->actor = $actor;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\AckRequested
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\AckRequested
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($version) && mb_strlen($version) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
