<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDetail StructType
 * @subpackage Structs
 */
class AccountDetail extends AccountDetailType
{
    /**
     * The SubBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\SubBalanceType[]
     */
    public $SubBalance;
    /**
     * The ListOfVouchers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ListOfVouchers
     */
    public $ListOfVouchers;
    /**
     * The InternalAccountNbr
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $InternalAccountNbr;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Balance;
    /**
     * The Usage
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Usage;
    /**
     * The ValidFrom
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ValidFrom;
    /**
     * The ValidUntil
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ValidUntil;
    /**
     * Constructor method for AccountDetail
     * @uses AccountDetail::setSubBalance()
     * @uses AccountDetail::setListOfVouchers()
     * @uses AccountDetail::setInternalAccountNbr()
     * @uses AccountDetail::setBalance()
     * @uses AccountDetail::setUsage()
     * @uses AccountDetail::setValidFrom()
     * @uses AccountDetail::setValidUntil()
     * @param \StructType\SubBalanceType[] $subBalance
     * @param \StructType\ListOfVouchers $listOfVouchers
     * @param string $internalAccountNbr
     * @param float $balance
     * @param string $usage
     * @param string $validFrom
     * @param string $validUntil
     */
    public function __construct(array $subBalance = array(), \StructType\ListOfVouchers $listOfVouchers = null, $internalAccountNbr = null, $balance = null, $usage = null, $validFrom = null, $validUntil = null)
    {
        $this
            ->setSubBalance($subBalance)
            ->setListOfVouchers($listOfVouchers)
            ->setInternalAccountNbr($internalAccountNbr)
            ->setBalance($balance)
            ->setUsage($usage)
            ->setValidFrom($validFrom)
            ->setValidUntil($validUntil);
    }
    /**
     * Get SubBalance value
     * @return \StructType\SubBalanceType[]|null
     */
    public function getSubBalance()
    {
        return $this->SubBalance;
    }
    /**
     * This method is responsible for validating the values passed to the setSubBalance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubBalance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubBalanceForArrayConstraintsFromSetSubBalance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountDetailSubBalanceItem) {
            // validation for constraint: itemType
            if (!$accountDetailSubBalanceItem instanceof \StructType\SubBalanceType) {
                $invalidValues[] = is_object($accountDetailSubBalanceItem) ? get_class($accountDetailSubBalanceItem) : sprintf('%s(%s)', gettype($accountDetailSubBalanceItem), var_export($accountDetailSubBalanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubBalance property can only contain items of type \StructType\SubBalanceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubBalance value
     * @throws \InvalidArgumentException
     * @param \StructType\SubBalanceType[] $subBalance
     * @return \StructType\AccountDetail
     */
    public function setSubBalance(array $subBalance = array())
    {
        // validation for constraint: array
        if ('' !== ($subBalanceArrayErrorMessage = self::validateSubBalanceForArrayConstraintsFromSetSubBalance($subBalance))) {
            throw new \InvalidArgumentException($subBalanceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($subBalance) && count($subBalance) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($subBalance)), __LINE__);
        }
        $this->SubBalance = $subBalance;
        return $this;
    }
    /**
     * Add item to SubBalance value
     * @throws \InvalidArgumentException
     * @param \StructType\SubBalanceType $item
     * @return \StructType\AccountDetail
     */
    public function addToSubBalance(\StructType\SubBalanceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubBalanceType) {
            throw new \InvalidArgumentException(sprintf('The SubBalance property can only contain items of type \StructType\SubBalanceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->SubBalance) && count($this->SubBalance) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->SubBalance)), __LINE__);
        }
        $this->SubBalance[] = $item;
        return $this;
    }
    /**
     * Get ListOfVouchers value
     * @return \StructType\ListOfVouchers|null
     */
    public function getListOfVouchers()
    {
        return $this->ListOfVouchers;
    }
    /**
     * Set ListOfVouchers value
     * @param \StructType\ListOfVouchers $listOfVouchers
     * @return \StructType\AccountDetail
     */
    public function setListOfVouchers(\StructType\ListOfVouchers $listOfVouchers = null)
    {
        $this->ListOfVouchers = $listOfVouchers;
        return $this;
    }
    /**
     * Get InternalAccountNbr value
     * @return string|null
     */
    public function getInternalAccountNbr()
    {
        return $this->InternalAccountNbr;
    }
    /**
     * Set InternalAccountNbr value
     * @param string $internalAccountNbr
     * @return \StructType\AccountDetail
     */
    public function setInternalAccountNbr($internalAccountNbr = null)
    {
        // validation for constraint: string
        if (!is_null($internalAccountNbr) && !is_string($internalAccountNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalAccountNbr, true), gettype($internalAccountNbr)), __LINE__);
        }
        $this->InternalAccountNbr = $internalAccountNbr;
        return $this;
    }
    /**
     * Get Balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \StructType\AccountDetail
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($balance) && mb_strlen(mb_substr($balance, false !== mb_strpos($balance, '.') ? mb_strpos($balance, '.') + 1 : mb_strlen($balance))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($balance, true), mb_strlen(mb_substr($balance, mb_strpos($balance, '.') + 1))), __LINE__);
        }
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get Usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->Usage;
    }
    /**
     * Set Usage value
     * @param string $usage
     * @return \StructType\AccountDetail
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: string
        if (!is_null($usage) && !is_string($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usage, true), gettype($usage)), __LINE__);
        }
        $this->Usage = $usage;
        return $this;
    }
    /**
     * Get ValidFrom value
     * @return string|null
     */
    public function getValidFrom()
    {
        return $this->ValidFrom;
    }
    /**
     * Set ValidFrom value
     * @param string $validFrom
     * @return \StructType\AccountDetail
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        $this->ValidFrom = $validFrom;
        return $this;
    }
    /**
     * Get ValidUntil value
     * @return string|null
     */
    public function getValidUntil()
    {
        return $this->ValidUntil;
    }
    /**
     * Set ValidUntil value
     * @param string $validUntil
     * @return \StructType\AccountDetail
     */
    public function setValidUntil($validUntil = null)
    {
        // validation for constraint: string
        if (!is_null($validUntil) && !is_string($validUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validUntil, true), gettype($validUntil)), __LINE__);
        }
        $this->ValidUntil = $validUntil;
        return $this;
    }
}
