<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getGuestSession
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $portal_id
     * @return string|bool
     */
    public function getGuestSession($portal_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getGuestSession($portal_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getActiveRoomList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $portal_id
     * @param string $count
     * @return string|bool
     */
    public function getActiveRoomList($session_id, $portal_id, $count)
    {
        try {
            $this->setResult(self::getSoapClient()->getActiveRoomList($session_id, $portal_id, $count));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getActiveRoomListForUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $portal_id
     * @param string $count
     * @return string|bool
     */
    public function getActiveRoomListForUser($session_id, $portal_id, $count)
    {
        try {
            $this->setResult(self::getSoapClient()->getActiveRoomListForUser($session_id, $portal_id, $count));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCountRooms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $portal_id
     * @return integer|bool
     */
    public function getCountRooms($session_id, $portal_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getCountRooms($session_id, $portal_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCountUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $portal_id
     * @return integer|bool
     */
    public function getCountUser($session_id, $portal_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getCountUser($session_id, $portal_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @return string|bool
     */
    public function getMaterialList($session_id, $context_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialList($session_id, $context_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPrivateRoomMaterialList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @return string|bool
     */
    public function getPrivateRoomMaterialList($session_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getPrivateRoomMaterialList($session_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSectionListFromMaterial
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $material_id
     * @return string|bool
     */
    public function getSectionListFromMaterial($session_id, $material_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getSectionListFromMaterial($session_id, $material_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFileListFromMaterial
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $material_id
     * @return string|bool
     */
    public function getFileListFromMaterial($session_id, $material_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getFileListFromMaterial($session_id, $material_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFileListFromItem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $item_id
     * @return string|bool
     */
    public function getFileListFromItem($session_id, $item_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getFileListFromItem($session_id, $item_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFileItem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $file_id
     * @return string|bool
     */
    public function getFileItem($session_id, $file_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getFileItem($session_id, $file_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBuzzwordList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @return string|bool
     */
    public function getBuzzwordList($session_id, $context_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getBuzzwordList($session_id, $context_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLabelList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @return string|bool
     */
    public function getLabelList($session_id, $context_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getLabelList($session_id, $context_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGroupList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @return string|bool
     */
    public function getGroupList($session_id, $context_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getGroupList($session_id, $context_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTopicList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @return string|bool
     */
    public function getTopicList($session_id, $context_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getTopicList($session_id, $context_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @return string|bool
     */
    public function getUserInfo($session_id, $context_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getUserInfo($session_id, $context_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRSSUrl
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @return string|bool
     */
    public function getRSSUrl($session_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getRSSUrl($session_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRoomList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @return string|bool
     */
    public function getRoomList($session_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getRoomList($session_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPortalRoomConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $portal_id
     * @return string|bool
     */
    public function getPortalRoomConfiguration($session_id, $portal_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getPortalRoomConfiguration($session_id, $portal_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRoomDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $room_id
     * @return string|bool
     */
    public function getRoomDetails($session_id, $context_id, $room_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getRoomDetails($session_id, $context_id, $room_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAuthenticationForWiki
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $user_id
     * @return string|bool
     */
    public function getAuthenticationForWiki($session_id, $context_id, $user_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getAuthenticationForWiki($session_id, $context_id, $user_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAGBFromRoom
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $context_id
     * @param string $language
     * @return string|bool
     */
    public function getAGBFromRoom($context_id, $language)
    {
        try {
            $this->setResult(self::getSoapClient()->getAGBFromRoom($context_id, $language));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStatistics
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $start_date
     * @param string $end_date
     * @return string|bool
     */
    public function getStatistics($session_id, $start_date, $end_date)
    {
        try {
            $this->setResult(self::getSoapClient()->getStatistics($session_id, $start_date, $end_date));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPortalRoomList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $portal_id
     * @return string|bool
     */
    public function getPortalRoomList($session_id, $portal_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getPortalRoomList($session_id, $portal_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPortalRoomListByCountAndSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $start
     * @param string $count
     * @param string $search
     * @param string $timeLimit
     * @param string $roomTypeLimit
     * @param string $order
     * @return string|bool
     */
    public function getPortalRoomListByCountAndSearch($session_id, $start, $count, $search, $timeLimit, $roomTypeLimit, $order)
    {
        try {
            $this->setResult(self::getSoapClient()->getPortalRoomListByCountAndSearch($session_id, $start, $count, $search, $timeLimit, $roomTypeLimit, $order));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @return string|bool
     */
    public function getUserInformation($session_id, $context_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getUserInformation($session_id, $context_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPortalConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $portal_id
     * @return string|bool
     */
    public function getPortalConfig($portal_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getPortalConfig($portal_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAuthSources
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $portal_id
     * @return string|bool
     */
    public function getAuthSources($session_id, $portal_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getAuthSources($session_id, $portal_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBarInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $portal_id
     * @return string|bool
     */
    public function getBarInformation($session_id, $portal_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getBarInformation($session_id, $portal_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContextToU
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $portal_id
     * @return string|bool
     */
    public function getContextToU($session_id, $portal_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getContextToU($session_id, $portal_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPortalList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getPortalList()
    {
        try {
            $this->setResult(self::getSoapClient()->getPortalList());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAnnouncementsInRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $valid_timestamp
     * @return string|bool
     */
    public function getAnnouncementsInRange($session_id, $context_id, $valid_timestamp)
    {
        try {
            $this->setResult(self::getSoapClient()->getAnnouncementsInRange($session_id, $context_id, $valid_timestamp));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDatesList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @return string|bool
     */
    public function getDatesList($session_id, $context_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getDatesList($session_id, $context_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDatesInRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $start_timestamp
     * @param string $end_timestamp
     * @return string|bool
     */
    public function getDatesInRange($session_id, $context_id, $start_timestamp, $end_timestamp)
    {
        try {
            $this->setResult(self::getSoapClient()->getDatesInRange($session_id, $context_id, $start_timestamp, $end_timestamp));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDateDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $item_id
     * @return string|bool
     */
    public function getDateDetails($session_id, $context_id, $item_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getDateDetails($session_id, $context_id, $item_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialsList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @return string|bool
     */
    public function getMaterialsList($session_id, $context_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialsList($session_id, $context_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $item_id
     * @return string|bool
     */
    public function getMaterialDetails($session_id, $context_id, $item_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialDetails($session_id, $context_id, $item_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDiscussionList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @return string|bool
     */
    public function getDiscussionList($session_id, $context_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getDiscussionList($session_id, $context_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDiscussionDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $item_id
     * @return string|bool
     */
    public function getDiscussionDetails($session_id, $context_id, $item_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getDiscussionDetails($session_id, $context_id, $item_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @return string|bool
     */
    public function getUserList($session_id, $context_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getUserList($session_id, $context_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRoomReadCounter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @return string|bool
     */
    public function getRoomReadCounter($session_id, $context_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getRoomReadCounter($session_id, $context_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getModerationUserList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @return string|bool
     */
    public function getModerationUserList($session_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getModerationUserList($session_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSessionIdFromConnectionKey
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $portal_id
     * @param string $user_key
     * @param string $server_key
     * @return string|bool
     */
    public function getSessionIdFromConnectionKey($session_id, $portal_id, $user_key, $server_key)
    {
        try {
            $this->setResult(self::getSoapClient()->getSessionIdFromConnectionKey($session_id, $portal_id, $user_key, $server_key));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRoomListAsJson
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @return string|bool
     */
    public function getRoomListAsJson($session_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getRoomListAsJson($session_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPortalListAsJson
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getPortalListAsJson()
    {
        try {
            $this->setResult(self::getSoapClient()->getPortalListAsJson());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOwnConnectionKey
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @return string|bool
     */
    public function getOwnConnectionKey($session_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getOwnConnectionKey($session_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return integer|string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
