<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoutingDetail StructType
 * @subpackage Structs
 */
class RoutingDetail extends AbstractStructBase
{
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $SupplierID;
    /**
     * The MerchantAccountNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MerchantAccountNumber;
    /**
     * The PSP_HostedID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PSP_HostedID;
    /**
     * The SignatureKey
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SignatureKey;
    /**
     * The OrganizationUnitID
     * Meta information extracted from the WSDL
     * - documentation: JWT Body claims - Organizaton unit ID
     * - use: optional
     * @var string
     */
    public $OrganizationUnitID;
    /**
     * The IssuerID
     * Meta information extracted from the WSDL
     * - documentation: JWT Body claims - Issuer ID
     * - use: optional
     * @var string
     */
    public $IssuerID;
    /**
     * The MacKey
     * Meta information extracted from the WSDL
     * - documentation: JWT MacKey
     * - use: optional
     * @var string
     */
    public $MacKey;
    /**
     * The ThemeID
     * Meta information extracted from the WSDL
     * - documentation: Theme ID
     * - use: optional
     * @var string
     */
    public $ThemeID;
    /**
     * The AlternateFopURL
     * Meta information extracted from the WSDL
     * - documentation: Alternate Form of Payment URL
     * - use: optional
     * @var string
     */
    public $AlternateFopURL;
    /**
     * The ApiKey
     * Meta information extracted from the WSDL
     * - documentation: Application programming interface (API) key
     * - use: optional
     * @var string
     */
    public $ApiKey;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - type: xs:string
     * @var string
     */
    public $Password;
    /**
     * Constructor method for RoutingDetail
     * @uses RoutingDetail::setSupplierID()
     * @uses RoutingDetail::setMerchantAccountNumber()
     * @uses RoutingDetail::setPSP_HostedID()
     * @uses RoutingDetail::setSignatureKey()
     * @uses RoutingDetail::setOrganizationUnitID()
     * @uses RoutingDetail::setIssuerID()
     * @uses RoutingDetail::setMacKey()
     * @uses RoutingDetail::setThemeID()
     * @uses RoutingDetail::setAlternateFopURL()
     * @uses RoutingDetail::setApiKey()
     * @uses RoutingDetail::setUserName()
     * @uses RoutingDetail::setPassword()
     * @param string $supplierID
     * @param string $merchantAccountNumber
     * @param string $pSP_HostedID
     * @param string $signatureKey
     * @param string $organizationUnitID
     * @param string $issuerID
     * @param string $macKey
     * @param string $themeID
     * @param string $alternateFopURL
     * @param string $apiKey
     * @param string $userName
     * @param string $password
     */
    public function __construct($supplierID = null, $merchantAccountNumber = null, $pSP_HostedID = null, $signatureKey = null, $organizationUnitID = null, $issuerID = null, $macKey = null, $themeID = null, $alternateFopURL = null, $apiKey = null, $userName = null, $password = null)
    {
        $this
            ->setSupplierID($supplierID)
            ->setMerchantAccountNumber($merchantAccountNumber)
            ->setPSP_HostedID($pSP_HostedID)
            ->setSignatureKey($signatureKey)
            ->setOrganizationUnitID($organizationUnitID)
            ->setIssuerID($issuerID)
            ->setMacKey($macKey)
            ->setThemeID($themeID)
            ->setAlternateFopURL($alternateFopURL)
            ->setApiKey($apiKey)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get SupplierID value
     * @return string
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \SabrePaymentGateway\StructType\RoutingDetail
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get MerchantAccountNumber value
     * @return string|null
     */
    public function getMerchantAccountNumber()
    {
        return $this->MerchantAccountNumber;
    }
    /**
     * Set MerchantAccountNumber value
     * @param string $merchantAccountNumber
     * @return \SabrePaymentGateway\StructType\RoutingDetail
     */
    public function setMerchantAccountNumber($merchantAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($merchantAccountNumber) && !is_string($merchantAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantAccountNumber, true), gettype($merchantAccountNumber)), __LINE__);
        }
        $this->MerchantAccountNumber = $merchantAccountNumber;
        return $this;
    }
    /**
     * Get PSP_HostedID value
     * @return string|null
     */
    public function getPSP_HostedID()
    {
        return $this->PSP_HostedID;
    }
    /**
     * Set PSP_HostedID value
     * @param string $pSP_HostedID
     * @return \SabrePaymentGateway\StructType\RoutingDetail
     */
    public function setPSP_HostedID($pSP_HostedID = null)
    {
        // validation for constraint: string
        if (!is_null($pSP_HostedID) && !is_string($pSP_HostedID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pSP_HostedID, true), gettype($pSP_HostedID)), __LINE__);
        }
        $this->PSP_HostedID = $pSP_HostedID;
        return $this;
    }
    /**
     * Get SignatureKey value
     * @return string|null
     */
    public function getSignatureKey()
    {
        return $this->SignatureKey;
    }
    /**
     * Set SignatureKey value
     * @param string $signatureKey
     * @return \SabrePaymentGateway\StructType\RoutingDetail
     */
    public function setSignatureKey($signatureKey = null)
    {
        // validation for constraint: string
        if (!is_null($signatureKey) && !is_string($signatureKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signatureKey, true), gettype($signatureKey)), __LINE__);
        }
        $this->SignatureKey = $signatureKey;
        return $this;
    }
    /**
     * Get OrganizationUnitID value
     * @return string|null
     */
    public function getOrganizationUnitID()
    {
        return $this->OrganizationUnitID;
    }
    /**
     * Set OrganizationUnitID value
     * @param string $organizationUnitID
     * @return \SabrePaymentGateway\StructType\RoutingDetail
     */
    public function setOrganizationUnitID($organizationUnitID = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitID) && !is_string($organizationUnitID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitID, true), gettype($organizationUnitID)), __LINE__);
        }
        $this->OrganizationUnitID = $organizationUnitID;
        return $this;
    }
    /**
     * Get IssuerID value
     * @return string|null
     */
    public function getIssuerID()
    {
        return $this->IssuerID;
    }
    /**
     * Set IssuerID value
     * @param string $issuerID
     * @return \SabrePaymentGateway\StructType\RoutingDetail
     */
    public function setIssuerID($issuerID = null)
    {
        // validation for constraint: string
        if (!is_null($issuerID) && !is_string($issuerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuerID, true), gettype($issuerID)), __LINE__);
        }
        $this->IssuerID = $issuerID;
        return $this;
    }
    /**
     * Get MacKey value
     * @return string|null
     */
    public function getMacKey()
    {
        return $this->MacKey;
    }
    /**
     * Set MacKey value
     * @param string $macKey
     * @return \SabrePaymentGateway\StructType\RoutingDetail
     */
    public function setMacKey($macKey = null)
    {
        // validation for constraint: string
        if (!is_null($macKey) && !is_string($macKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($macKey, true), gettype($macKey)), __LINE__);
        }
        $this->MacKey = $macKey;
        return $this;
    }
    /**
     * Get ThemeID value
     * @return string|null
     */
    public function getThemeID()
    {
        return $this->ThemeID;
    }
    /**
     * Set ThemeID value
     * @param string $themeID
     * @return \SabrePaymentGateway\StructType\RoutingDetail
     */
    public function setThemeID($themeID = null)
    {
        // validation for constraint: string
        if (!is_null($themeID) && !is_string($themeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($themeID, true), gettype($themeID)), __LINE__);
        }
        $this->ThemeID = $themeID;
        return $this;
    }
    /**
     * Get AlternateFopURL value
     * @return string|null
     */
    public function getAlternateFopURL()
    {
        return $this->AlternateFopURL;
    }
    /**
     * Set AlternateFopURL value
     * @param string $alternateFopURL
     * @return \SabrePaymentGateway\StructType\RoutingDetail
     */
    public function setAlternateFopURL($alternateFopURL = null)
    {
        // validation for constraint: string
        if (!is_null($alternateFopURL) && !is_string($alternateFopURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateFopURL, true), gettype($alternateFopURL)), __LINE__);
        }
        $this->AlternateFopURL = $alternateFopURL;
        return $this;
    }
    /**
     * Get ApiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->ApiKey;
    }
    /**
     * Set ApiKey value
     * @param string $apiKey
     * @return \SabrePaymentGateway\StructType\RoutingDetail
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiKey, true), gettype($apiKey)), __LINE__);
        }
        $this->ApiKey = $apiKey;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SabrePaymentGateway\StructType\RoutingDetail
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \SabrePaymentGateway\StructType\RoutingDetail
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
}
