<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Acknowledgment StructType
 * @subpackage Structs
 */
class Acknowledgment extends AbstractStructBase
{
    /**
     * The Timestamp
     * Meta information extracted from the WSDL
     * - ref: tns:Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The RefToMessageId
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - ref: tns:RefToMessageId
     * @var string
     */
    public $RefToMessageId;
    /**
     * The From
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:From
     * @var \SabrePaymentGateway\StructType\From
     */
    public $From;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Reference
     * @var \SabrePaymentGateway\StructType\Reference[]
     */
    public $Reference;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The actor
     * Meta information extracted from the WSDL
     * - ref: soap:actor
     * @var string
     */
    public $actor;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for Acknowledgment
     * @uses Acknowledgment::setTimestamp()
     * @uses Acknowledgment::setRefToMessageId()
     * @uses Acknowledgment::setFrom()
     * @uses Acknowledgment::setReference()
     * @uses Acknowledgment::setAny()
     * @uses Acknowledgment::setActor()
     * @uses Acknowledgment::setId()
     * @uses Acknowledgment::setVersion()
     * @param string $timestamp
     * @param string $refToMessageId
     * @param \SabrePaymentGateway\StructType\From $from
     * @param \SabrePaymentGateway\StructType\Reference[] $reference
     * @param \DOMDocument $any
     * @param string $actor
     * @param string $id
     * @param string $version
     */
    public function __construct($timestamp = null, $refToMessageId = null, \SabrePaymentGateway\StructType\From $from = null, array $reference = array(), \DOMDocument $any = null, $actor = null, $id = null, $version = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setRefToMessageId($refToMessageId)
            ->setFrom($from)
            ->setReference($reference)
            ->setAny($any)
            ->setActor($actor)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \SabrePaymentGateway\StructType\Acknowledgment
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get RefToMessageId value
     * @return string|null
     */
    public function getRefToMessageId()
    {
        return $this->RefToMessageId;
    }
    /**
     * Set RefToMessageId value
     * @param string $refToMessageId
     * @return \SabrePaymentGateway\StructType\Acknowledgment
     */
    public function setRefToMessageId($refToMessageId = null)
    {
        // validation for constraint: string
        if (!is_null($refToMessageId) && !is_string($refToMessageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refToMessageId, true), gettype($refToMessageId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($refToMessageId) && mb_strlen($refToMessageId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($refToMessageId)), __LINE__);
        }
        $this->RefToMessageId = $refToMessageId;
        return $this;
    }
    /**
     * Get From value
     * @return \SabrePaymentGateway\StructType\From|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param \SabrePaymentGateway\StructType\From $from
     * @return \SabrePaymentGateway\StructType\Acknowledgment
     */
    public function setFrom(\SabrePaymentGateway\StructType\From $from = null)
    {
        $this->From = $from;
        return $this;
    }
    /**
     * Get Reference value
     * @return \SabrePaymentGateway\StructType\Reference[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceForArrayConstraintsFromSetReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $acknowledgmentReferenceItem) {
            // validation for constraint: itemType
            if (!$acknowledgmentReferenceItem instanceof \SabrePaymentGateway\StructType\Reference) {
                $invalidValues[] = is_object($acknowledgmentReferenceItem) ? get_class($acknowledgmentReferenceItem) : sprintf('%s(%s)', gettype($acknowledgmentReferenceItem), var_export($acknowledgmentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Reference property can only contain items of type \SabrePaymentGateway\StructType\Reference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Reference value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Reference[] $reference
     * @return \SabrePaymentGateway\StructType\Acknowledgment
     */
    public function setReference(array $reference = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceArrayErrorMessage = self::validateReferenceForArrayConstraintsFromSetReference($reference))) {
            throw new \InvalidArgumentException($referenceArrayErrorMessage, __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Add item to Reference value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Reference $item
     * @return \SabrePaymentGateway\StructType\Acknowledgment
     */
    public function addToReference(\SabrePaymentGateway\StructType\Reference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\Reference) {
            throw new \InvalidArgumentException(sprintf('The Reference property can only contain items of type \SabrePaymentGateway\StructType\Reference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Reference[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabrePaymentGateway\StructType\Acknowledgment
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get actor value
     * @return string|null
     */
    public function getActor()
    {
        return $this->actor;
    }
    /**
     * Set actor value
     * @param string $actor
     * @return \SabrePaymentGateway\StructType\Acknowledgment
     */
    public function setActor($actor = null)
    {
        // validation for constraint: string
        if (!is_null($actor) && !is_string($actor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actor, true), gettype($actor)), __LINE__);
        }
        $this->actor = $actor;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \SabrePaymentGateway\StructType\Acknowledgment
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \SabrePaymentGateway\StructType\Acknowledgment
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($version) && mb_strlen($version) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
