<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Schema StructType
 * @subpackage Structs
 */
class Schema extends AbstractStructBase
{
    /**
     * The location
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $location;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for Schema
     * @uses Schema::setLocation()
     * @uses Schema::setVersion()
     * @param string $location
     * @param string $version
     */
    public function __construct($location = null, $version = null)
    {
        $this
            ->setLocation($location)
            ->setVersion($version);
    }
    /**
     * Get location value
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \SabrePaymentGateway\StructType\Schema
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \SabrePaymentGateway\StructType\Schema
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($version) && mb_strlen($version) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
