<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Manifest StructType
 * Meta information extracted from the WSDL
 * - type: ds:ManifestType
 * @subpackage Structs
 */
class Manifest extends AbstractStructBase
{
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: tns:Reference
     * @var \SabrePaymentGateway\StructType\Reference[]
     */
    public $Reference;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for Manifest
     * @uses Manifest::setReference()
     * @uses Manifest::setAny()
     * @uses Manifest::setId()
     * @uses Manifest::setVersion()
     * @param \SabrePaymentGateway\StructType\Reference[] $reference
     * @param \DOMDocument $any
     * @param string $id
     * @param string $version
     */
    public function __construct(array $reference = array(), \DOMDocument $any = null, $id = null, $version = null)
    {
        $this
            ->setReference($reference)
            ->setAny($any)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get Reference value
     * @return \SabrePaymentGateway\StructType\Reference[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceForArrayConstraintsFromSetReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $manifestReferenceItem) {
            // validation for constraint: itemType
            if (!$manifestReferenceItem instanceof \SabrePaymentGateway\StructType\Reference) {
                $invalidValues[] = is_object($manifestReferenceItem) ? get_class($manifestReferenceItem) : sprintf('%s(%s)', gettype($manifestReferenceItem), var_export($manifestReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Reference property can only contain items of type \SabrePaymentGateway\StructType\Reference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Reference value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Reference[] $reference
     * @return \SabrePaymentGateway\StructType\Manifest
     */
    public function setReference(array $reference = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceArrayErrorMessage = self::validateReferenceForArrayConstraintsFromSetReference($reference))) {
            throw new \InvalidArgumentException($referenceArrayErrorMessage, __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Add item to Reference value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Reference $item
     * @return \SabrePaymentGateway\StructType\Manifest
     */
    public function addToReference(\SabrePaymentGateway\StructType\Reference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\Reference) {
            throw new \InvalidArgumentException(sprintf('The Reference property can only contain items of type \SabrePaymentGateway\StructType\Reference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Reference[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabrePaymentGateway\StructType\Manifest
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \SabrePaymentGateway\StructType\Manifest
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \SabrePaymentGateway\StructType\Manifest
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($version) && mb_strlen($version) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
