<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TokensType StructType
 * @subpackage Structs
 */
class TokensType extends AbstractStructBase
{
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\Token[]
     */
    public $Token;
    /**
     * Constructor method for TokensType
     * @uses TokensType::setToken()
     * @param \SabrePaymentGateway\StructType\Token[] $token
     */
    public function __construct(array $token = array())
    {
        $this
            ->setToken($token);
    }
    /**
     * Get Token value
     * @return \SabrePaymentGateway\StructType\Token[]|null
     */
    public function getToken()
    {
        return $this->Token;
    }
    /**
     * This method is responsible for validating the values passed to the setToken method
     * This method is willingly generated in order to preserve the one-line inline validation within the setToken method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTokenForArrayConstraintsFromSetToken(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tokensTypeTokenItem) {
            // validation for constraint: itemType
            if (!$tokensTypeTokenItem instanceof \SabrePaymentGateway\StructType\Token) {
                $invalidValues[] = is_object($tokensTypeTokenItem) ? get_class($tokensTypeTokenItem) : sprintf('%s(%s)', gettype($tokensTypeTokenItem), var_export($tokensTypeTokenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Token property can only contain items of type \SabrePaymentGateway\StructType\Token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Token value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Token[] $token
     * @return \SabrePaymentGateway\StructType\TokensType
     */
    public function setToken(array $token = array())
    {
        // validation for constraint: array
        if ('' !== ($tokenArrayErrorMessage = self::validateTokenForArrayConstraintsFromSetToken($token))) {
            throw new \InvalidArgumentException($tokenArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($token) && count($token) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($token)), __LINE__);
        }
        $this->Token = $token;
        return $this;
    }
    /**
     * Add item to Token value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Token $item
     * @return \SabrePaymentGateway\StructType\TokensType
     */
    public function addToToken(\SabrePaymentGateway\StructType\Token $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\Token) {
            throw new \InvalidArgumentException(sprintf('The Token property can only contain items of type \SabrePaymentGateway\StructType\Token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->Token) && count($this->Token) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->Token)), __LINE__);
        }
        $this->Token[] = $item;
        return $this;
    }
}
