<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TokenizationResultType StructType
 * @subpackage Structs
 */
class TokenizationResultType extends AbstractStructBase
{
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ResultCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CardNumber;
    /**
     * The TokenizedCardNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TokenizedCardNumber;
    /**
     * Constructor method for TokenizationResultType
     * @uses TokenizationResultType::setResultCode()
     * @uses TokenizationResultType::setDescription()
     * @uses TokenizationResultType::setCardNumber()
     * @uses TokenizationResultType::setTokenizedCardNumber()
     * @param string $resultCode
     * @param string $description
     * @param string $cardNumber
     * @param string $tokenizedCardNumber
     */
    public function __construct($resultCode = null, $description = null, $cardNumber = null, $tokenizedCardNumber = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setDescription($description)
            ->setCardNumber($cardNumber)
            ->setTokenizedCardNumber($tokenizedCardNumber);
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \SabrePaymentGateway\StructType\TokenizationResultType
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\TokenizationResultType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \SabrePaymentGateway\StructType\TokenizationResultType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get TokenizedCardNumber value
     * @return string|null
     */
    public function getTokenizedCardNumber()
    {
        return $this->TokenizedCardNumber;
    }
    /**
     * Set TokenizedCardNumber value
     * @param string $tokenizedCardNumber
     * @return \SabrePaymentGateway\StructType\TokenizationResultType
     */
    public function setTokenizedCardNumber($tokenizedCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tokenizedCardNumber) && !is_string($tokenizedCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenizedCardNumber, true), gettype($tokenizedCardNumber)), __LINE__);
        }
        $this->TokenizedCardNumber = $tokenizedCardNumber;
        return $this;
    }
}
