<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubBalanceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Sub-balance type and amount
 * @subpackage Structs
 */
class SubBalanceType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The Usage
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Usage;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Balance;
    /**
     * Constructor method for SubBalanceType
     * @uses SubBalanceType::set_()
     * @uses SubBalanceType::setUsage()
     * @uses SubBalanceType::setBalance()
     * @param string $_
     * @param string $usage
     * @param float $balance
     */
    public function __construct($_ = null, $usage = null, $balance = null)
    {
        $this
            ->set_($_)
            ->setUsage($usage)
            ->setBalance($balance);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \SabrePaymentGateway\StructType\SubBalanceType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->Usage;
    }
    /**
     * Set Usage value
     * @param string $usage
     * @return \SabrePaymentGateway\StructType\SubBalanceType
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: string
        if (!is_null($usage) && !is_string($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usage, true), gettype($usage)), __LINE__);
        }
        $this->Usage = $usage;
        return $this;
    }
    /**
     * Get Balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \SabrePaymentGateway\StructType\SubBalanceType
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($balance) && mb_strlen(mb_substr($balance, false !== mb_strpos($balance, '.') ? mb_strpos($balance, '.') + 1 : mb_strlen($balance))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($balance, true), mb_strlen(mb_substr($balance, mb_strpos($balance, '.') + 1))), __LINE__);
        }
        $this->Balance = $balance;
        return $this;
    }
}
