<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureType StructType
 * @subpackage Structs
 */
class SignatureType extends AbstractStructBase
{
    /**
     * The SignedInfo
     * Meta information extracted from the WSDL
     * - ref: ds:SignedInfo
     * @var \SabrePaymentGateway\StructType\SignedInfoType
     */
    public $SignedInfo;
    /**
     * The SignatureValue
     * Meta information extracted from the WSDL
     * - ref: ds:SignatureValue
     * @var \SabrePaymentGateway\StructType\SignatureValueType
     */
    public $SignatureValue;
    /**
     * The KeyInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:KeyInfo
     * @var \SabrePaymentGateway\StructType\KeyInfoType
     */
    public $KeyInfo;
    /**
     * The Object
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Object
     * @var \SabrePaymentGateway\StructType\ObjectType[]
     */
    public $Object;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for SignatureType
     * @uses SignatureType::setSignedInfo()
     * @uses SignatureType::setSignatureValue()
     * @uses SignatureType::setKeyInfo()
     * @uses SignatureType::setObject()
     * @uses SignatureType::setId()
     * @param \SabrePaymentGateway\StructType\SignedInfoType $signedInfo
     * @param \SabrePaymentGateway\StructType\SignatureValueType $signatureValue
     * @param \SabrePaymentGateway\StructType\KeyInfoType $keyInfo
     * @param \SabrePaymentGateway\StructType\ObjectType[] $object
     * @param string $id
     */
    public function __construct(\SabrePaymentGateway\StructType\SignedInfoType $signedInfo = null, \SabrePaymentGateway\StructType\SignatureValueType $signatureValue = null, \SabrePaymentGateway\StructType\KeyInfoType $keyInfo = null, array $object = array(), $id = null)
    {
        $this
            ->setSignedInfo($signedInfo)
            ->setSignatureValue($signatureValue)
            ->setKeyInfo($keyInfo)
            ->setObject($object)
            ->setId($id);
    }
    /**
     * Get SignedInfo value
     * @return \SabrePaymentGateway\StructType\SignedInfoType|null
     */
    public function getSignedInfo()
    {
        return $this->SignedInfo;
    }
    /**
     * Set SignedInfo value
     * @param \SabrePaymentGateway\StructType\SignedInfoType $signedInfo
     * @return \SabrePaymentGateway\StructType\SignatureType
     */
    public function setSignedInfo(\SabrePaymentGateway\StructType\SignedInfoType $signedInfo = null)
    {
        $this->SignedInfo = $signedInfo;
        return $this;
    }
    /**
     * Get SignatureValue value
     * @return \SabrePaymentGateway\StructType\SignatureValueType|null
     */
    public function getSignatureValue()
    {
        return $this->SignatureValue;
    }
    /**
     * Set SignatureValue value
     * @param \SabrePaymentGateway\StructType\SignatureValueType $signatureValue
     * @return \SabrePaymentGateway\StructType\SignatureType
     */
    public function setSignatureValue(\SabrePaymentGateway\StructType\SignatureValueType $signatureValue = null)
    {
        $this->SignatureValue = $signatureValue;
        return $this;
    }
    /**
     * Get KeyInfo value
     * @return \SabrePaymentGateway\StructType\KeyInfoType|null
     */
    public function getKeyInfo()
    {
        return $this->KeyInfo;
    }
    /**
     * Set KeyInfo value
     * @param \SabrePaymentGateway\StructType\KeyInfoType $keyInfo
     * @return \SabrePaymentGateway\StructType\SignatureType
     */
    public function setKeyInfo(\SabrePaymentGateway\StructType\KeyInfoType $keyInfo = null)
    {
        $this->KeyInfo = $keyInfo;
        return $this;
    }
    /**
     * Get Object value
     * @return \SabrePaymentGateway\StructType\ObjectType[]|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * This method is responsible for validating the values passed to the setObject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateObjectForArrayConstraintsFromSetObject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $signatureTypeObjectItem) {
            // validation for constraint: itemType
            if (!$signatureTypeObjectItem instanceof \SabrePaymentGateway\StructType\ObjectType) {
                $invalidValues[] = is_object($signatureTypeObjectItem) ? get_class($signatureTypeObjectItem) : sprintf('%s(%s)', gettype($signatureTypeObjectItem), var_export($signatureTypeObjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Object property can only contain items of type \SabrePaymentGateway\StructType\ObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Object value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\ObjectType[] $object
     * @return \SabrePaymentGateway\StructType\SignatureType
     */
    public function setObject(array $object = array())
    {
        // validation for constraint: array
        if ('' !== ($objectArrayErrorMessage = self::validateObjectForArrayConstraintsFromSetObject($object))) {
            throw new \InvalidArgumentException($objectArrayErrorMessage, __LINE__);
        }
        $this->Object = $object;
        return $this;
    }
    /**
     * Add item to Object value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\ObjectType $item
     * @return \SabrePaymentGateway\StructType\SignatureType
     */
    public function addToObject(\SabrePaymentGateway\StructType\ObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\ObjectType) {
            throw new \InvalidArgumentException(sprintf('The Object property can only contain items of type \SabrePaymentGateway\StructType\ObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Object[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \SabrePaymentGateway\StructType\SignatureType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
