<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemarkLinesType StructType
 * @subpackage Structs
 */
class RemarkLinesType extends AbstractStructBase
{
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var string[]
     */
    public $Remark;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: e.g. INVOICE
     * @var string
     */
    public $Type;
    /**
     * Constructor method for RemarkLinesType
     * @uses RemarkLinesType::setRemark()
     * @uses RemarkLinesType::setType()
     * @param string[] $remark
     * @param string $type
     */
    public function __construct(array $remark = array(), $type = null)
    {
        $this
            ->setRemark($remark)
            ->setType($type);
    }
    /**
     * Get Remark value
     * @return string[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $remarkLinesTypeRemarkItem) {
            // validation for constraint: itemType
            if (!is_string($remarkLinesTypeRemarkItem)) {
                $invalidValues[] = is_object($remarkLinesTypeRemarkItem) ? get_class($remarkLinesTypeRemarkItem) : sprintf('%s(%s)', gettype($remarkLinesTypeRemarkItem), var_export($remarkLinesTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param string[] $remark
     * @return \SabrePaymentGateway\StructType\RemarkLinesType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($remark) && count($remark) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \SabrePaymentGateway\StructType\RemarkLinesType
     */
    public function addToRemark($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Remark) && count($this->Remark) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Remark)), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \SabrePaymentGateway\StructType\RemarkLinesType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
