<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Notification StructType
 * @subpackage Structs
 */
class Notification extends AbstractStructBase
{
    /**
     * The DeliveryAddress
     * @var string
     */
    public $DeliveryAddress;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The DeliveryDate
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DocumentType
     * @var string
     */
    public $DocumentType;
    /**
     * The CommunicationType
     * @var string
     */
    public $CommunicationType;
    /**
     * The OverrideInvoked
     * @var bool
     */
    public $OverrideInvoked;
    /**
     * The OriginalDeliveryAddress
     * @var string
     */
    public $OriginalDeliveryAddress;
    /**
     * The PlatformName
     * @var string
     */
    public $PlatformName;
    /**
     * The TrackingStatus
     * @var string
     */
    public $TrackingStatus;
    /**
     * The TrackingDateTime
     * @var string
     */
    public $TrackingDateTime;
    /**
     * Constructor method for Notification
     * @uses Notification::setDeliveryAddress()
     * @uses Notification::setStatus()
     * @uses Notification::setDeliveryDate()
     * @uses Notification::setDocumentType()
     * @uses Notification::setCommunicationType()
     * @uses Notification::setOverrideInvoked()
     * @uses Notification::setOriginalDeliveryAddress()
     * @uses Notification::setPlatformName()
     * @uses Notification::setTrackingStatus()
     * @uses Notification::setTrackingDateTime()
     * @param string $deliveryAddress
     * @param string $status
     * @param string $deliveryDate
     * @param string $documentType
     * @param string $communicationType
     * @param bool $overrideInvoked
     * @param string $originalDeliveryAddress
     * @param string $platformName
     * @param string $trackingStatus
     * @param string $trackingDateTime
     */
    public function __construct($deliveryAddress = null, $status = null, $deliveryDate = null, $documentType = null, $communicationType = null, $overrideInvoked = null, $originalDeliveryAddress = null, $platformName = null, $trackingStatus = null, $trackingDateTime = null)
    {
        $this
            ->setDeliveryAddress($deliveryAddress)
            ->setStatus($status)
            ->setDeliveryDate($deliveryDate)
            ->setDocumentType($documentType)
            ->setCommunicationType($communicationType)
            ->setOverrideInvoked($overrideInvoked)
            ->setOriginalDeliveryAddress($originalDeliveryAddress)
            ->setPlatformName($platformName)
            ->setTrackingStatus($trackingStatus)
            ->setTrackingDateTime($trackingDateTime);
    }
    /**
     * Get DeliveryAddress value
     * @return string|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param string $deliveryAddress
     * @return \SabrePaymentGateway\StructType\Notification
     */
    public function setDeliveryAddress($deliveryAddress = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryAddress) && !is_string($deliveryAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryAddress, true), gettype($deliveryAddress)), __LINE__);
        }
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \SabrePaymentGateway\StructType\Notification
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \SabrePaymentGateway\StructType\Notification
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param string $documentType
     * @return \SabrePaymentGateway\StructType\Notification
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get CommunicationType value
     * @return string|null
     */
    public function getCommunicationType()
    {
        return $this->CommunicationType;
    }
    /**
     * Set CommunicationType value
     * @param string $communicationType
     * @return \SabrePaymentGateway\StructType\Notification
     */
    public function setCommunicationType($communicationType = null)
    {
        // validation for constraint: string
        if (!is_null($communicationType) && !is_string($communicationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicationType, true), gettype($communicationType)), __LINE__);
        }
        $this->CommunicationType = $communicationType;
        return $this;
    }
    /**
     * Get OverrideInvoked value
     * @return bool|null
     */
    public function getOverrideInvoked()
    {
        return $this->OverrideInvoked;
    }
    /**
     * Set OverrideInvoked value
     * @param bool $overrideInvoked
     * @return \SabrePaymentGateway\StructType\Notification
     */
    public function setOverrideInvoked($overrideInvoked = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideInvoked) && !is_bool($overrideInvoked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideInvoked, true), gettype($overrideInvoked)), __LINE__);
        }
        $this->OverrideInvoked = $overrideInvoked;
        return $this;
    }
    /**
     * Get OriginalDeliveryAddress value
     * @return string|null
     */
    public function getOriginalDeliveryAddress()
    {
        return $this->OriginalDeliveryAddress;
    }
    /**
     * Set OriginalDeliveryAddress value
     * @param string $originalDeliveryAddress
     * @return \SabrePaymentGateway\StructType\Notification
     */
    public function setOriginalDeliveryAddress($originalDeliveryAddress = null)
    {
        // validation for constraint: string
        if (!is_null($originalDeliveryAddress) && !is_string($originalDeliveryAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalDeliveryAddress, true), gettype($originalDeliveryAddress)), __LINE__);
        }
        $this->OriginalDeliveryAddress = $originalDeliveryAddress;
        return $this;
    }
    /**
     * Get PlatformName value
     * @return string|null
     */
    public function getPlatformName()
    {
        return $this->PlatformName;
    }
    /**
     * Set PlatformName value
     * @param string $platformName
     * @return \SabrePaymentGateway\StructType\Notification
     */
    public function setPlatformName($platformName = null)
    {
        // validation for constraint: string
        if (!is_null($platformName) && !is_string($platformName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($platformName, true), gettype($platformName)), __LINE__);
        }
        $this->PlatformName = $platformName;
        return $this;
    }
    /**
     * Get TrackingStatus value
     * @return string|null
     */
    public function getTrackingStatus()
    {
        return $this->TrackingStatus;
    }
    /**
     * Set TrackingStatus value
     * @param string $trackingStatus
     * @return \SabrePaymentGateway\StructType\Notification
     */
    public function setTrackingStatus($trackingStatus = null)
    {
        // validation for constraint: string
        if (!is_null($trackingStatus) && !is_string($trackingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingStatus, true), gettype($trackingStatus)), __LINE__);
        }
        $this->TrackingStatus = $trackingStatus;
        return $this;
    }
    /**
     * Get TrackingDateTime value
     * @return string|null
     */
    public function getTrackingDateTime()
    {
        return $this->TrackingDateTime;
    }
    /**
     * Set TrackingDateTime value
     * @param string $trackingDateTime
     * @return \SabrePaymentGateway\StructType\Notification
     */
    public function setTrackingDateTime($trackingDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($trackingDateTime) && !is_string($trackingDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingDateTime, true), gettype($trackingDateTime)), __LINE__);
        }
        $this->TrackingDateTime = $trackingDateTime;
        return $this;
    }
}
